/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.FutureArrays;

public abstract class PointValues {
    public static final int MAX_NUM_BYTES = 16;
    public static final int MAX_DIMENSIONS = 8;

    public static long size(IndexReader reader, String field2) throws IOException {
        long size = 0L;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values = ctx.reader().getPointValues(field2);
            if (values == null) continue;
            size += values.size();
        }
        return size;
    }

    public static int getDocCount(IndexReader reader, String field2) throws IOException {
        int count = 0;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values = ctx.reader().getPointValues(field2);
            if (values == null) continue;
            count += values.getDocCount();
        }
        return count;
    }

    public static byte[] getMinPackedValue(IndexReader reader, String field2) throws IOException {
        byte[] minValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMinValue;
            PointValues values = ctx.reader().getPointValues(field2);
            if (values == null || (leafMinValue = values.getMinPackedValue()) == null) continue;
            if (minValue == null) {
                minValue = (byte[])leafMinValue.clone();
                continue;
            }
            int numDimensions = values.getNumIndexDimensions();
            int numBytesPerDimension = values.getBytesPerDimension();
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (FutureArrays.compareUnsigned(leafMinValue, offset, offset + numBytesPerDimension, minValue, offset, offset + numBytesPerDimension) >= 0) continue;
                System.arraycopy(leafMinValue, offset, minValue, offset, numBytesPerDimension);
            }
        }
        return minValue;
    }

    public static byte[] getMaxPackedValue(IndexReader reader, String field2) throws IOException {
        byte[] maxValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMaxValue;
            PointValues values = ctx.reader().getPointValues(field2);
            if (values == null || (leafMaxValue = values.getMaxPackedValue()) == null) continue;
            if (maxValue == null) {
                maxValue = (byte[])leafMaxValue.clone();
                continue;
            }
            int numDimensions = values.getNumIndexDimensions();
            int numBytesPerDimension = values.getBytesPerDimension();
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (FutureArrays.compareUnsigned(leafMaxValue, offset, offset + numBytesPerDimension, maxValue, offset, offset + numBytesPerDimension) <= 0) continue;
                System.arraycopy(leafMaxValue, offset, maxValue, offset, numBytesPerDimension);
            }
        }
        return maxValue;
    }

    protected PointValues() {
    }

    public abstract void intersect(IntersectVisitor var1) throws IOException;

    public abstract long estimatePointCount(IntersectVisitor var1);

    public abstract byte[] getMinPackedValue() throws IOException;

    public abstract byte[] getMaxPackedValue() throws IOException;

    public abstract int getNumDataDimensions() throws IOException;

    public abstract int getNumIndexDimensions() throws IOException;

    public abstract int getBytesPerDimension() throws IOException;

    public abstract long size();

    public abstract int getDocCount();

    public static interface IntersectVisitor {
        public void visit(int var1) throws IOException;

        public void visit(int var1, byte[] var2) throws IOException;

        public Relation compare(byte[] var1, byte[] var2);

        default public void grow(int count) {
        }
    }

    public static enum Relation {
        CELL_INSIDE_QUERY,
        CELL_OUTSIDE_QUERY,
        CELL_CROSSES_QUERY;

    }
}

