/*
 * Decompiled with CFR 0.152.
 */
package esc.index;

import esc.commons.Constants$;
import esc.commons.IndexOrganisation;
import esc.commons.IndexPerson;
import esc.commons.NormalizedDate;
import esc.commons.NormalizedName;
import esc.configuration.SimilarityConfig;
import esc.index.Indexer$;
import esc.normalization.DateNormalizer$;
import esc.normalization.NameNormalizer;
import esc.normalization.TextNormalizer$;
import esc.similarity.nameElementSimilarityDb$;
import esc.utils.Countries$;
import esc.utils.Persistence$;
import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001\u001d\u0011q!\u00138eKb,'O\u0003\u0002\u0004\t\u0005)\u0011N\u001c3fq*\tQ!A\u0002fg\u000e\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aD\u0001b\u0004\u0001\u0003\u0006\u0004%\t\u0001E\u0001\fS:$W\r_,sSR,'/F\u0001\u0012!\t\u0011\"$D\u0001\u0014\u0015\t\u0019AC\u0003\u0002\u0016-\u00051A.^2f]\u0016T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO&\u00111d\u0005\u0002\f\u0013:$W\r_,sSR,'\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0012\u00031Ig\u000eZ3y/JLG/\u001a:!\u0011!y\u0002A!b\u0001\n\u0003\u0001\u0013\u0001E:j[&d\u0017M]5us\u000e{gNZ5h+\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0005\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011ae\t\u0002\u0011'&l\u0017\u000e\\1sSRL8i\u001c8gS\u001eD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0012g&l\u0017\u000e\\1sSRL8i\u001c8gS\u001e\u0004\u0003\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-]=\u0002\"!\f\u0001\u000e\u0003\tAQaD\u0015A\u0002EAqaH\u0015\u0011\u0002\u0003\u0007\u0011\u0005C\u00042\u0001\t\u0007I\u0011\u0002\u001a\u0002\u001d9\fW.\u001a(pe6\fG.\u001b>feV\t1\u0007\u0005\u00025o5\tQG\u0003\u00027\t\u0005ian\u001c:nC2L'0\u0019;j_:L!\u0001O\u001b\u0003\u001d9\u000bW.\u001a(pe6\fG.\u001b>fe\"1!\b\u0001Q\u0001\nM\nqB\\1nK:{'/\\1mSj,'\u000f\t\u0005\u0006y\u0001!\t!P\u0001\u0006G2|7/\u001a\u000b\u0002}A\u0011\u0011bP\u0005\u0003\u0001*\u0011qAQ8pY\u0016\fg\u000eC\u0003C\u0001\u0011\u0005Q(\u0001\u0004d_6l\u0017\u000e\u001e\u0005\u0006\t\u0002!\t!R\u0001\nC\u0012$\u0007+\u001a:t_:$\"A\u0010$\t\u000b\u001d\u001b\u0005\u0019\u0001%\u0002\rA,'o]8o!\tIE*D\u0001K\u0015\tYE!A\u0004d_6lwN\\:\n\u00055S%aC%oI\u0016D\b+\u001a:t_:DQa\u0014\u0001\u0005\u0002A\u000bq\"\u00193e\u001fJ<\u0017M\\5tCRLwN\u001c\u000b\u0003}ECQA\u0015(A\u0002M\u000bAb\u001c:hC:L7/\u0019;j_:\u0004\"!\u0013+\n\u0005US%!E%oI\u0016DxJ]4b]&\u001c\u0018\r^5p]\")q\u000b\u0001C\u00011\u0006aQ\u000f\u001d3bi\u0016\u0004VM]:p]R\u0011a(\u0017\u0005\u0006\u000fZ\u0003\r\u0001\u0013\u0005\u00067\u0002!\t\u0001X\u0001\u0013kB$\u0017\r^3Pe\u001e\fg.[:bi&|g\u000e\u0006\u0002?;\")!K\u0017a\u0001'\")q\f\u0001C\u0001A\u0006a!/Z7pm\u0016\u0004VM]:p]R\u0011a(\u0019\u0005\u0006Ez\u0003\raY\u0001\ta\u0016\u00148o\u001c8JIB\u0011Am\u001b\b\u0003K&\u0004\"A\u001a\u0006\u000e\u0003\u001dT!\u0001\u001b\u0004\u0002\rq\u0012xn\u001c;?\u0013\tQ'\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016\u000b\u0011\u0015y\u0007\u0001\"\u0001q\u0003I\u0011X-\\8wK>\u0013x-\u00198jg\u0006$\u0018n\u001c8\u0015\u0005y\n\b\"\u0002:o\u0001\u0004\u0019\u0017AD8sO\u0006t\u0017n]1uS>t\u0017\n\u001a\u0005\u0006i\u0002!I!^\u0001\u000fGJ,\u0017\r^3E_\u000e,X.\u001a8u)E1HP`A\u0001\u0003\u000b\ty!a\u0005\u0002\u0018\u00055\u0012\u0011\u0007\t\u0003ojl\u0011\u0001\u001f\u0006\u0003sR\t\u0001\u0002Z8dk6,g\u000e^\u0005\u0003wb\u0014\u0001\u0002R8dk6,g\u000e\u001e\u0005\u0006{N\u0004\raY\u0001\u0003S\u0012DQa`:A\u0002\r\f!\"\u001a=uKJt\u0017\r\\%e\u0011\u0019\t\u0019a\u001da\u0001G\u0006Aa-\u001e7m\u001d\u0006lW\rC\u0004\u0002\bM\u0004\r!!\u0003\u0002\u001d9|'/\\1mSj,GMT1nKB\u0019\u0011*a\u0003\n\u0007\u00055!J\u0001\bO_Jl\u0017\r\\5{K\u0012t\u0015-\\3\t\r\u0005E1\u000f1\u0001d\u0003!Q7o\u001c8OC6,\u0007BBA\u000bg\u0002\u00071-\u0001\u0005oC6,G+\u001f9f\u0011\u001d\tIb\u001da\u0001\u00037\tQ\u0001Z1uKN\u0004R!!\b\u0002(\rtA!a\b\u0002$9\u0019a-!\t\n\u0003-I1!!\n\u000b\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000b\u0002,\t!A*[:u\u0015\r\t)C\u0003\u0005\b\u0003_\u0019\b\u0019AA\u000e\u0003%\u0019w.\u001e8ue&,7\u000f\u0003\u0004\u00024M\u0004\raY\u0001\u0006Y\u0006\u0014W\r\\\u0004\n\u0003o\u0011\u0011\u0011!E\u0001\u0003s\tq!\u00138eKb,'\u000fE\u0002.\u0003w1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QH\n\u0004\u0003wA\u0001b\u0002\u0016\u0002<\u0011\u0005\u0011\u0011\t\u000b\u0003\u0003sA!\"!\u0012\u0002<E\u0005I\u0011AA$\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\n\u0016\u0004C\u0005-3FAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]#\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0017\u0002R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class Indexer {
    private final IndexWriter indexWriter;
    private final SimilarityConfig similarityConfig;
    private final NameNormalizer nameNormalizer;

    public static SimilarityConfig $lessinit$greater$default$2() {
        return Indexer$.MODULE$.$lessinit$greater$default$2();
    }

    public IndexWriter indexWriter() {
        return this.indexWriter;
    }

    public SimilarityConfig similarityConfig() {
        return this.similarityConfig;
    }

    private NameNormalizer nameNormalizer() {
        return this.nameNormalizer;
    }

    public boolean close() {
        this.indexWriter().close();
        return true;
    }

    public boolean commit() {
        this.indexWriter().commit();
        return true;
    }

    public boolean addPerson(IndexPerson person) {
        NormalizedName normalizedName = this.nameNormalizer().normalizePersonName(person.fullName());
        this.indexWriter().addDocument(this.createDocument(person.id(), person.externalId(), person.fullName(), normalizedName, Persistence$.MODULE$.NormalizedNameVectorSerializer(normalizedName.normNames()).toCompactJson(), Constants$.MODULE$.IndexPersonNameTypeCode(), person.datesOfBirth(), person.countries(), person.label()));
        return true;
    }

    public boolean addOrganisation(IndexOrganisation organisation) {
        NormalizedName normalizedName = this.nameNormalizer().normalizeOrganisationName(organisation.fullName());
        this.indexWriter().addDocument(this.createDocument(organisation.id(), organisation.externalId(), organisation.fullName(), normalizedName, Persistence$.MODULE$.NormalizedNameVectorSerializer(normalizedName.normNames()).toCompactJson(), Constants$.MODULE$.IndexOrganisationNameTypeCode(), organisation.datesOfFounding(), organisation.countries(), organisation.label()));
        return true;
    }

    public boolean updatePerson(IndexPerson person) {
        NormalizedName normalizedName = this.nameNormalizer().normalizePersonName(person.fullName());
        this.indexWriter().updateDocument(new Term("id", person.id()), (Iterable<? extends IndexableField>)this.createDocument(person.id(), person.externalId(), person.fullName(), normalizedName, Persistence$.MODULE$.NormalizedNameVectorSerializer(normalizedName.normNames()).toCompactJson(), Constants$.MODULE$.IndexPersonNameTypeCode(), person.datesOfBirth(), person.countries(), person.label()));
        return true;
    }

    public boolean updateOrganisation(IndexOrganisation organisation) {
        NormalizedName normalizedName = this.nameNormalizer().normalizeOrganisationName(organisation.fullName());
        this.indexWriter().updateDocument(new Term("id", organisation.id()), (Iterable<? extends IndexableField>)this.createDocument(organisation.id(), organisation.externalId(), organisation.fullName(), normalizedName, Persistence$.MODULE$.NormalizedNameVectorSerializer(normalizedName.normNames()).toCompactJson(), Constants$.MODULE$.IndexOrganisationNameTypeCode(), organisation.datesOfFounding(), organisation.countries(), organisation.label()));
        return true;
    }

    public boolean removePerson(String personId) {
        this.indexWriter().deleteDocuments(new Term("id", personId));
        return true;
    }

    public boolean removeOrganisation(String organisationId) {
        this.indexWriter().deleteDocuments(new Term("id", organisationId));
        return true;
    }

    private Document createDocument(String id, String externalId, String fullName, NormalizedName normalizedName, String jsonName, String nameType, List<String> dates, List<String> countries, String label) {
        Document doc = new Document();
        doc.add(new StringField("id", id, Field.Store.YES));
        doc.add(new StringField("exid", externalId, Field.Store.YES));
        doc.add(new StringField("name", fullName, Field.Store.YES));
        ObjectRef<ListBuffer> nameDoc = ObjectRef.create((ListBuffer)ListBuffer$.MODULE$.empty());
        normalizedName.normNames().foreach((Function1<Vector, Object> & Serializable & scala.Serializable)variant -> {
            variant.foreach((Function1<Tuple3, Object> & Serializable & scala.Serializable)element -> {
                Object object;
                byte by = BoxesRunTime.unboxToByte(element._3());
                switch (by) {
                    case 1: {
                        boolean bl;
                        Object object2;
                        boolean bl2;
                        Tuple2<Object, Object> tuple2 = $this.nameNormalizer().persNameElementReducedWeight((String)element._1(), 1.0);
                        if (tuple2 != null && !(bl2 = tuple2._2$mcZ$sp())) {
                            ((ListBuffer)nameDoc$1.elem).$plus$eq(nameElementSimilarityDb$.MODULE$.getMatchList((String)element._1(), $this.similarityConfig().nameElementSimilarityForHit()).mkString(" "));
                            object2 = ((ListBuffer)nameDoc$1.elem).$plus$eq(new StringOps(Predef$.MODULE$.augmentString((String)element._1())).sliding(3).toList().mkString(" "));
                        } else if (tuple2 != null && (bl = tuple2._2$mcZ$sp())) {
                            object2 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(tuple2);
                        }
                        object = object2;
                        break;
                    }
                    default: {
                        object = ((ListBuffer)nameDoc$1.elem).$plus$eq(element._1());
                        break;
                    }
                }
                return object;
            });
            return BoxedUnit.UNIT;
        });
        doc.add(new TextField("doc", ((ListBuffer)nameDoc.elem).mkString(" "), Field.Store.NO));
        doc.add(new StringField("json", jsonName, Field.Store.YES));
        List csList = (List)((TraversableLike)countries.map((Function1<String, String> & Serializable & scala.Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.CountryList(TextNormalizer$.MODULE$.normalize((String)c)).toIsoCountry();
            if (tuple2 != null) {
                boolean bl = tuple2._1$mcZ$sp();
                String x = tuple2._2();
                if (bl) {
                    return x;
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            boolean bl = tuple2._1$mcZ$sp();
            if (false != bl) throw new MatchError(tuple2);
            return " ";
        }, List$.MODULE$.canBuildFrom())).filter((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(Indexer.$anonfun$createDocument$4(x$1)));
        int n = csList.length();
        switch (n) {
            case 0: {
                doc.add(new TextField("cs", "xx", Field.Store.NO));
                break;
            }
            default: {
                doc.add(new TextField("cs", csList.mkString(" "), Field.Store.YES));
                break;
            }
        }
        List ysList = (List)((TraversableLike)dates.map((Function1<String, String> & Serializable & scala.Serializable)y -> {
            String string;
            NormalizedDate nd = DateNormalizer$.MODULE$.normalizeDate((String)y);
            byte by = nd.dateType();
            switch (by) {
                case 99: {
                    string = " ";
                    break;
                }
                default: {
                    string = ((Object)BoxesRunTime.boxToInteger(nd.year())).toString();
                    break;
                }
            }
            return string;
        }, List$.MODULE$.canBuildFrom())).filter((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Indexer.$anonfun$createDocument$6(x$2)));
        int n2 = ysList.length();
        switch (n2) {
            case 0: {
                doc.add(new TextField("ys", "9999", Field.Store.NO));
                break;
            }
            default: {
                doc.add(new TextField("ys", ysList.mkString(" "), Field.Store.NO));
                break;
            }
        }
        doc.add(new StringField("l", label, Field.Store.YES));
        doc.add(new StringField("t", nameType, Field.Store.YES));
        return doc;
    }

    public static final /* synthetic */ boolean $anonfun$createDocument$4(String x$1) {
        String string = x$1;
        String string2 = " ";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$createDocument$6(String x$2) {
        String string = x$2;
        String string2 = " ";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public Indexer(IndexWriter indexWriter, SimilarityConfig similarityConfig) {
        this.indexWriter = indexWriter;
        this.similarityConfig = similarityConfig;
        this.nameNormalizer = new NameNormalizer(similarityConfig);
    }
}

