/*
 * Decompiled with CFR 0.152.
 */
package esc.normalization;

import esc.commons.NormalizedDate;
import esc.utils.BasicFunctions$;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class DateNormalizer$ {
    public static DateNormalizer$ MODULE$;
    private final Regex yyyyMMdds;
    private final Regex mMMMdyyyy;
    private final Regex ddMMyyyy;
    private final Regex dMMyyyy;
    private final Regex ddMyyyy;
    private final Regex dMyyyy;
    private final Regex yyyyMMdd;
    private final Regex yyyyMMd;
    private final Regex yyyyMd;
    private final Regex yyyyMdd;
    private final Regex yyyyMM;
    private final Regex yyyyM;
    private final Regex yyyy;

    static {
        new DateNormalizer$();
    }

    private Regex yyyyMMdds() {
        return this.yyyyMMdds;
    }

    private Regex mMMMdyyyy() {
        return this.mMMMdyyyy;
    }

    private Regex ddMMyyyy() {
        return this.ddMMyyyy;
    }

    private Regex dMMyyyy() {
        return this.dMMyyyy;
    }

    private Regex ddMyyyy() {
        return this.ddMyyyy;
    }

    private Regex dMyyyy() {
        return this.dMyyyy;
    }

    private Regex yyyyMMdd() {
        return this.yyyyMMdd;
    }

    private Regex yyyyMMd() {
        return this.yyyyMMd;
    }

    private Regex yyyyMd() {
        return this.yyyyMd;
    }

    private Regex yyyyMdd() {
        return this.yyyyMdd;
    }

    private Regex yyyyMM() {
        return this.yyyyMM;
    }

    private Regex yyyyM() {
        return this.yyyyM;
    }

    private Regex yyyy() {
        return this.yyyy;
    }

    public NormalizedDate normalizeDate(String dateString) {
        String mutDateString;
        String string = dateString;
        if (BasicFunctions$.MODULE$.isNullOrEmpty(string)) {
            return new NormalizedDate(0, 0, 0, 99);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String string2 = mutDateString = dateString.replace("-", ".").replace("/", ".");
        Option<List<String>> option = this.yyyyMMdds().unapplySeq(string2);
        if (!option.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.BASIC_ISO_DATE);
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option2 = this.mMMMdyyyy().unapplySeq(string2);
        if (!option2.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("MMMM d, yyyy", Locale.ENGLISH));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option3 = this.ddMMyyyy().unapplySeq(string2);
        if (!option3.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("dd.MM.yyyy"));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option4 = this.dMMyyyy().unapplySeq(string2);
        if (!option4.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("d.MM.yyyy"));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option5 = this.ddMyyyy().unapplySeq(string2);
        if (!option5.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("dd.M.yyyy"));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option6 = this.dMyyyy().unapplySeq(string2);
        if (!option6.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("d.M.yyyy"));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option7 = this.yyyyMMdd().unapplySeq(string2);
        if (!option7.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("yyyy.MM.dd", Locale.ENGLISH));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option8 = this.yyyyMMd().unapplySeq(string2);
        if (!option8.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("yyyy.MM.d", Locale.ENGLISH));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option9 = this.yyyyMdd().unapplySeq(string2);
        if (!option9.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("yyyy.M.dd", Locale.ENGLISH));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option10 = this.yyyyMd().unapplySeq(string2);
        if (!option10.isEmpty()) {
            try {
                LocalDate fromCustomPattern = LocalDate.parse(mutDateString, DateTimeFormatter.ofPattern("yyyy.M.d", Locale.ENGLISH));
                return new NormalizedDate(fromCustomPattern.getYear(), fromCustomPattern.getMonth().getValue(), fromCustomPattern.getDayOfMonth(), 0);
            }
            catch (Throwable throwable) {
                return new NormalizedDate(0, 0, 0, 99);
            }
        }
        Option<List<String>> option11 = this.yyyyMM().unapplySeq(string2);
        if (!option11.isEmpty()) {
            String[] na = mutDateString.split("\\.");
            int n = new StringOps(Predef$.MODULE$.augmentString(na[1])).toInt();
            switch (n) {
                default: 
            }
            if (n < 13 && n > 0) {
                return new NormalizedDate(new StringOps(Predef$.MODULE$.augmentString(na[0])).toInt(), n, 0, 1);
            }
            return new NormalizedDate(0, 0, 0, 99);
        }
        Option<List<String>> option12 = this.yyyyM().unapplySeq(string2);
        if (!option12.isEmpty()) {
            String[] na = mutDateString.split("\\.");
            int n = new StringOps(Predef$.MODULE$.augmentString(na[1])).toInt();
            switch (n) {
                default: 
            }
            if (n < 13 && n > 0) {
                return new NormalizedDate(new StringOps(Predef$.MODULE$.augmentString(na[0])).toInt(), n, 0, 1);
            }
            return new NormalizedDate(0, 0, 0, 99);
        }
        Option<List<String>> option13 = this.yyyy().unapplySeq(string2);
        if (!option13.isEmpty()) {
            return new NormalizedDate(new StringOps(Predef$.MODULE$.augmentString(mutDateString)).toInt(), 0, 0, 2);
        }
        return new NormalizedDate(0, 0, 0, 99);
    }

    private DateNormalizer$() {
        MODULE$ = this;
        this.yyyyMMdds = new StringOps(Predef$.MODULE$.augmentString("[0-9]{8}")).r();
        this.mMMMdyyyy = new StringOps(Predef$.MODULE$.augmentString("[a-zA-Z]+ {1}\\d{1,2},{1} {1}\\d{4}")).r();
        this.ddMMyyyy = new StringOps(Predef$.MODULE$.augmentString("[0-9]{2}.[0-9]{2}.[0-9]{4}")).r();
        this.dMMyyyy = new StringOps(Predef$.MODULE$.augmentString("[0-9]{1}.[0-9]{2}.[0-9]{4}")).r();
        this.ddMyyyy = new StringOps(Predef$.MODULE$.augmentString("[0-9]{2}.[0-9]{1}.[0-9]{4}")).r();
        this.dMyyyy = new StringOps(Predef$.MODULE$.augmentString("[0-9]{1}.[0-9]{1}.[0-9]{4}")).r();
        this.yyyyMMdd = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4}.[0-9]{2}.[0-9]{2}")).r();
        this.yyyyMMd = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4}.[0-9]{2}.[0-9]{1}")).r();
        this.yyyyMd = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4}.[0-9]{1}.[0-9]{1}")).r();
        this.yyyyMdd = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4}.[0-9]{1}.[0-9]{2}")).r();
        this.yyyyMM = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4}.[0-9]{2}")).r();
        this.yyyyM = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4}.[0-9]{1}")).r();
        this.yyyy = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4}")).r();
    }
}

