/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class IntPoint
extends Field {
    private static FieldType getType(int numDims) {
        FieldType type = new FieldType();
        type.setDimensions(numDims, 4);
        type.freeze();
        return type;
    }

    @Override
    public void setIntValue(int value) {
        this.setIntValues(value);
    }

    public void setIntValues(int ... point) {
        if (this.type.pointDataDimensionCount() != point.length) {
            throw new IllegalArgumentException("this field (name=" + this.name + ") uses " + this.type.pointDataDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions");
        }
        this.fieldsData = IntPoint.pack(point);
    }

    @Override
    public void setBytesValue(BytesRef bytes) {
        throw new IllegalArgumentException("cannot change value type from int to BytesRef");
    }

    @Override
    public Number numericValue() {
        if (this.type.pointDataDimensionCount() != 1) {
            throw new IllegalStateException("this field (name=" + this.name + ") uses " + this.type.pointDataDimensionCount() + " dimensions; cannot convert to a single numeric value");
        }
        BytesRef bytes = (BytesRef)this.fieldsData;
        assert (bytes.length == 4);
        return IntPoint.decodeDimension(bytes.bytes, bytes.offset);
    }

    private static BytesRef pack(int ... point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        byte[] packed = new byte[point.length * 4];
        for (int dim = 0; dim < point.length; ++dim) {
            IntPoint.encodeDimension(point[dim], packed, dim * 4);
        }
        return new BytesRef(packed);
    }

    public IntPoint(String name, int ... point) {
        super(name, IntPoint.pack(point), (IndexableFieldType)IntPoint.getType(point.length));
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        for (int dim = 0; dim < this.type.pointDataDimensionCount(); ++dim) {
            if (dim > 0) {
                result.append(',');
            }
            result.append(IntPoint.decodeDimension(bytes.bytes, bytes.offset + dim * 4));
        }
        result.append('>');
        return result.toString();
    }

    public static void encodeDimension(int value, byte[] dest, int offset) {
        NumericUtils.intToSortableBytes(value, dest, offset);
    }

    public static int decodeDimension(byte[] value, int offset) {
        return NumericUtils.sortableBytesToInt(value, offset);
    }

    public static Query newExactQuery(String field2, int value) {
        return IntPoint.newRangeQuery(field2, value, value);
    }

    public static Query newRangeQuery(String field2, int lowerValue, int upperValue) {
        return IntPoint.newRangeQuery(field2, new int[]{lowerValue}, new int[]{upperValue});
    }

    public static Query newRangeQuery(String field2, int[] lowerValue, int[] upperValue) {
        PointRangeQuery.checkArgs(field2, lowerValue, upperValue);
        return new PointRangeQuery(field2, IntPoint.pack((int[])lowerValue).bytes, IntPoint.pack((int[])upperValue).bytes, lowerValue.length){

            @Override
            protected String toString(int dimension, byte[] value) {
                return Integer.toString(IntPoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field2, int ... values) {
        final int[] sortedValues = (int[])values.clone();
        Arrays.sort(sortedValues);
        final BytesRef encoded = new BytesRef(new byte[4]);
        return new PointInSetQuery(field2, 1, 4, new PointInSetQuery.Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                IntPoint.encodeDimension(sortedValues[this.upto], encoded.bytes, 0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 4);
                return Integer.toString(IntPoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field2, Collection<Integer> values) {
        Integer[] boxed = values.toArray(new Integer[0]);
        int[] unboxed = new int[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            unboxed[i] = boxed[i];
        }
        return IntPoint.newSetQuery(field2, unboxed);
    }
}

