/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesRangeQuery;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;

public class NumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public NumericDocValuesField(String name, long value) {
        this(name, (Long)value);
    }

    public NumericDocValuesField(String name, Long value) {
        super(name, TYPE);
        this.fieldsData = value;
    }

    public static Query newSlowRangeQuery(String field2, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field2, lowerValue, upperValue){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field2) throws IOException {
                NumericDocValues values = reader.getNumericDocValues(field2);
                if (values == null) {
                    return null;
                }
                return DocValues.singleton(values);
            }
        };
    }

    public static Query newSlowExactQuery(String field2, long value) {
        return NumericDocValuesField.newSlowRangeQuery(field2, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.NUMERIC);
        TYPE.freeze();
    }
}

