/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import org.apache.lucene.search.intervals.IntervalIterator;

abstract class DifferenceIntervalFunction {
    static final DifferenceIntervalFunction NON_OVERLAPPING = new SingletonFunction("NON_OVERLAPPING"){

        @Override
        public IntervalIterator apply(IntervalIterator minuend, IntervalIterator subtrahend) {
            return new NonOverlappingIterator(minuend, subtrahend);
        }
    };
    static final DifferenceIntervalFunction NOT_CONTAINING = new SingletonFunction("NOT_CONTAINING"){

        @Override
        public IntervalIterator apply(IntervalIterator minuend, IntervalIterator subtrahend) {
            return new NotContainingIterator(minuend, subtrahend);
        }
    };
    static final DifferenceIntervalFunction NOT_CONTAINED_BY = new SingletonFunction("NOT_CONTAINED_BY"){

        @Override
        public IntervalIterator apply(IntervalIterator minuend, IntervalIterator subtrahend) {
            return new NotContainedByIterator(minuend, subtrahend);
        }
    };

    DifferenceIntervalFunction() {
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public abstract IntervalIterator apply(IntervalIterator var1, IntervalIterator var2);

    private static abstract class SingletonFunction
    extends DifferenceIntervalFunction {
        private final String name;

        SingletonFunction(String name) {
            this.name = name;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class NotContainedByIterator
    extends RelativeIterator {
        NotContainedByIterator(IntervalIterator a, IntervalIterator b) {
            super(a, b);
        }

        @Override
        public int nextInterval() throws IOException {
            if (!this.bpos) {
                return this.a.nextInterval();
            }
            while (this.a.nextInterval() != Integer.MAX_VALUE) {
                while (this.b.end() < this.a.end()) {
                    if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                    return this.a.start();
                }
                if (this.a.start() >= this.b.start()) continue;
                return this.a.start();
            }
            return Integer.MAX_VALUE;
        }
    }

    private static class NotContainingIterator
    extends RelativeIterator {
        private NotContainingIterator(IntervalIterator minuend, IntervalIterator subtrahend) {
            super(minuend, subtrahend);
        }

        @Override
        public int nextInterval() throws IOException {
            if (!this.bpos) {
                return this.a.nextInterval();
            }
            while (this.a.nextInterval() != Integer.MAX_VALUE) {
                while (this.b.start() < this.a.start() && this.b.end() < this.a.end()) {
                    if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                    this.bpos = false;
                    return this.a.start();
                }
                if (this.b.start() <= this.a.end()) continue;
                return this.a.start();
            }
            return Integer.MAX_VALUE;
        }
    }

    private static class NonOverlappingIterator
    extends RelativeIterator {
        private NonOverlappingIterator(IntervalIterator minuend, IntervalIterator subtrahend) {
            super(minuend, subtrahend);
        }

        @Override
        public int nextInterval() throws IOException {
            if (!this.bpos) {
                return this.a.nextInterval();
            }
            while (this.a.nextInterval() != Integer.MAX_VALUE) {
                while (this.b.end() < this.a.start()) {
                    if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                    this.bpos = false;
                    return this.a.start();
                }
                if (this.b.start() <= this.a.end()) continue;
                return this.a.start();
            }
            return Integer.MAX_VALUE;
        }
    }

    private static abstract class RelativeIterator
    extends IntervalIterator {
        final IntervalIterator a;
        final IntervalIterator b;
        boolean bpos;

        RelativeIterator(IntervalIterator a, IntervalIterator b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public int docID() {
            return this.a.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int doc = this.a.nextDoc();
            this.reset();
            return doc;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc = this.a.advance(target);
            this.reset();
            return doc;
        }

        @Override
        public long cost() {
            return this.a.cost();
        }

        protected void reset() throws IOException {
            int doc = this.a.docID();
            this.bpos = this.b.docID() == doc || this.b.docID() < doc && this.b.advance(doc) == doc;
        }

        @Override
        public int start() {
            return this.a.start();
        }

        @Override
        public int end() {
            return this.a.end();
        }

        @Override
        public int gaps() {
            return this.a.gaps();
        }

        @Override
        public float matchCost() {
            return this.a.matchCost() + this.b.matchCost();
        }
    }
}

