/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.intervals.ExtendedIntervalIterator;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalMatches;
import org.apache.lucene.search.intervals.IntervalsSource;

class ExtendedIntervalsSource
extends IntervalsSource {
    final IntervalsSource source;
    private final int before;
    private final int after;

    ExtendedIntervalsSource(IntervalsSource source, int before, int after) {
        this.source = source;
        this.before = before;
        this.after = after;
    }

    @Override
    public IntervalIterator intervals(String field2, LeafReaderContext ctx) throws IOException {
        IntervalIterator in = this.source.intervals(field2, ctx);
        if (in == null) {
            return null;
        }
        return new ExtendedIntervalIterator(in, this.before, this.after);
    }

    @Override
    public MatchesIterator matches(String field2, LeafReaderContext ctx, int doc) throws IOException {
        MatchesIterator in = this.source.matches(field2, ctx, doc);
        if (in == null) {
            return null;
        }
        ExtendedIntervalIterator wrapped = new ExtendedIntervalIterator(IntervalMatches.wrapMatches(in, doc), this.before, this.after);
        return IntervalMatches.asMatches(wrapped, in, doc);
    }

    @Override
    public void extractTerms(String field2, Set<Term> terms) {
        this.source.extractTerms(field2, terms);
    }

    @Override
    public int minExtent() {
        int minExtent = this.before + this.source.minExtent() + this.after;
        if (minExtent < 0) {
            return Integer.MAX_VALUE;
        }
        return minExtent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedIntervalsSource that = (ExtendedIntervalsSource)o;
        return this.before == that.before && this.after == that.after && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.before, this.after);
    }

    @Override
    public String toString() {
        return "EXTEND(" + this.source + "," + this.before + "," + this.after + ")";
    }
}

