/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.intervals.IntervalFilter;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalMatches;
import org.apache.lucene.search.intervals.IntervalsSource;

public abstract class FilteredIntervalsSource
extends IntervalsSource {
    private final String name;
    private final IntervalsSource in;

    public FilteredIntervalsSource(String name, IntervalsSource in) {
        this.name = name;
        this.in = in;
    }

    protected abstract boolean accept(IntervalIterator var1);

    @Override
    public IntervalIterator intervals(String field2, LeafReaderContext ctx) throws IOException {
        IntervalIterator i = this.in.intervals(field2, ctx);
        if (i == null) {
            return null;
        }
        return new IntervalFilter(i){

            @Override
            protected boolean accept() {
                return FilteredIntervalsSource.this.accept(this.in);
            }
        };
    }

    @Override
    public MatchesIterator matches(String field2, LeafReaderContext ctx, int doc) throws IOException {
        MatchesIterator mi = this.in.matches(field2, ctx, doc);
        if (mi == null) {
            return null;
        }
        IntervalFilter filtered = new IntervalFilter(IntervalMatches.wrapMatches(mi, doc)){

            @Override
            protected boolean accept() {
                return FilteredIntervalsSource.this.accept(this.in);
            }
        };
        return IntervalMatches.asMatches(filtered, mi, doc);
    }

    @Override
    public int minExtent() {
        return this.in.minExtent();
    }

    @Override
    public void extractTerms(String field2, Set<Term> terms) {
        this.in.extractTerms(field2, terms);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredIntervalsSource that = (FilteredIntervalsSource)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.in, that.in);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.in);
    }

    @Override
    public String toString() {
        return this.name + "(" + this.in + ")";
    }
}

