/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalsSource;

class FixedFieldIntervalsSource
extends IntervalsSource {
    private final String field;
    private final IntervalsSource source;

    FixedFieldIntervalsSource(String field2, IntervalsSource source) {
        this.field = field2;
        this.source = source;
    }

    @Override
    public IntervalIterator intervals(String field2, LeafReaderContext ctx) throws IOException {
        return this.source.intervals(this.field, ctx);
    }

    @Override
    public MatchesIterator matches(String field2, LeafReaderContext ctx, int doc) throws IOException {
        return this.source.matches(this.field, ctx, doc);
    }

    @Override
    public void extractTerms(String field2, Set<Term> terms) {
        this.source.extractTerms(this.field, terms);
    }

    @Override
    public int minExtent() {
        return this.source.minExtent();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedFieldIntervalsSource that = (FixedFieldIntervalsSource)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.source);
    }

    @Override
    public String toString() {
        return "FIELD(" + this.field + "," + this.source + ")";
    }
}

