/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

final class BinaryDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private PagedGrowableWriter offsets = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
    private PagedGrowableWriter lengths = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
    private BytesRefBuilder values = new BytesRefBuilder();

    public BinaryDocValuesFieldUpdates(long delGen, String field2, int maxDoc) {
        super(maxDoc, delGen, field2, DocValuesType.BINARY);
    }

    @Override
    public void add(int doc, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int docId, DocValuesFieldUpdates.Iterator iterator) {
        this.add(docId, iterator.binaryValue());
    }

    @Override
    public synchronized void add(int doc, BytesRef value) {
        int index = this.add(doc);
        this.offsets.set(index, this.values.length());
        this.lengths.set(index, value.length);
        this.values.append(value);
    }

    @Override
    protected void swap(int i, int j) {
        super.swap(i, j);
        long tmpOffset = this.offsets.get(j);
        this.offsets.set(j, this.offsets.get(i));
        this.offsets.set(i, tmpOffset);
        long tmpLength = this.lengths.get(j);
        this.lengths.set(j, this.lengths.get(i));
        this.lengths.set(i, tmpLength);
    }

    @Override
    protected void grow(int size) {
        super.grow(size);
        this.offsets = (PagedGrowableWriter)this.offsets.grow(size);
        this.lengths = (PagedGrowableWriter)this.lengths.grow(size);
    }

    @Override
    protected void resize(int size) {
        super.resize(size);
        this.offsets = (PagedGrowableWriter)this.offsets.resize(size);
        this.lengths = (PagedGrowableWriter)this.lengths.resize(size);
    }

    @Override
    public Iterator iterator() {
        this.ensureFinished();
        return new Iterator(this.size, this.offsets, this.lengths, this.docs, this.values.get(), this.delGen);
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + this.offsets.ramBytesUsed() + this.lengths.ramBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8L + (long)(3 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + (long)this.values.bytes().length;
    }

    static final class Iterator
    extends DocValuesFieldUpdates.AbstractIterator {
        private final PagedGrowableWriter offsets;
        private final PagedGrowableWriter lengths;
        private final BytesRef value;
        private int offset;
        private int length;

        Iterator(int size, PagedGrowableWriter offsets, PagedGrowableWriter lengths, PagedMutable docs, BytesRef values, long delGen) {
            super(size, docs, delGen);
            this.offsets = offsets;
            this.lengths = lengths;
            this.value = values.clone();
        }

        @Override
        BytesRef binaryValue() {
            this.value.offset = this.offset;
            this.value.length = this.length;
            return this.value;
        }

        @Override
        protected void set(long idx) {
            this.offset = (int)this.offsets.get(idx);
            this.length = (int)this.lengths.get(idx);
        }

        @Override
        long longValue() {
            throw new UnsupportedOperationException();
        }
    }
}

