/*
 * Decompiled with CFR 0.152.
 */
package esc.index;

import esc.commons.Constants$;
import esc.commons.IndexOrganisation;
import esc.commons.IndexPerson;
import esc.commons.NormalizedDate;
import esc.commons.NormalizedName;
import esc.configuration.SimilarityConfig;
import esc.index.Indexer$;
import esc.normalization.DateNormalizer$;
import esc.normalization.NameNormalizer;
import esc.normalization.TextNormalizer$;
import esc.similarity.nameElementSimilarityDb$;
import esc.utils.Countries$;
import esc.utils.Persistence$;
import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\u000b\u0017\u0001mA\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\t_\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u00033\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u001dy\u0004A1A\u0005\n\u0001Caa\u0012\u0001!\u0002\u0013\t\u0005\"\u0002%\u0001\t\u0003I\u0005\"B'\u0001\t\u0003I\u0005\"\u0002(\u0001\t\u0003y\u0005\"\u0002-\u0001\t\u0003I\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u00022\u0001\t\u0003\u0019\u0007\"B3\u0001\t\u00031\u0007\"\u0002;\u0001\t\u0003)\b\"\u0002=\u0001\t\u0013Ix!CA\u001f-\u0005\u0005\t\u0012AA \r!)b#!A\t\u0002\u0005\u0005\u0003BB\u001d\u0013\t\u0003\t\u0019\u0005C\u0005\u0002FI\t\n\u0011\"\u0001\u0002H\t9\u0011J\u001c3fq\u0016\u0014(BA\f\u0019\u0003\u0015Ig\u000eZ3y\u0015\u0005I\u0012aA3tG\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\u0006Y\u0011N\u001c3fq^\u0013\u0018\u000e^3s+\u0005!\u0003CA\u0013.\u001b\u00051#BA\f(\u0015\tA\u0013&\u0001\u0004mk\u000e,g.\u001a\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014x-\u0003\u0002/M\tY\u0011J\u001c3fq^\u0013\u0018\u000e^3s\u00031Ig\u000eZ3y/JLG/\u001a:!\u0003A\u0019\u0018.\\5mCJLG/_\"p]\u001aLw-F\u00013!\t\u0019d'D\u00015\u0015\t)\u0004$A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003oQ\u0012\u0001cU5nS2\f'/\u001b;z\u0007>tg-[4\u0002#MLW.\u001b7be&$\u0018pQ8oM&<\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004wur\u0004C\u0001\u001f\u0001\u001b\u00051\u0002\"\u0002\u0012\u0006\u0001\u0004!\u0003b\u0002\u0019\u0006!\u0003\u0005\rAM\u0001\u000f]\u0006lWMT8s[\u0006d\u0017N_3s+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0019\u00035qwN]7bY&T\u0018\r^5p]&\u0011ai\u0011\u0002\u000f\u001d\u0006lWMT8s[\u0006d\u0017N_3s\u0003=q\u0017-\\3O_Jl\u0017\r\\5{KJ\u0004\u0013!B2m_N,G#\u0001&\u0011\u0005uY\u0015B\u0001'\u001f\u0005\u001d\u0011un\u001c7fC:\faaY8n[&$\u0018!C1eIB+'o]8o)\tQ\u0005\u000bC\u0003R\u0015\u0001\u0007!+\u0001\u0004qKJ\u001cxN\u001c\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+b\tqaY8n[>t7/\u0003\u0002X)\nY\u0011J\u001c3fqB+'o]8o\u0003=\tG\rZ(sO\u0006t\u0017n]1uS>tGC\u0001&[\u0011\u0015Y6\u00021\u0001]\u00031y'oZ1oSN\fG/[8o!\t\u0019V,\u0003\u0002_)\n\t\u0012J\u001c3fq>\u0013x-\u00198jg\u0006$\u0018n\u001c8\u0002\u0019U\u0004H-\u0019;f!\u0016\u00148o\u001c8\u0015\u0005)\u000b\u0007\"B)\r\u0001\u0004\u0011\u0016AE;qI\u0006$Xm\u0014:hC:L7/\u0019;j_:$\"A\u00133\t\u000bmk\u0001\u0019\u0001/\u0002\u0019I,Wn\u001c<f!\u0016\u00148o\u001c8\u0015\u0005);\u0007\"\u00025\u000f\u0001\u0004I\u0017\u0001\u00039feN|g.\u00133\u0011\u0005)\fhBA6p!\tag$D\u0001n\u0015\tq'$\u0001\u0004=e>|GOP\u0005\u0003az\ta\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\u0019\u0019FO]5oO*\u0011\u0001OH\u0001\u0013e\u0016lwN^3Pe\u001e\fg.[:bi&|g\u000e\u0006\u0002Km\")qo\u0004a\u0001S\u0006qqN]4b]&\u001c\u0018\r^5p]&#\u0017AD2sK\u0006$X\rR8dk6,g\u000e\u001e\u000b\u0014u\u0006\u0005\u0011QAA\u0005\u0003\u001b\t9\"a\u0007\u0002 \u0005U\u0012\u0011\b\t\u0003wzl\u0011\u0001 \u0006\u0003{\u001e\n\u0001\u0002Z8dk6,g\u000e^\u0005\u0003\u007fr\u0014\u0001\u0002R8dk6,g\u000e\u001e\u0005\u0007\u0003\u0007\u0001\u0002\u0019A5\u0002\u0005%$\u0007BBA\u0004!\u0001\u0007\u0011.\u0001\u0006fqR,'O\\1m\u0013\u0012Da!a\u0003\u0011\u0001\u0004I\u0017\u0001\u00034vY2t\u0015-\\3\t\u000f\u0005=\u0001\u00031\u0001\u0002\u0012\u0005qan\u001c:nC2L'0\u001a3OC6,\u0007cA*\u0002\u0014%\u0019\u0011Q\u0003+\u0003\u001d9{'/\\1mSj,GMT1nK\"1\u0011\u0011\u0004\tA\u0002%\f\u0001B[:p]:\u000bW.\u001a\u0005\u0007\u0003;\u0001\u0002\u0019A5\u0002\u00119\fW.\u001a+za\u0016Dq!!\t\u0011\u0001\u0004\t\u0019#A\u0003eCR,7\u000fE\u0003\u0002&\u0005=\u0012N\u0004\u0003\u0002(\u0005-bb\u00017\u0002*%\tq$C\u0002\u0002.y\tq\u0001]1dW\u0006<W-\u0003\u0003\u00022\u0005M\"\u0001\u0002'jgRT1!!\f\u001f\u0011\u001d\t9\u0004\u0005a\u0001\u0003G\t\u0011bY8v]R\u0014\u0018.Z:\t\r\u0005m\u0002\u00031\u0001j\u0003\u0015a\u0017MY3m\u0003\u001dIe\u000eZ3yKJ\u0004\"\u0001\u0010\n\u0014\u0005IaBCAA \u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\n\u0016\u0004e\u0005-3FAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]c$\u0001\u0006b]:|G/\u0019;j_:LA!a\u0017\u0002R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class Indexer {
    private final IndexWriter indexWriter;
    private final SimilarityConfig similarityConfig;
    private final NameNormalizer nameNormalizer;

    public static SimilarityConfig $lessinit$greater$default$2() {
        return Indexer$.MODULE$.$lessinit$greater$default$2();
    }

    public IndexWriter indexWriter() {
        return this.indexWriter;
    }

    public SimilarityConfig similarityConfig() {
        return this.similarityConfig;
    }

    private NameNormalizer nameNormalizer() {
        return this.nameNormalizer;
    }

    public boolean close() {
        this.indexWriter().close();
        return true;
    }

    public boolean commit() {
        this.indexWriter().commit();
        return true;
    }

    public boolean addPerson(IndexPerson person) {
        NormalizedName normalizedName = this.nameNormalizer().normalizePersonName(person.fullName());
        this.indexWriter().addDocument(this.createDocument(person.id(), person.externalId(), person.fullName(), normalizedName, Persistence$.MODULE$.NormalizedNameVectorSerializer(normalizedName.normNames()).toCompactJson(), Constants$.MODULE$.IndexPersonNameTypeCode(), person.datesOfBirth(), person.countries(), person.label()));
        return true;
    }

    public boolean addOrganisation(IndexOrganisation organisation) {
        NormalizedName normalizedName = this.nameNormalizer().normalizeOrganisationName(organisation.fullName());
        this.indexWriter().addDocument(this.createDocument(organisation.id(), organisation.externalId(), organisation.fullName(), normalizedName, Persistence$.MODULE$.NormalizedNameVectorSerializer(normalizedName.normNames()).toCompactJson(), Constants$.MODULE$.IndexOrganisationNameTypeCode(), organisation.datesOfFounding(), organisation.countries(), organisation.label()));
        return true;
    }

    public boolean updatePerson(IndexPerson person) {
        NormalizedName normalizedName = this.nameNormalizer().normalizePersonName(person.fullName());
        this.indexWriter().updateDocument(new Term("id", person.id()), (Iterable<? extends IndexableField>)this.createDocument(person.id(), person.externalId(), person.fullName(), normalizedName, Persistence$.MODULE$.NormalizedNameVectorSerializer(normalizedName.normNames()).toCompactJson(), Constants$.MODULE$.IndexPersonNameTypeCode(), person.datesOfBirth(), person.countries(), person.label()));
        return true;
    }

    public boolean updateOrganisation(IndexOrganisation organisation) {
        NormalizedName normalizedName = this.nameNormalizer().normalizeOrganisationName(organisation.fullName());
        this.indexWriter().updateDocument(new Term("id", organisation.id()), (Iterable<? extends IndexableField>)this.createDocument(organisation.id(), organisation.externalId(), organisation.fullName(), normalizedName, Persistence$.MODULE$.NormalizedNameVectorSerializer(normalizedName.normNames()).toCompactJson(), Constants$.MODULE$.IndexOrganisationNameTypeCode(), organisation.datesOfFounding(), organisation.countries(), organisation.label()));
        return true;
    }

    public boolean removePerson(String personId) {
        this.indexWriter().deleteDocuments(new Term("id", personId));
        return true;
    }

    public boolean removeOrganisation(String organisationId) {
        this.indexWriter().deleteDocuments(new Term("id", organisationId));
        return true;
    }

    private Document createDocument(String id, String externalId, String fullName, NormalizedName normalizedName, String jsonName, String nameType, List<String> dates, List<String> countries, String label) {
        Document doc = new Document();
        doc.add(new StringField("id", id, Field.Store.YES));
        doc.add(new StringField("exid", externalId, Field.Store.YES));
        doc.add(new StringField("name", fullName, Field.Store.YES));
        ObjectRef<Object> nameDoc = ObjectRef.create(ListBuffer$.MODULE$.empty());
        normalizedName.normNames().foreach((Function1<Vector, Object> & Serializable)variant -> {
            variant.foreach((Function1<Tuple3, Object> & Serializable)element -> {
                Object object;
                byte by = BoxesRunTime.unboxToByte(element._3());
                switch (by) {
                    case 1: {
                        boolean bl;
                        Object object2;
                        boolean bl2;
                        Tuple2<Object, Object> tuple2 = $this.nameNormalizer().persNameElementReducedWeight((String)element._1(), 1.0);
                        if (tuple2 != null && !(bl2 = tuple2._2$mcZ$sp())) {
                            ((ListBuffer)nameDoc$1.elem).$plus$eq(nameElementSimilarityDb$.MODULE$.getMatchList((String)element._1(), $this.similarityConfig().nameElementSimilarityForHit()).mkString(" "));
                            String qual$1 = Predef$.MODULE$.augmentString((String)element._1());
                            int x$1 = 3;
                            int x$2 = StringOps$.MODULE$.sliding$default$2$extension(qual$1);
                            object2 = ((ListBuffer)nameDoc$1.elem).$plus$eq(StringOps$.MODULE$.sliding$extension(qual$1, 3, x$2).toList().mkString(" "));
                        } else if (tuple2 != null && (bl = tuple2._2$mcZ$sp())) {
                            object2 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(tuple2);
                        }
                        object = object2;
                        break;
                    }
                    default: {
                        object = ((ListBuffer)nameDoc$1.elem).$plus$eq(element._1());
                        break;
                    }
                }
                return object;
            });
            return BoxedUnit.UNIT;
        });
        doc.add(new TextField("doc", ((ListBuffer)nameDoc.elem).mkString(" "), Field.Store.NO));
        doc.add(new StringField("json", jsonName, Field.Store.YES));
        Object csList = ((List)countries.map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.CountryList(TextNormalizer$.MODULE$.normalize((String)c)).toIsoCountry();
            if (tuple2 != null) {
                boolean bl = tuple2._1$mcZ$sp();
                String x = tuple2._2();
                if (bl) {
                    return x;
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            boolean bl = tuple2._1$mcZ$sp();
            if (false != bl) throw new MatchError(tuple2);
            return " ";
        })).filter((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(Indexer.$anonfun$createDocument$4(x$1)));
        int n = ((List)csList).length();
        switch (n) {
            case 0: {
                doc.add(new TextField("cs", "xx", Field.Store.NO));
                break;
            }
            default: {
                doc.add(new TextField("cs", ((AbstractIterable)csList).mkString(" "), Field.Store.YES));
                break;
            }
        }
        Object ysList = ((List)dates.map((Function1<String, String> & Serializable)y -> {
            String string;
            NormalizedDate nd = DateNormalizer$.MODULE$.normalizeDate((String)y);
            byte by = nd.dateType();
            switch (by) {
                case 99: {
                    string = " ";
                    break;
                }
                default: {
                    string = ((Object)BoxesRunTime.boxToInteger(nd.year())).toString();
                    break;
                }
            }
            return string;
        })).filter((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(Indexer.$anonfun$createDocument$6(x$2)));
        int n2 = ((List)ysList).length();
        switch (n2) {
            case 0: {
                doc.add(new TextField("ys", "9999", Field.Store.NO));
                break;
            }
            default: {
                doc.add(new TextField("ys", ((AbstractIterable)ysList).mkString(" "), Field.Store.NO));
                break;
            }
        }
        doc.add(new StringField("l", label, Field.Store.YES));
        doc.add(new StringField("t", nameType, Field.Store.YES));
        return doc;
    }

    public static final /* synthetic */ boolean $anonfun$createDocument$4(String x$1) {
        String string = x$1;
        String string2 = " ";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$createDocument$6(String x$2) {
        String string = x$2;
        String string2 = " ";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public Indexer(IndexWriter indexWriter, SimilarityConfig similarityConfig) {
        this.indexWriter = indexWriter;
        this.similarityConfig = similarityConfig;
        this.nameNormalizer = new NameNormalizer(similarityConfig);
    }
}

