/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Polygon2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYPolygon2D;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class XYShapePolygonQuery
extends ShapeQuery {
    final XYPolygon[] polygons;
    private final Polygon2D poly2D;

    public XYShapePolygonQuery(String field2, ShapeField.QueryRelation queryRelation, XYPolygon ... polygons) {
        super(field2, queryRelation);
        if (polygons == null) {
            throw new IllegalArgumentException("polygons must not be null");
        }
        if (polygons.length == 0) {
            throw new IllegalArgumentException("polygons must not be empty");
        }
        for (int i = 0; i < polygons.length; ++i) {
            if (polygons[i] == null) {
                throw new IllegalArgumentException("polygon[" + i + "] must not be null");
            }
            if (polygons[i].minX > polygons[i].maxX) {
                throw new IllegalArgumentException("XYShapePolygonQuery: minX cannot be greater than maxX.");
            }
            if (!(polygons[i].minY > polygons[i].maxY)) continue;
            throw new IllegalArgumentException("XYShapePolygonQuery: minY cannot be greater than maxY.");
        }
        this.polygons = (XYPolygon[])polygons.clone();
        this.poly2D = XYPolygon2D.create(polygons);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, minYOffset));
        double minLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, minXOffset));
        double maxLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, maxYOffset));
        double maxLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, maxXOffset));
        return this.poly2D.relate(minLat, maxLat, minLon, maxLon);
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = XYEncodingUtils.decode(scratchTriangle.aY);
        double alon = XYEncodingUtils.decode(scratchTriangle.aX);
        double blat = XYEncodingUtils.decode(scratchTriangle.bY);
        double blon = XYEncodingUtils.decode(scratchTriangle.bX);
        double clat = XYEncodingUtils.decode(scratchTriangle.cY);
        double clon = XYEncodingUtils.decode(scratchTriangle.cX);
        switch (queryRelation) {
            case INTERSECTS: {
                return this.poly2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            case WITHIN: {
                return this.poly2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
            }
            case DISJOINT: {
                return this.poly2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field2)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("XYPolygon(").append(this.polygons[0].toGeoJSON()).append(")");
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.polygons, ((XYShapePolygonQuery)o).polygons);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.polygons);
        return hash;
    }
}

