/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene80;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene80.IndexedDISI;
import org.apache.lucene.codecs.lucene80.Lucene80DocValuesFormat;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.compress.LZ4;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.apache.lucene.util.packed.DirectWriter;

final class Lucene80DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    final Lucene80DocValuesFormat.Mode mode;
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;
    private final SegmentWriteState state;
    private byte[] termsDictBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene80DocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension, Lucene80DocValuesFormat.Mode mode) throws IOException {
        this.mode = mode;
        if (Lucene80DocValuesFormat.Mode.BEST_COMPRESSION == this.mode) {
            this.termsDictBuffer = new byte[16384];
        }
        boolean success = false;
        try {
            this.state = state;
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 2, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 2, state.segmentInfo.getId(), state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    @Override
    public void addNumericField(FieldInfo field2, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)0);
        this.writeValues(field2, new EmptyDocValuesProducer(){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
                return DocValues.singleton(valuesProducer.getNumeric(field2));
            }
        });
    }

    private long[] writeValues(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        int numBitsPerValue;
        SortedNumericDocValues values = valuesProducer.getSortedNumeric(field2);
        int numDocsWithValue = 0;
        MinMaxTracker minMax = new MinMaxTracker();
        MinMaxTracker blockMinMax = new MinMaxTracker();
        long gcd = 0L;
        HashSet<Long> uniqueValues = new HashSet<Long>();
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = values.nextValue();
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (minMax.numValues != 0L) {
                        gcd = MathUtil.gcd(gcd, v - minMax.min);
                    }
                }
                minMax.update(v);
                blockMinMax.update(v);
                if (blockMinMax.numValues == 16384L) {
                    blockMinMax.nextBlock();
                }
                if (uniqueValues == null || !uniqueValues.add(v) || uniqueValues.size() <= 256) continue;
                uniqueValues = null;
            }
            ++numDocsWithValue;
            doc = values.nextDoc();
        }
        minMax.finish();
        blockMinMax.finish();
        long numValues = minMax.numValues;
        long min = minMax.min;
        long max = minMax.max;
        assert (blockMinMax.spaceInBits <= minMax.spaceInBits);
        if (numDocsWithValue == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (numDocsWithValue == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getSortedNumeric(field2);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(values, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
        }
        this.meta.writeLong(numValues);
        boolean doBlocks = false;
        HashMap<Object, Integer> encode = null;
        if (min >= max) {
            numBitsPerValue = 0;
            this.meta.writeInt(-1);
        } else if (uniqueValues != null && uniqueValues.size() > 1 && DirectWriter.unsignedBitsRequired(uniqueValues.size() - 1) < DirectWriter.unsignedBitsRequired((max - min) / gcd)) {
            numBitsPerValue = DirectWriter.unsignedBitsRequired(uniqueValues.size() - 1);
            Object[] sortedUniqueValues = uniqueValues.toArray(new Long[0]);
            Arrays.sort(sortedUniqueValues);
            this.meta.writeInt(sortedUniqueValues.length);
            for (Object v : sortedUniqueValues) {
                this.meta.writeLong((Long)v);
            }
            encode = new HashMap<Object, Integer>();
            for (int i = 0; i < sortedUniqueValues.length; ++i) {
                encode.put(sortedUniqueValues[i], i);
            }
            min = 0L;
            gcd = 1L;
        } else {
            uniqueValues = null;
            boolean bl = doBlocks = minMax.spaceInBits > 0L && (double)blockMinMax.spaceInBits / (double)minMax.spaceInBits <= 0.9;
            if (doBlocks) {
                numBitsPerValue = 255;
                this.meta.writeInt(-16);
            } else {
                numBitsPerValue = DirectWriter.unsignedBitsRequired((max - min) / gcd);
                if (gcd == 1L && min > 0L && DirectWriter.unsignedBitsRequired(max) == DirectWriter.unsignedBitsRequired(max - min)) {
                    min = 0L;
                }
                this.meta.writeInt(-1);
            }
        }
        this.meta.writeByte((byte)numBitsPerValue);
        this.meta.writeLong(min);
        this.meta.writeLong(gcd);
        long startOffset = this.data.getFilePointer();
        this.meta.writeLong(startOffset);
        long jumpTableOffset = -1L;
        if (doBlocks) {
            jumpTableOffset = this.writeValuesMultipleBlocks(valuesProducer.getSortedNumeric(field2), gcd);
        } else if (numBitsPerValue != 0) {
            this.writeValuesSingleBlock(valuesProducer.getSortedNumeric(field2), numValues, numBitsPerValue, min, gcd, encode);
        }
        this.meta.writeLong(this.data.getFilePointer() - startOffset);
        this.meta.writeLong(jumpTableOffset);
        return new long[]{numDocsWithValue, numValues};
    }

    private void writeValuesSingleBlock(SortedNumericDocValues values, long numValues, int numBitsPerValue, long min, long gcd, Map<Long, Integer> encode) throws IOException {
        DirectWriter writer = DirectWriter.getInstance(this.data, numValues, numBitsPerValue);
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = values.nextValue();
                if (encode == null) {
                    writer.add((v - min) / gcd);
                    continue;
                }
                writer.add(encode.get(v).intValue());
            }
            doc = values.nextDoc();
        }
        writer.finish();
    }

    private long writeValuesMultipleBlocks(SortedNumericDocValues values, long gcd) throws IOException {
        long[] offsets = new long[ArrayUtil.oversize(1, 8)];
        int offsetsIndex = 0;
        long[] buffer = new long[16384];
        ByteBuffersDataOutput encodeBuffer = ByteBuffersDataOutput.newResettableInstance();
        int upTo = 0;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values.docValueCount();
            for (int i = 0; i < count; ++i) {
                buffer[upTo++] = values.nextValue();
                if (upTo != 16384) continue;
                offsets = ArrayUtil.grow(offsets, offsetsIndex + 1);
                offsets[offsetsIndex++] = this.data.getFilePointer();
                this.writeBlock(buffer, 16384, gcd, encodeBuffer);
                upTo = 0;
            }
            doc = values.nextDoc();
        }
        if (upTo > 0) {
            offsets = ArrayUtil.grow(offsets, offsetsIndex + 1);
            offsets[offsetsIndex++] = this.data.getFilePointer();
            this.writeBlock(buffer, upTo, gcd, encodeBuffer);
        }
        long offsetsOrigo = this.data.getFilePointer();
        for (int i = 0; i < offsetsIndex; ++i) {
            this.data.writeLong(offsets[i]);
        }
        this.data.writeLong(offsetsOrigo);
        return offsetsOrigo;
    }

    private void writeBlock(long[] values, int length, long gcd, ByteBuffersDataOutput buffer) throws IOException {
        assert (length > 0);
        long min = values[0];
        long max = values[0];
        for (int i = 1; i < length; ++i) {
            long v = values[i];
            assert (Math.floorMod(values[i] - min, gcd) == 0L);
            min = Math.min(min, v);
            max = Math.max(max, v);
        }
        if (min == max) {
            this.data.writeByte((byte)0);
            this.data.writeLong(min);
        } else {
            int bitsPerValue = DirectWriter.unsignedBitsRequired((max - min) / gcd);
            buffer.reset();
            assert (buffer.size() == 0L);
            DirectWriter w = DirectWriter.getInstance(buffer, length, bitsPerValue);
            for (int i = 0; i < length; ++i) {
                w.add((values[i] - min) / gcd);
            }
            w.finish();
            this.data.writeByte((byte)bitsPerValue);
            this.data.writeLong(min);
            this.data.writeInt(Math.toIntExact(buffer.size()));
            buffer.copyTo(this.data);
        }
    }

    @Override
    public void addBinaryField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        field2.putAttribute(Lucene80DocValuesFormat.MODE_KEY, this.mode.name());
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)1);
        switch (this.mode) {
            case BEST_SPEED: {
                this.doAddUncompressedBinaryField(field2, valuesProducer);
                break;
            }
            case BEST_COMPRESSION: {
                this.doAddCompressedBinaryField(field2, valuesProducer);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void doAddUncompressedBinaryField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        BinaryDocValues values = valuesProducer.getBinary(field2);
        long start = this.data.getFilePointer();
        this.meta.writeLong(start);
        int numDocsWithField = 0;
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            BytesRef v = values.binaryValue();
            int length = v.length;
            this.data.writeBytes(v.bytes, v.offset, v.length);
            minLength = Math.min(length, minLength);
            maxLength = Math.max(length, maxLength);
            doc = values.nextDoc();
        }
        assert (numDocsWithField <= this.maxDoc);
        this.meta.writeLong(this.data.getFilePointer() - start);
        if (numDocsWithField == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getBinary(field2);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(values, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
        }
        this.meta.writeInt(numDocsWithField);
        this.meta.writeInt(minLength);
        this.meta.writeInt(maxLength);
        if (maxLength > minLength) {
            start = this.data.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, this.data, numDocsWithField + 1, 16);
            long addr = 0L;
            writer.add(addr);
            values = valuesProducer.getBinary(field2);
            int doc2 = values.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                writer.add(addr += (long)values.binaryValue().length);
                doc2 = values.nextDoc();
            }
            writer.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    private void doAddCompressedBinaryField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        try (CompressedBinaryBlockWriter blockWriter = new CompressedBinaryBlockWriter();){
            BinaryDocValues values = valuesProducer.getBinary(field2);
            long start = this.data.getFilePointer();
            this.meta.writeLong(start);
            int numDocsWithField = 0;
            int minLength = Integer.MAX_VALUE;
            int maxLength = 0;
            int doc = values.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ++numDocsWithField;
                BytesRef v = values.binaryValue();
                blockWriter.addDoc(doc, v);
                int length = v.length;
                minLength = Math.min(length, minLength);
                maxLength = Math.max(length, maxLength);
                doc = values.nextDoc();
            }
            blockWriter.flushData();
            assert (numDocsWithField <= this.maxDoc);
            this.meta.writeLong(this.data.getFilePointer() - start);
            if (numDocsWithField == 0) {
                this.meta.writeLong(-2L);
                this.meta.writeLong(0L);
                this.meta.writeShort((short)-1);
                this.meta.writeByte((byte)-1);
            } else if (numDocsWithField == this.maxDoc) {
                this.meta.writeLong(-1L);
                this.meta.writeLong(0L);
                this.meta.writeShort((short)-1);
                this.meta.writeByte((byte)-1);
            } else {
                long offset = this.data.getFilePointer();
                this.meta.writeLong(offset);
                values = valuesProducer.getBinary(field2);
                short jumpTableEntryCount = IndexedDISI.writeBitSet(values, this.data, (byte)9);
                this.meta.writeLong(this.data.getFilePointer() - offset);
                this.meta.writeShort(jumpTableEntryCount);
                this.meta.writeByte((byte)9);
            }
            this.meta.writeInt(numDocsWithField);
            this.meta.writeInt(minLength);
            this.meta.writeInt(maxLength);
            blockWriter.writeMetaData();
        }
    }

    @Override
    public void addSortedField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)2);
        this.doAddSortedField(field2, valuesProducer);
    }

    private void doAddSortedField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        SortedDocValues values = valuesProducer.getSorted(field2);
        int numDocsWithField = 0;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            doc = values.nextDoc();
        }
        if (numDocsWithField == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getSorted(field2);
            short jumpTableentryCount = IndexedDISI.writeBitSet(values, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableentryCount);
            this.meta.writeByte((byte)9);
        }
        this.meta.writeInt(numDocsWithField);
        if (values.getValueCount() <= 1) {
            this.meta.writeByte((byte)0);
            this.meta.writeLong(0L);
            this.meta.writeLong(0L);
        } else {
            int numberOfBitsPerOrd = DirectWriter.unsignedBitsRequired(values.getValueCount() - 1);
            this.meta.writeByte((byte)numberOfBitsPerOrd);
            long start = this.data.getFilePointer();
            this.meta.writeLong(start);
            DirectWriter writer = DirectWriter.getInstance(this.data, numDocsWithField, numberOfBitsPerOrd);
            values = valuesProducer.getSorted(field2);
            int doc2 = values.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                writer.add(values.ordValue());
                doc2 = values.nextDoc();
            }
            writer.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
        this.addTermsDict(DocValues.singleton(valuesProducer.getSorted(field2)));
    }

    private void addTermsDict(SortedSetDocValues values) throws IOException {
        int shift;
        int blockMask;
        int code;
        boolean compress;
        long size = values.getValueCount();
        this.meta.writeVLong(size);
        boolean bl = compress = Lucene80DocValuesFormat.Mode.BEST_COMPRESSION == this.mode && values.getValueCount() > 32L;
        if (compress) {
            code = 393217;
            blockMask = 63;
            shift = 6;
        } else {
            shift = 4;
            code = 4;
            blockMask = 15;
        }
        this.meta.writeInt(code);
        this.meta.writeInt(16);
        ByteBuffersDataOutput addressBuffer = new ByteBuffersDataOutput();
        ByteBuffersIndexOutput addressOutput = new ByteBuffersIndexOutput(addressBuffer, "temp", "temp");
        long numBlocks = size + (long)blockMask >>> shift;
        DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, addressOutput, numBlocks, 16);
        BytesRefBuilder previous = new BytesRefBuilder();
        long ord = 0L;
        long start = this.data.getFilePointer();
        int maxLength = 0;
        int maxBlockLength = 0;
        TermsEnum iterator = values.termsEnum();
        LZ4.FastCompressionHashTable ht = null;
        ByteArrayDataOutput bufferedOutput = null;
        if (compress) {
            ht = new LZ4.FastCompressionHashTable();
            bufferedOutput = new ByteArrayDataOutput(this.termsDictBuffer);
        }
        BytesRef term = iterator.next();
        while (term != null) {
            if ((ord & (long)blockMask) == 0L) {
                if (compress && bufferedOutput.getPosition() > 0) {
                    maxBlockLength = Math.max(maxBlockLength, this.compressAndGetTermsDictBlockLength(bufferedOutput, ht));
                    bufferedOutput.reset(this.termsDictBuffer);
                }
                writer.add(this.data.getFilePointer() - start);
                this.data.writeVInt(term.length);
                this.data.writeBytes(term.bytes, term.offset, term.length);
            } else {
                DataOutput blockOutput;
                int prefixLength = StringHelper.bytesDifference(previous.get(), term);
                int suffixLength = term.length - prefixLength;
                assert (suffixLength > 0);
                if (compress) {
                    bufferedOutput = this.maybeGrowBuffer(bufferedOutput, suffixLength + 11);
                    blockOutput = bufferedOutput;
                } else {
                    blockOutput = this.data;
                }
                blockOutput.writeByte((byte)(Math.min(prefixLength, 15) | Math.min(15, suffixLength - 1) << 4));
                if (prefixLength >= 15) {
                    blockOutput.writeVInt(prefixLength - 15);
                }
                if (suffixLength >= 16) {
                    blockOutput.writeVInt(suffixLength - 16);
                }
                blockOutput.writeBytes(term.bytes, term.offset + prefixLength, suffixLength);
            }
            maxLength = Math.max(maxLength, term.length);
            previous.copyBytes(term);
            ++ord;
            term = iterator.next();
        }
        if (compress && bufferedOutput.getPosition() > 0) {
            maxBlockLength = Math.max(maxBlockLength, this.compressAndGetTermsDictBlockLength(bufferedOutput, ht));
        }
        writer.finish();
        this.meta.writeInt(maxLength);
        if (compress) {
            this.meta.writeInt(maxBlockLength);
        }
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        start = this.data.getFilePointer();
        addressBuffer.copyTo(this.data);
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.writeTermsIndex(values);
    }

    private int compressAndGetTermsDictBlockLength(ByteArrayDataOutput bufferedOutput, LZ4.FastCompressionHashTable ht) throws IOException {
        int uncompressedLength = bufferedOutput.getPosition();
        this.data.writeVInt(uncompressedLength);
        long before = this.data.getFilePointer();
        LZ4.compress(this.termsDictBuffer, 0, uncompressedLength, this.data, ht);
        int compressedLength = (int)(this.data.getFilePointer() - before);
        return Math.max(uncompressedLength, compressedLength);
    }

    private ByteArrayDataOutput maybeGrowBuffer(ByteArrayDataOutput bufferedOutput, int termLength) {
        int originalLength;
        int pos = bufferedOutput.getPosition();
        if (pos + termLength >= (originalLength = this.termsDictBuffer.length) - 1) {
            this.termsDictBuffer = ArrayUtil.grow(this.termsDictBuffer, originalLength + termLength);
            bufferedOutput = new ByteArrayDataOutput(this.termsDictBuffer, pos, this.termsDictBuffer.length - pos);
        }
        return bufferedOutput;
    }

    private void writeTermsIndex(SortedSetDocValues values) throws IOException {
        long size = values.getValueCount();
        this.meta.writeInt(10);
        long start = this.data.getFilePointer();
        long numBlocks = 1L + (size + 1023L >>> 10);
        ByteBuffersDataOutput addressBuffer = new ByteBuffersDataOutput();
        try (ByteBuffersIndexOutput addressOutput = new ByteBuffersIndexOutput(addressBuffer, "temp", "temp");){
            DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, addressOutput, numBlocks, 16);
            TermsEnum iterator = values.termsEnum();
            BytesRefBuilder previous = new BytesRefBuilder();
            long offset = 0L;
            long ord = 0L;
            BytesRef term = iterator.next();
            while (term != null) {
                if ((ord & 0x3FFL) == 0L) {
                    writer.add(offset);
                    int sortKeyLength = ord == 0L ? 0 : StringHelper.sortKeyLength(previous.get(), term);
                    offset += (long)sortKeyLength;
                    this.data.writeBytes(term.bytes, term.offset, sortKeyLength);
                } else if ((ord & 0x3FFL) == 1023L) {
                    previous.copyBytes(term);
                }
                ++ord;
                term = iterator.next();
            }
            writer.add(offset);
            writer.finish();
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
            start = this.data.getFilePointer();
            addressBuffer.copyTo(this.data);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    @Override
    public void addSortedNumericField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)4);
        long[] stats = this.writeValues(field2, valuesProducer);
        int numDocsWithField = Math.toIntExact(stats[0]);
        long numValues = stats[1];
        assert (numValues >= (long)numDocsWithField);
        this.meta.writeInt(numDocsWithField);
        if (numValues > (long)numDocsWithField) {
            long start = this.data.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.getInstance(this.meta, this.data, (long)numDocsWithField + 1L, 16);
            long addr = 0L;
            addressesWriter.add(addr);
            SortedNumericDocValues values = valuesProducer.getSortedNumeric(field2);
            int doc = values.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                addressesWriter.add(addr += (long)values.docValueCount());
                doc = values.nextDoc();
            }
            addressesWriter.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    @Override
    public void addSortedSetField(FieldInfo field2, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)3);
        SortedSetDocValues values = valuesProducer.getSortedSet(field2);
        int numDocsWithField = 0;
        long numOrds = 0L;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            long ord = values.nextOrd();
            while (ord != -1L) {
                ++numOrds;
                ord = values.nextOrd();
            }
            doc = values.nextDoc();
        }
        if ((long)numDocsWithField == numOrds) {
            this.meta.writeByte((byte)0);
            this.doAddSortedField(field2, new EmptyDocValuesProducer(){

                @Override
                public SortedDocValues getSorted(FieldInfo field2) throws IOException {
                    return SortedSetSelector.wrap(valuesProducer.getSortedSet(field2), SortedSetSelector.Type.MIN);
                }
            });
            return;
        }
        this.meta.writeByte((byte)1);
        assert (numDocsWithField != 0);
        if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getSortedSet(field2);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(values, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
        }
        int numberOfBitsPerOrd = DirectWriter.unsignedBitsRequired(values.getValueCount() - 1L);
        this.meta.writeByte((byte)numberOfBitsPerOrd);
        long start = this.data.getFilePointer();
        this.meta.writeLong(start);
        DirectWriter writer = DirectWriter.getInstance(this.data, numOrds, numberOfBitsPerOrd);
        values = valuesProducer.getSortedSet(field2);
        int doc2 = values.nextDoc();
        while (doc2 != Integer.MAX_VALUE) {
            long ord = values.nextOrd();
            while (ord != -1L) {
                writer.add(ord);
                ord = values.nextOrd();
            }
            doc2 = values.nextDoc();
        }
        writer.finish();
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.meta.writeInt(numDocsWithField);
        start = this.data.getFilePointer();
        this.meta.writeLong(start);
        this.meta.writeVInt(16);
        DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.getInstance(this.meta, this.data, numDocsWithField + 1, 16);
        long addr = 0L;
        addressesWriter.add(addr);
        values = valuesProducer.getSortedSet(field2);
        int doc3 = values.nextDoc();
        while (doc3 != Integer.MAX_VALUE) {
            values.nextOrd();
            ++addr;
            while (values.nextOrd() != -1L) {
                ++addr;
            }
            addressesWriter.add(addr);
            doc3 = values.nextDoc();
        }
        addressesWriter.finish();
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.addTermsDict(values);
    }

    class CompressedBinaryBlockWriter
    implements Closeable {
        final LZ4.FastCompressionHashTable ht = new LZ4.FastCompressionHashTable();
        int uncompressedBlockLength = 0;
        int maxUncompressedBlockLength = 0;
        int numDocsInCurrentBlock = 0;
        final int[] docLengths = new int[32];
        byte[] block = BytesRef.EMPTY_BYTES;
        int totalChunks = 0;
        long maxPointer = 0L;
        final long blockAddressesStart;
        private final IndexOutput tempBinaryOffsets;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CompressedBinaryBlockWriter() throws IOException {
            this.tempBinaryOffsets = ((Lucene80DocValuesConsumer)Lucene80DocValuesConsumer.this).state.directory.createTempOutput(((Lucene80DocValuesConsumer)Lucene80DocValuesConsumer.this).state.segmentInfo.name, "binary_pointers", ((Lucene80DocValuesConsumer)Lucene80DocValuesConsumer.this).state.context);
            boolean success = false;
            try {
                CodecUtil.writeHeader(this.tempBinaryOffsets, "Lucene80DocValuesMetadataFilePointers", 2);
                this.blockAddressesStart = Lucene80DocValuesConsumer.this.data.getFilePointer();
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(this);
                throw throwable;
            }
        }

        void addDoc(int doc, BytesRef v) throws IOException {
            this.docLengths[this.numDocsInCurrentBlock] = v.length;
            this.block = ArrayUtil.grow(this.block, this.uncompressedBlockLength + v.length);
            System.arraycopy(v.bytes, v.offset, this.block, this.uncompressedBlockLength, v.length);
            this.uncompressedBlockLength += v.length;
            ++this.numDocsInCurrentBlock;
            if (this.numDocsInCurrentBlock == 32) {
                this.flushData();
            }
        }

        private void flushData() throws IOException {
            if (this.numDocsInCurrentBlock > 0) {
                int i;
                ++this.totalChunks;
                long thisBlockStartPointer = Lucene80DocValuesConsumer.this.data.getFilePointer();
                boolean allLengthsSame = true;
                for (i = 1; i < 32; ++i) {
                    if (this.docLengths[i] == this.docLengths[i - 1]) continue;
                    allLengthsSame = false;
                    break;
                }
                if (allLengthsSame) {
                    int onlyOneLength = this.docLengths[0] << 1 | 1;
                    Lucene80DocValuesConsumer.this.data.writeVInt(onlyOneLength);
                } else {
                    for (i = 0; i < 32; ++i) {
                        if (i == 0) {
                            int multipleLengths = this.docLengths[0] << 1;
                            Lucene80DocValuesConsumer.this.data.writeVInt(multipleLengths);
                            continue;
                        }
                        Lucene80DocValuesConsumer.this.data.writeVInt(this.docLengths[i]);
                    }
                }
                this.maxUncompressedBlockLength = Math.max(this.maxUncompressedBlockLength, this.uncompressedBlockLength);
                LZ4.compress(this.block, 0, this.uncompressedBlockLength, Lucene80DocValuesConsumer.this.data, this.ht);
                this.numDocsInCurrentBlock = 0;
                Arrays.fill(this.docLengths, 0);
                this.uncompressedBlockLength = 0;
                this.maxPointer = Lucene80DocValuesConsumer.this.data.getFilePointer();
                this.tempBinaryOffsets.writeVLong(this.maxPointer - thisBlockStartPointer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeMetaData() throws IOException {
            long startDMW;
            block20: {
                if (this.totalChunks == 0) {
                    return;
                }
                startDMW = Lucene80DocValuesConsumer.this.data.getFilePointer();
                Lucene80DocValuesConsumer.this.meta.writeLong(startDMW);
                Lucene80DocValuesConsumer.this.meta.writeVInt(this.totalChunks);
                Lucene80DocValuesConsumer.this.meta.writeVInt(5);
                Lucene80DocValuesConsumer.this.meta.writeVInt(this.maxUncompressedBlockLength);
                Lucene80DocValuesConsumer.this.meta.writeVInt(16);
                CodecUtil.writeFooter(this.tempBinaryOffsets);
                IOUtils.close(this.tempBinaryOffsets);
                try (ChecksumIndexInput filePointersIn = ((Lucene80DocValuesConsumer)Lucene80DocValuesConsumer.this).state.directory.openChecksumInput(this.tempBinaryOffsets.getName(), IOContext.READONCE);){
                    CodecUtil.checkHeader(filePointersIn, "Lucene80DocValuesMetadataFilePointers", 2, 2);
                    Throwable priorE = null;
                    try {
                        DirectMonotonicWriter filePointers = DirectMonotonicWriter.getInstance(Lucene80DocValuesConsumer.this.meta, Lucene80DocValuesConsumer.this.data, this.totalChunks, 16);
                        long fp = this.blockAddressesStart;
                        for (int i = 0; i < this.totalChunks; ++i) {
                            filePointers.add(fp);
                            fp += filePointersIn.readVLong();
                        }
                        if (this.maxPointer < fp) {
                            throw new CorruptIndexException("File pointers don't add up (" + fp + " vs expected " + this.maxPointer + ")", filePointersIn);
                        }
                        filePointers.finish();
                    }
                    catch (Throwable e) {
                        try {
                            priorE = e;
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CodecUtil.checkFooter(filePointersIn, priorE);
                        }
                    }
                    CodecUtil.checkFooter(filePointersIn, priorE);
                }
            }
            Lucene80DocValuesConsumer.this.meta.writeLong(Lucene80DocValuesConsumer.this.data.getFilePointer() - startDMW);
        }

        @Override
        public void close() throws IOException {
            if (this.tempBinaryOffsets != null) {
                IOUtils.close(this.tempBinaryOffsets);
                ((Lucene80DocValuesConsumer)Lucene80DocValuesConsumer.this).state.directory.deleteFile(this.tempBinaryOffsets.getName());
            }
        }
    }

    private static class MinMaxTracker {
        long min;
        long max;
        long numValues;
        long spaceInBits;

        MinMaxTracker() {
            this.reset();
            this.spaceInBits = 0L;
        }

        private void reset() {
            this.min = Long.MAX_VALUE;
            this.max = Long.MIN_VALUE;
            this.numValues = 0L;
        }

        void update(long v) {
            this.min = Math.min(this.min, v);
            this.max = Math.max(this.max, v);
            ++this.numValues;
        }

        void finish() {
            if (this.max > this.min) {
                this.spaceInBits += (long)DirectWriter.unsignedBitsRequired(this.max - this.min) * this.numValues;
            }
        }

        void nextBlock() {
            this.finish();
            this.reset();
        }
    }
}

