/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.perfield;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.Terms;

final class PerFieldMergeState {
    private final MergeState in;
    private final FieldInfos orgMergeFieldInfos;
    private final FieldInfos[] orgFieldInfos;
    private final FieldsProducer[] orgFieldsProducers;

    PerFieldMergeState(MergeState in) {
        this.in = in;
        this.orgMergeFieldInfos = in.mergeFieldInfos;
        this.orgFieldInfos = new FieldInfos[in.fieldInfos.length];
        this.orgFieldsProducers = new FieldsProducer[in.fieldsProducers.length];
        System.arraycopy(in.fieldInfos, 0, this.orgFieldInfos, 0, this.orgFieldInfos.length);
        System.arraycopy(in.fieldsProducers, 0, this.orgFieldsProducers, 0, this.orgFieldsProducers.length);
    }

    MergeState apply(Collection<String> fields) {
        int i;
        this.in.mergeFieldInfos = new FilterFieldInfos(this.orgMergeFieldInfos, fields);
        for (i = 0; i < this.orgFieldInfos.length; ++i) {
            this.in.fieldInfos[i] = new FilterFieldInfos(this.orgFieldInfos[i], fields);
        }
        for (i = 0; i < this.orgFieldsProducers.length; ++i) {
            this.in.fieldsProducers[i] = new FilterFieldsProducer(this.orgFieldsProducers[i], fields);
        }
        return this.in;
    }

    MergeState reset() {
        this.in.mergeFieldInfos = this.orgMergeFieldInfos;
        System.arraycopy(this.orgFieldInfos, 0, this.in.fieldInfos, 0, this.in.fieldInfos.length);
        System.arraycopy(this.orgFieldsProducers, 0, this.in.fieldsProducers, 0, this.in.fieldsProducers.length);
        return this.in;
    }

    private static class FilterFieldsProducer
    extends FieldsProducer {
        private final FieldsProducer in;
        private final List<String> filtered;

        FilterFieldsProducer(FieldsProducer in, Collection<String> filterFields) {
            this.in = in;
            this.filtered = new ArrayList<String>(filterFields);
        }

        @Override
        public long ramBytesUsed() {
            return this.in.ramBytesUsed();
        }

        @Override
        public Iterator<String> iterator() {
            return this.filtered.iterator();
        }

        @Override
        public Terms terms(String field2) throws IOException {
            if (!this.filtered.contains(field2)) {
                throw new IllegalArgumentException("The field named '" + field2 + "' is not accessible in the current merge context, available ones are: " + this.filtered);
            }
            return this.in.terms(field2);
        }

        @Override
        public int size() {
            return this.filtered.size();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }
    }

    private static class FilterFieldInfos
    extends FieldInfos {
        private final Set<String> filteredNames;
        private final List<FieldInfo> filtered;
        private final boolean filteredHasVectors;
        private final boolean filteredHasProx;
        private final boolean filteredHasPayloads;
        private final boolean filteredHasOffsets;
        private final boolean filteredHasFreq;
        private final boolean filteredHasNorms;
        private final boolean filteredHasDocValues;
        private final boolean filteredHasPointValues;

        FilterFieldInfos(FieldInfos src, Collection<String> filterFields) {
            super(FilterFieldInfos.toArray(src));
            boolean hasVectors = false;
            boolean hasProx = false;
            boolean hasPayloads = false;
            boolean hasOffsets = false;
            boolean hasFreq = false;
            boolean hasNorms = false;
            boolean hasDocValues = false;
            boolean hasPointValues = false;
            this.filteredNames = new HashSet<String>(filterFields);
            this.filtered = new ArrayList<FieldInfo>(filterFields.size());
            for (FieldInfo fi : src) {
                if (!this.filteredNames.contains(fi.name)) continue;
                this.filtered.add(fi);
                hasVectors |= fi.hasVectors();
                hasProx |= fi.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                hasFreq |= fi.getIndexOptions() != IndexOptions.DOCS;
                hasOffsets |= fi.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                hasNorms |= fi.hasNorms();
                hasDocValues |= fi.getDocValuesType() != DocValuesType.NONE;
                hasPayloads |= fi.hasPayloads();
                hasPointValues |= fi.getPointDimensionCount() != 0;
            }
            this.filteredHasVectors = hasVectors;
            this.filteredHasProx = hasProx;
            this.filteredHasPayloads = hasPayloads;
            this.filteredHasOffsets = hasOffsets;
            this.filteredHasFreq = hasFreq;
            this.filteredHasNorms = hasNorms;
            this.filteredHasDocValues = hasDocValues;
            this.filteredHasPointValues = hasPointValues;
        }

        private static FieldInfo[] toArray(FieldInfos src) {
            FieldInfo[] res = new FieldInfo[src.size()];
            int i = 0;
            for (FieldInfo fi : src) {
                res[i++] = fi;
            }
            return res;
        }

        @Override
        public Iterator<FieldInfo> iterator() {
            return this.filtered.iterator();
        }

        @Override
        public boolean hasFreq() {
            return this.filteredHasFreq;
        }

        @Override
        public boolean hasProx() {
            return this.filteredHasProx;
        }

        @Override
        public boolean hasPayloads() {
            return this.filteredHasPayloads;
        }

        @Override
        public boolean hasOffsets() {
            return this.filteredHasOffsets;
        }

        @Override
        public boolean hasVectors() {
            return this.filteredHasVectors;
        }

        @Override
        public boolean hasNorms() {
            return this.filteredHasNorms;
        }

        @Override
        public boolean hasDocValues() {
            return this.filteredHasDocValues;
        }

        @Override
        public boolean hasPointValues() {
            return this.filteredHasPointValues;
        }

        @Override
        public int size() {
            return this.filtered.size();
        }

        @Override
        public FieldInfo fieldInfo(String fieldName) {
            if (!this.filteredNames.contains(fieldName)) {
                throw new IllegalArgumentException("The field named '" + fieldName + "' is not accessible in the current merge context, available ones are: " + this.filteredNames);
            }
            return super.fieldInfo(fieldName);
        }

        @Override
        public FieldInfo fieldInfo(int fieldNumber) {
            FieldInfo res = super.fieldInfo(fieldNumber);
            if (!this.filteredNames.contains(res.name)) {
                throw new IllegalArgumentException("The field named '" + res.name + "' numbered '" + fieldNumber + "' is not accessible in the current merge context, available ones are: " + this.filteredNames);
            }
            return res;
        }
    }
}

