/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;

abstract class SpatialQuery
extends Query {
    final String field;
    final ShapeField.QueryRelation queryRelation;

    protected SpatialQuery(String field2, ShapeField.QueryRelation queryRelation) {
        if (field2 == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (queryRelation == null) {
            throw new IllegalArgumentException("queryRelation must not be null");
        }
        this.field = field2;
        this.queryRelation = queryRelation;
    }

    protected abstract SpatialVisitor getSpatialVisitor();

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        SpatialQuery query = this;
        final SpatialVisitor spatialVisitor = this.getSpatialVisitor();
        return new ConstantScoreWeight(query, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                PointValues values = reader.getPointValues(SpatialQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(SpatialQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                final 1 weight = this;
                PointValues.Relation rel = (PointValues.Relation)((Object)spatialVisitor.getInnerFunction(SpatialQuery.this.queryRelation).apply(values.getMinPackedValue(), values.getMaxPackedValue()));
                if (rel == PointValues.Relation.CELL_OUTSIDE_QUERY || rel == PointValues.Relation.CELL_INSIDE_QUERY && SpatialQuery.this.queryRelation == ShapeField.QueryRelation.CONTAINS) {
                    return null;
                }
                if (values.getDocCount() == reader.maxDoc() && rel == PointValues.Relation.CELL_INSIDE_QUERY) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.all(reader.maxDoc()));
                        }

                        @Override
                        public long cost() {
                            return reader.maxDoc();
                        }
                    };
                }
                if (SpatialQuery.this.queryRelation != ShapeField.QueryRelation.INTERSECTS && SpatialQuery.this.queryRelation != ShapeField.QueryRelation.CONTAINS && (long)values.getDocCount() != values.size() && !SpatialQuery.hasAnyHits(spatialVisitor, SpatialQuery.this.queryRelation, values)) {
                    return null;
                }
                return new RelationScorerSupplier(values, spatialVisitor, SpatialQuery.this.queryRelation, SpatialQuery.this.field){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        return this.getScorer(reader, weight, this.score(), scoreMode);
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public ShapeField.QueryRelation getQueryRelation() {
        return this.queryRelation;
    }

    @Override
    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.queryRelation.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(o);
    }

    protected boolean equalsTo(Object o) {
        return Objects.equals(this.field, ((SpatialQuery)o).field) && this.queryRelation == ((SpatialQuery)o).queryRelation;
    }

    protected static PointValues.Relation transposeRelation(PointValues.Relation r) {
        if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private static PointValues.IntersectVisitor getEstimateVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation) {
        final BiFunction innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void visit(int docID, byte[] t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getSparseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final DocIdSetBuilder result) {
        final BiFunction innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Predicate leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
        return new PointValues.IntersectVisitor(){
            DocIdSetBuilder.BulkAdder adder;

            @Override
            public void grow(int count) {
                this.adder = result.grow(count);
            }

            @Override
            public void visit(int docID) {
                this.adder.add(docID);
            }

            @Override
            public void visit(int docID, byte[] t) {
                if (leafPredicate.test(t)) {
                    this.visit(docID);
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                if (leafPredicate.test(t)) {
                    int docID;
                    while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        this.visit(docID);
                    }
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getIntersectsDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result, final long[] cost) {
        final BiFunction innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Predicate leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                result.set(docID);
                cost[0] = cost[0] + 1L;
            }

            @Override
            public void visit(int docID, byte[] t) {
                if (!result.get(docID) && leafPredicate.test(t)) {
                    this.visit(docID);
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                if (leafPredicate.test(t)) {
                    int docID;
                    while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        this.visit(docID);
                    }
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result, final FixedBitSet excluded, final long[] cost) {
        final BiFunction innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Predicate leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                result.set(docID);
                cost[0] = cost[0] + 1L;
            }

            @Override
            public void visit(int docID, byte[] t) {
                if (!excluded.get(docID)) {
                    if (leafPredicate.test(t)) {
                        this.visit(docID);
                    } else {
                        excluded.set(docID);
                    }
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                int docID;
                boolean matches = leafPredicate.test(t);
                while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                    if (matches) {
                        this.visit(docID);
                        continue;
                    }
                    excluded.set(docID);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getContainsDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result, final FixedBitSet excluded, final long[] cost) {
        final BiFunction innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Function<byte[], Component2D.WithinRelation> leafFunction = spatialVisitor.contains();
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                excluded.set(docID);
            }

            @Override
            public void visit(int docID, byte[] t) {
                if (!excluded.get(docID)) {
                    Component2D.WithinRelation within = (Component2D.WithinRelation)((Object)leafFunction.apply(t));
                    if (within == Component2D.WithinRelation.CANDIDATE) {
                        cost[0] = cost[0] + 1L;
                        result.set(docID);
                    } else if (within == Component2D.WithinRelation.NOTWITHIN) {
                        excluded.set(docID);
                    }
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                int docID;
                Component2D.WithinRelation within = (Component2D.WithinRelation)((Object)leafFunction.apply(t));
                while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                    if (within == Component2D.WithinRelation.CANDIDATE) {
                        cost[0] = cost[0] + 1L;
                        result.set(docID);
                        continue;
                    }
                    if (within != Component2D.WithinRelation.NOTWITHIN) continue;
                    excluded.set(docID);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getInverseDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result, final long[] cost) {
        final BiFunction innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Predicate leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                result.clear(docID);
                cost[0] = cost[0] - 1L;
            }

            @Override
            public void visit(int docID, byte[] packedTriangle) {
                if (result.get(docID) && !leafPredicate.test(packedTriangle)) {
                    this.visit(docID);
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                if (!leafPredicate.test(t)) {
                    int docID;
                    while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        this.visit(docID);
                    }
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                return SpatialQuery.transposeRelation((PointValues.Relation)((Object)innerFunction.apply(minPackedValue, maxPackedValue)));
            }
        };
    }

    private static PointValues.IntersectVisitor getShallowInverseDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result) {
        final BiFunction innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                result.clear(docID);
            }

            @Override
            public void visit(int docID, byte[] packedTriangle) {
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t) {
            }

            @Override
            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                return SpatialQuery.transposeRelation((PointValues.Relation)((Object)innerFunction.apply(minPackedValue, maxPackedValue)));
            }
        };
    }

    private static boolean hasAnyHits(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, PointValues values) throws IOException {
        try {
            final BiFunction innerFunction = spatialVisitor.getInnerFunction(queryRelation);
            final Predicate leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
            values.intersect(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) {
                    throw new CollectionTerminatedException();
                }

                @Override
                public void visit(int docID, byte[] t) {
                    if (leafPredicate.test(t)) {
                        throw new CollectionTerminatedException();
                    }
                }

                @Override
                public void visit(DocIdSetIterator iterator, byte[] t) {
                    if (leafPredicate.test(t)) {
                        throw new CollectionTerminatedException();
                    }
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    PointValues.Relation rel = (PointValues.Relation)((Object)innerFunction.apply(minPackedValue, maxPackedValue));
                    if (rel == PointValues.Relation.CELL_INSIDE_QUERY) {
                        throw new CollectionTerminatedException();
                    }
                    return rel;
                }
            });
        }
        catch (CollectionTerminatedException e) {
            return true;
        }
        return false;
    }

    private static abstract class RelationScorerSupplier
    extends ScorerSupplier {
        private final PointValues values;
        private final SpatialVisitor spatialVisitor;
        private final ShapeField.QueryRelation queryRelation;
        private final String field;
        private long cost = -1L;

        RelationScorerSupplier(PointValues values, SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, String field2) {
            this.values = values;
            this.spatialVisitor = spatialVisitor;
            this.queryRelation = queryRelation;
            this.field = field2;
        }

        protected Scorer getScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            switch (this.queryRelation) {
                case INTERSECTS: {
                    return this.getSparseScorer(reader, weight, boost, scoreMode);
                }
                case CONTAINS: {
                    return this.getContainsDenseScorer(reader, weight, boost, scoreMode);
                }
                case WITHIN: 
                case DISJOINT: {
                    return (long)this.values.getDocCount() == this.values.size() ? this.getSparseScorer(reader, weight, boost, scoreMode) : this.getDenseScorer(reader, weight, boost, scoreMode);
                }
            }
            throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)this.queryRelation) + "]");
        }

        private Scorer getSparseScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            if (this.queryRelation == ShapeField.QueryRelation.DISJOINT && this.values.getDocCount() == reader.maxDoc() && (long)this.values.getDocCount() == this.values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                FixedBitSet result = new FixedBitSet(reader.maxDoc());
                result.set(0, reader.maxDoc());
                long[] cost = new long[]{reader.maxDoc()};
                this.values.intersect(SpatialQuery.getInverseDenseVisitor(this.spatialVisitor, this.queryRelation, result, cost));
                BitSetIterator iterator = new BitSetIterator(result, cost[0]);
                return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
            }
            if ((long)this.values.getDocCount() < this.values.size() >>> 2) {
                FixedBitSet result = new FixedBitSet(reader.maxDoc());
                long[] cost = new long[]{0L};
                this.values.intersect(SpatialQuery.getIntersectsDenseVisitor(this.spatialVisitor, this.queryRelation, result, cost));
                assert (cost[0] > 0L || result.cardinality() == 0);
                DocIdSetIterator iterator = cost[0] == 0L ? DocIdSetIterator.empty() : new BitSetIterator(result, cost[0]);
                return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
            }
            DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(reader.maxDoc(), this.values, this.field);
            this.values.intersect(SpatialQuery.getSparseVisitor(this.spatialVisitor, this.queryRelation, docIdSetBuilder));
            DocIdSetIterator iterator = docIdSetBuilder.build().iterator();
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        private Scorer getDenseScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            long[] cost;
            FixedBitSet result = new FixedBitSet(reader.maxDoc());
            if (this.values.getDocCount() == reader.maxDoc()) {
                cost = new long[]{this.values.size()};
                result.set(0, reader.maxDoc());
                this.values.intersect(SpatialQuery.getInverseDenseVisitor(this.spatialVisitor, this.queryRelation, result, cost));
            } else {
                cost = new long[]{0L};
                FixedBitSet excluded = new FixedBitSet(reader.maxDoc());
                this.values.intersect(SpatialQuery.getDenseVisitor(this.spatialVisitor, this.queryRelation, result, excluded, cost));
                result.andNot(excluded);
                this.values.intersect(SpatialQuery.getShallowInverseDenseVisitor(this.spatialVisitor, this.queryRelation, result));
            }
            assert (cost[0] > 0L || result.cardinality() == 0);
            DocIdSetIterator iterator = cost[0] == 0L ? DocIdSetIterator.empty() : new BitSetIterator(result, cost[0]);
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        private Scorer getContainsDenseScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            FixedBitSet result = new FixedBitSet(reader.maxDoc());
            long[] cost = new long[]{0L};
            FixedBitSet excluded = new FixedBitSet(reader.maxDoc());
            this.values.intersect(SpatialQuery.getContainsDenseVisitor(this.spatialVisitor, this.queryRelation, result, excluded, cost));
            result.andNot(excluded);
            assert (cost[0] > 0L || result.cardinality() == 0);
            DocIdSetIterator iterator = cost[0] == 0L ? DocIdSetIterator.empty() : new BitSetIterator(result, cost[0]);
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        @Override
        public long cost() {
            if (this.cost == -1L) {
                this.cost = this.values.estimateDocCount(SpatialQuery.getEstimateVisitor(this.spatialVisitor, this.queryRelation));
                assert (this.cost >= 0L);
            }
            return this.cost;
        }
    }

    protected static abstract class SpatialVisitor {
        protected SpatialVisitor() {
        }

        protected abstract PointValues.Relation relate(byte[] var1, byte[] var2);

        protected abstract Predicate<byte[]> intersects();

        protected abstract Predicate<byte[]> within();

        protected abstract Function<byte[], Component2D.WithinRelation> contains();

        private Predicate<byte[]> containsPredicate() {
            Function<byte[], Component2D.WithinRelation> contains = this.contains();
            return bytes -> contains.apply((byte[])bytes) == Component2D.WithinRelation.CANDIDATE;
        }

        private BiFunction<byte[], byte[], PointValues.Relation> getInnerFunction(ShapeField.QueryRelation queryRelation) {
            if (queryRelation == ShapeField.QueryRelation.DISJOINT) {
                return (minPackedValue, maxPackedValue) -> SpatialQuery.transposeRelation(this.relate((byte[])minPackedValue, (byte[])maxPackedValue));
            }
            return (minPackedValue, maxPackedValue) -> this.relate((byte[])minPackedValue, (byte[])maxPackedValue);
        }

        private Predicate<byte[]> getLeafPredicate(ShapeField.QueryRelation queryRelation) {
            switch (queryRelation) {
                case INTERSECTS: {
                    return this.intersects();
                }
                case WITHIN: {
                    return this.within();
                }
                case DISJOINT: {
                    return this.intersects().negate();
                }
                case CONTAINS: {
                    return this.containsPredicate();
                }
            }
            throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
        }
    }
}

