/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.ExtendedIntervalIterator;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatches;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.QueryVisitor;

class ExtendedIntervalsSource
extends IntervalsSource {
    final IntervalsSource source;
    private final int before;
    private final int after;

    ExtendedIntervalsSource(IntervalsSource source, int before, int after) {
        this.source = source;
        this.before = before;
        this.after = after;
    }

    @Override
    public IntervalIterator intervals(String field2, LeafReaderContext ctx) throws IOException {
        IntervalIterator in = this.source.intervals(field2, ctx);
        if (in == null) {
            return null;
        }
        return new ExtendedIntervalIterator(in, this.before, this.after);
    }

    @Override
    public IntervalMatchesIterator matches(String field2, LeafReaderContext ctx, int doc) throws IOException {
        IntervalMatchesIterator in = this.source.matches(field2, ctx, doc);
        if (in == null) {
            return null;
        }
        ExtendedIntervalIterator wrapped = new ExtendedIntervalIterator(IntervalMatches.wrapMatches(in, doc), this.before, this.after);
        return IntervalMatches.asMatches(wrapped, in, doc);
    }

    @Override
    public void visit(String field2, QueryVisitor visitor) {
        this.source.visit(field2, visitor);
    }

    @Override
    public int minExtent() {
        int minExtent = this.before + this.source.minExtent() + this.after;
        if (minExtent < 0) {
            return Integer.MAX_VALUE;
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        Collection<IntervalsSource> inner = this.source.pullUpDisjunctions();
        if (inner.size() == 0) {
            return Collections.singleton(this);
        }
        return inner.stream().map(s -> new ExtendedIntervalsSource((IntervalsSource)s, this.before, this.after)).collect(Collectors.toSet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedIntervalsSource that = (ExtendedIntervalsSource)o;
        return this.before == that.before && this.after == that.after && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.before, this.after);
    }

    @Override
    public String toString() {
        return "EXTEND(" + this.source + "," + this.before + "," + this.after + ")";
    }
}

