/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortFieldProvider;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;

public class SortedSetSortField
extends SortField {
    private final SortedSetSelector.Type selector;

    public SortedSetSortField(String field2, boolean reverse) {
        this(field2, reverse, SortedSetSelector.Type.MIN);
    }

    public SortedSetSortField(String field2, boolean reverse, SortedSetSelector.Type selector) {
        super(field2, SortField.Type.CUSTOM, reverse);
        if (selector == null) {
            throw new NullPointerException();
        }
        this.selector = selector;
    }

    private static SortedSetSelector.Type readSelectorType(DataInput in) throws IOException {
        int type = in.readInt();
        if (type >= SortedSetSelector.Type.values().length) {
            throw new IllegalArgumentException("Cannot deserialize SortedSetSortField: unknown selector type " + type);
        }
        return SortedSetSelector.Type.values()[type];
    }

    private void serialize(DataOutput out) throws IOException {
        out.writeString(this.getField());
        out.writeInt(this.reverse ? 1 : 0);
        out.writeInt(this.selector.ordinal());
        if (this.missingValue == SortField.STRING_FIRST) {
            out.writeInt(1);
        } else if (this.missingValue == SortField.STRING_LAST) {
            out.writeInt(2);
        } else {
            out.writeInt(0);
        }
    }

    public SortedSetSelector.Type getSelector() {
        return this.selector;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.selector.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedSetSortField other = (SortedSetSortField)obj;
        return this.selector == other.selector;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<sortedset: \"").append(this.getField()).append("\">");
        if (this.getReverse()) {
            buffer.append('!');
        }
        if (this.missingValue != null) {
            buffer.append(" missingValue=");
            buffer.append(this.missingValue);
        }
        buffer.append(" selector=");
        buffer.append((Object)this.selector);
        return buffer.toString();
    }

    @Override
    public void setMissingValue(Object missingValue) {
        if (missingValue != STRING_FIRST && missingValue != STRING_LAST) {
            throw new IllegalArgumentException("For SORTED_SET type, missing value must be either STRING_FIRST or STRING_LAST");
        }
        this.missingValue = missingValue;
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) {
        return new FieldComparator.TermOrdValComparator(numHits, this.getField(), this.missingValue == STRING_LAST){

            @Override
            protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field2) throws IOException {
                return SortedSetSelector.wrap(DocValues.getSortedSet(context.reader(), field2), SortedSetSortField.this.selector);
            }
        };
    }

    private SortedDocValues getValues(LeafReader reader) throws IOException {
        return SortedSetSelector.wrap(DocValues.getSortedSet(reader, this.getField()), this.selector);
    }

    @Override
    public IndexSorter getIndexSorter() {
        return new IndexSorter.StringSorter("SortedSetSortField", this.missingValue, this.reverse, this::getValues);
    }

    public static final class Provider
    extends SortFieldProvider {
        public static final String NAME = "SortedSetSortField";

        public Provider() {
            super(NAME);
        }

        @Override
        public SortField readSortField(DataInput in) throws IOException {
            SortedSetSortField sf = new SortedSetSortField(in.readString(), in.readInt() == 1, SortedSetSortField.readSelectorType(in));
            int missingValue = in.readInt();
            if (missingValue == 1) {
                ((SortField)sf).setMissingValue(SortField.STRING_FIRST);
            } else if (missingValue == 2) {
                ((SortField)sf).setMissingValue(SortField.STRING_LAST);
            }
            return sf;
        }

        @Override
        public void writeSortField(SortField sf, DataOutput out) throws IOException {
            assert (sf instanceof SortedSetSortField);
            ((SortedSetSortField)sf).serialize(out);
        }
    }
}

