/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DisjunctionMatchesIterator;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;

public class TermInSetQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermInSetQuery.class);
    static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
    private final String field;
    private final PrefixCodedTerms termData;
    private final int termDataHashCode;

    public TermInSetQuery(String field2, Collection<BytesRef> terms) {
        boolean sorted;
        Comparable[] sortedTerms = terms.toArray(new BytesRef[0]);
        boolean bl = sorted = terms instanceof SortedSet && ((SortedSet)terms).comparator() == null;
        if (!sorted) {
            ArrayUtil.timSort((Comparable[])sortedTerms);
        }
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        BytesRefBuilder previous = null;
        for (Comparable term : sortedTerms) {
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else if (previous.get().equals(term)) continue;
            builder.add(field2, (BytesRef)term);
            previous.copyBytes((BytesRef)term);
        }
        this.field = field2;
        this.termData = builder.finish();
        this.termDataHashCode = this.termData.hashCode();
    }

    public TermInSetQuery(String field2, BytesRef ... terms) {
        this(field2, Arrays.asList(terms));
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
        if (this.termData.size() <= (long)threshold) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
            BytesRef term = iterator.next();
            while (term != null) {
                bq.add(new TermQuery(new Term(iterator.field(), BytesRef.deepCopyOf(term))), BooleanClause.Occur.SHOULD);
                term = iterator.next();
            }
            return new ConstantScoreQuery(bq.build());
        }
        return super.rewrite(reader);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.field)) {
            return;
        }
        if (this.termData.size() == 1L) {
            visitor.consumeTerms(this, new Term(this.field, this.termData.iterator().next()));
        }
        if (this.termData.size() > 1L) {
            visitor.consumeTermsMatching(this, this.field, this::asByteRunAutomaton);
        }
    }

    private ByteRunAutomaton asByteRunAutomaton() {
        PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        BytesRef term = iterator.next();
        while (term != null) {
            automata.add(Automata.makeBinary(term));
            term = iterator.next();
        }
        return new CompiledAutomaton((Automaton)Operations.union(automata)).runAutomaton;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermInSetQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(TermInSetQuery other) {
        return this.termDataHashCode == other.termDataHashCode && this.termData.equals(other.termData);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.termDataHashCode;
    }

    public PrefixCodedTerms getTermData() {
        return this.termData;
    }

    @Override
    public String toString(String defaultField) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.field);
        builder.append(":(");
        PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
        boolean first = true;
        BytesRef term = iterator.next();
        while (term != null) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(Term.toString(term));
            term = iterator.next();
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.termData.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                Terms terms = context.reader().terms(TermInSetQuery.this.field);
                if (terms == null || !terms.hasPositions()) {
                    return super.matches(context, doc);
                }
                return MatchesUtils.forField(TermInSetQuery.this.field, () -> DisjunctionMatchesIterator.fromTermsEnum(context, doc, this.getQuery(), TermInSetQuery.this.field, TermInSetQuery.this.termData.iterator()));
            }

            private WeightOrDocIdSet rewrite(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                Terms terms = reader.terms(TermInSetQuery.this.field);
                if (terms == null) {
                    return null;
                }
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                PrefixCodedTerms.TermIterator iterator = TermInSetQuery.this.termData.iterator();
                int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
                assert (TermInSetQuery.this.termData.size() > (long)threshold) : "Query should have been rewritten";
                ArrayList<TermAndState> matchingTerms = new ArrayList<TermAndState>(threshold);
                DocIdSetBuilder builder = null;
                BytesRef term = iterator.next();
                while (term != null) {
                    assert (TermInSetQuery.this.field.equals(iterator.field()));
                    if (termsEnum.seekExact(term)) {
                        if (matchingTerms == null) {
                            docs = termsEnum.postings(docs, 0);
                            builder.add(docs);
                        } else if (matchingTerms.size() < threshold) {
                            matchingTerms.add(new TermAndState(TermInSetQuery.this.field, termsEnum));
                        } else {
                            assert (matchingTerms.size() == threshold);
                            builder = new DocIdSetBuilder(reader.maxDoc(), terms);
                            docs = termsEnum.postings(docs, 0);
                            builder.add(docs);
                            for (TermAndState t : matchingTerms) {
                                t.termsEnum.seekExact(t.term, t.state);
                                docs = t.termsEnum.postings(docs, 0);
                                builder.add(docs);
                            }
                            matchingTerms = null;
                        }
                    }
                    term = iterator.next();
                }
                if (matchingTerms != null) {
                    assert (builder == null);
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    for (TermAndState t : matchingTerms) {
                        TermStates termStates = new TermStates(searcher.getTopReaderContext());
                        termStates.register(t.state, context.ord, t.docFreq, t.totalTermFreq);
                        bq.add(new TermQuery(new Term(t.field, t.term), termStates), BooleanClause.Occur.SHOULD);
                    }
                    ConstantScoreQuery q = new ConstantScoreQuery(bq.build());
                    Weight weight = searcher.rewrite(q).createWeight(searcher, scoreMode, this.score());
                    return new WeightOrDocIdSet(weight);
                }
                assert (builder != null);
                return new WeightOrDocIdSet(builder.build());
            }

            private Scorer scorer(DocIdSet set) throws IOException {
                if (set == null) {
                    return null;
                }
                DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, disi);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                WeightOrDocIdSet weightOrBitSet = this.rewrite(context);
                if (weightOrBitSet == null) {
                    return null;
                }
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.bulkScorer(context);
                }
                Scorer scorer = this.scorer(weightOrBitSet.set);
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                WeightOrDocIdSet weightOrBitSet = this.rewrite(context);
                if (weightOrBitSet == null) {
                    return null;
                }
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.scorer(context);
                }
                return this.scorer(weightOrBitSet.set);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return TermInSetQuery.this.ramBytesUsed() <= 1024L;
            }
        };
    }

    private static class WeightOrDocIdSet {
        final Weight weight;
        final DocIdSet set;

        WeightOrDocIdSet(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.set = null;
        }

        WeightOrDocIdSet(DocIdSet bitset) {
            this.set = bitset;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final String field;
        final TermsEnum termsEnum;
        final BytesRef term;
        final TermState state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(String field2, TermsEnum termsEnum) throws IOException {
            this.field = field2;
            this.termsEnum = termsEnum;
            this.term = BytesRef.deepCopyOf(termsEnum.term());
            this.state = termsEnum.termState();
            this.docFreq = termsEnum.docFreq();
            this.totalTermFreq = termsEnum.totalTermFreq();
        }
    }
}

