/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.Sorter;

public abstract class MSBRadixSorter
extends Sorter {
    private static final int LEVEL_THRESHOLD = 8;
    protected static final int HISTOGRAM_SIZE = 257;
    private static final int LENGTH_THRESHOLD = 100;
    private final int[][] histograms = new int[8][];
    private final int[] endOffsets = new int[257];
    private final int[] commonPrefix;
    protected final int maxLength;

    protected MSBRadixSorter(int maxLength) {
        this.maxLength = maxLength;
        this.commonPrefix = new int[Math.min(24, maxLength)];
    }

    protected abstract int byteAt(int var1, int var2);

    protected Sorter getFallbackSorter(final int k) {
        return new IntroSorter(){
            private final BytesRefBuilder pivot = new BytesRefBuilder();

            @Override
            protected void swap(int i, int j) {
                MSBRadixSorter.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                for (int o = k; o < MSBRadixSorter.this.maxLength; ++o) {
                    int b2;
                    int b1 = MSBRadixSorter.this.byteAt(i, o);
                    if (b1 != (b2 = MSBRadixSorter.this.byteAt(j, o))) {
                        return b1 - b2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }

            @Override
            protected void setPivot(int i) {
                int b;
                this.pivot.setLength(0);
                for (int o = k; o < MSBRadixSorter.this.maxLength && (b = MSBRadixSorter.this.byteAt(i, o)) != -1; ++o) {
                    this.pivot.append((byte)b);
                }
            }

            @Override
            protected int comparePivot(int j) {
                for (int o = 0; o < this.pivot.length(); ++o) {
                    int b2;
                    int b1 = this.pivot.byteAt(o) & 0xFF;
                    if (b1 == (b2 = MSBRadixSorter.this.byteAt(j, k + o))) continue;
                    return b1 - b2;
                }
                if (k + this.pivot.length() == MSBRadixSorter.this.maxLength) {
                    return 0;
                }
                return -1 - MSBRadixSorter.this.byteAt(j, k + this.pivot.length());
            }
        };
    }

    @Override
    protected final int compare(int i, int j) {
        throw new UnsupportedOperationException("unused: not a comparison-based sort");
    }

    @Override
    public void sort(int from, int to) {
        this.checkRange(from, to);
        this.sort(from, to, 0, 0);
    }

    protected void sort(int from, int to, int k, int l) {
        if (to - from <= 100 || l >= 8) {
            this.introSort(from, to, k);
        } else {
            this.radixSort(from, to, k, l);
        }
    }

    private void introSort(int from, int to, int k) {
        this.getFallbackSorter(k).sort(from, to);
    }

    private void radixSort(int from, int to, int k, int l) {
        int[] histogram = this.histograms[l];
        if (histogram == null) {
            this.histograms[l] = new int[257];
            histogram = this.histograms[l];
        } else {
            Arrays.fill(histogram, 0);
        }
        int commonPrefixLength = this.computeCommonPrefixLengthAndBuildHistogram(from, to, k, histogram);
        if (commonPrefixLength > 0) {
            if (k + commonPrefixLength < this.maxLength && histogram[0] < to - from) {
                this.radixSort(from, to, k + commonPrefixLength, l);
            }
            return;
        }
        assert (this.assertHistogram(commonPrefixLength, histogram));
        int[] startOffsets = histogram;
        int[] endOffsets = this.endOffsets;
        MSBRadixSorter.sumHistogram(histogram, endOffsets);
        this.reorder(from, to, startOffsets, endOffsets, k);
        endOffsets = startOffsets;
        if (k + 1 < this.maxLength) {
            int prev = endOffsets[0];
            for (int i = 1; i < 257; ++i) {
                int h = endOffsets[i];
                int bucketLen = h - prev;
                if (bucketLen > 1) {
                    this.sort(from + prev, from + h, k + 1, l + 1);
                }
                prev = h;
            }
        }
    }

    private boolean assertHistogram(int commonPrefixLength, int[] histogram) {
        int numberOfUniqueBytes = 0;
        for (int freq : histogram) {
            if (freq <= 0) continue;
            ++numberOfUniqueBytes;
        }
        if (numberOfUniqueBytes == 1) {
            assert (commonPrefixLength >= 1);
        } else assert (commonPrefixLength == 0) : commonPrefixLength;
        return true;
    }

    protected int getBucket(int i, int k) {
        return this.byteAt(i, k) + 1;
    }

    private int computeCommonPrefixLengthAndBuildHistogram(int from, int to, int k, int[] histogram) {
        int i;
        int[] commonPrefix = this.commonPrefix;
        int commonPrefixLength = Math.min(commonPrefix.length, this.maxLength - k);
        for (int j = 0; j < commonPrefixLength; ++j) {
            int b;
            commonPrefix[j] = b = this.byteAt(from, k + j);
            if (b != -1) continue;
            commonPrefixLength = j + 1;
            break;
        }
        block1: for (i = from + 1; i < to; ++i) {
            for (int j = 0; j < commonPrefixLength; ++j) {
                int b = this.byteAt(i, k + j);
                if (b == commonPrefix[j]) continue;
                commonPrefixLength = j;
                if (commonPrefixLength != 0) continue block1;
                histogram[commonPrefix[0] + 1] = i - from;
                histogram[b + 1] = 1;
                break block1;
            }
        }
        if (i < to) {
            assert (commonPrefixLength == 0);
            this.buildHistogram(i + 1, to, k, histogram);
        } else {
            assert (commonPrefixLength > 0);
            histogram[commonPrefix[0] + 1] = to - from;
        }
        return commonPrefixLength;
    }

    private void buildHistogram(int from, int to, int k, int[] histogram) {
        for (int i = from; i < to; ++i) {
            int n = this.getBucket(i, k);
            histogram[n] = histogram[n] + 1;
        }
    }

    private static void sumHistogram(int[] histogram, int[] endOffsets) {
        int accum2 = 0;
        for (int i = 0; i < 257; ++i) {
            int count = histogram[i];
            histogram[i] = accum2;
            endOffsets[i] = accum2 += count;
        }
    }

    protected void reorder(int from, int to, int[] startOffsets, int[] endOffsets, int k) {
        for (int i = 0; i < 257; ++i) {
            int limit = endOffsets[i];
            int h1 = startOffsets[i];
            while (h1 < limit) {
                int h2;
                int b;
                int n = b = this.getBucket(from + h1, k);
                startOffsets[n] = startOffsets[n] + 1;
                this.swap(from + h1, from + h2);
                h1 = startOffsets[i];
            }
        }
    }
}

