/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.minhash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BitUtil;

public class MinHashFilter
extends TokenFilter {
    private static final int HASH_CACHE_SIZE = 512;
    private static final LongPair[] cachedIntHashes = new LongPair[512];
    public static final int DEFAULT_HASH_COUNT = 1;
    public static final int DEFAULT_HASH_SET_SIZE = 1;
    public static final int DEFAULT_BUCKET_COUNT = 512;
    static final String MIN_HASH_TYPE = "MIN_HASH";
    private final List<List<FixedSizeTreeSet<LongPair>>> minHashSets;
    private int hashSetSize = 1;
    private int bucketCount = 512;
    private int hashCount = 1;
    private boolean requiresInitialisation = true;
    private AttributeSource.State endState;
    private int hashPosition = -1;
    private int bucketPosition = -1;
    private long bucketSize;
    private final boolean withRotation;
    private int endOffset;
    private boolean exhausted = false;
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAttribute = this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncAttribute = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAttribute = this.addAttribute(PositionLengthAttribute.class);

    static byte[] getBytes(int i) {
        byte[] answer = new byte[4];
        BitUtil.VH_BE_INT.set(answer, 0, i);
        return answer;
    }

    public MinHashFilter(TokenStream input, int hashCount, int bucketCount, int hashSetSize, boolean withRotation) {
        super(input);
        if (hashCount <= 0) {
            throw new IllegalArgumentException("hashCount must be greater than zero");
        }
        if (bucketCount <= 0) {
            throw new IllegalArgumentException("bucketCount must be greater than zero");
        }
        if (hashSetSize <= 0) {
            throw new IllegalArgumentException("hashSetSize must be greater than zero");
        }
        this.hashCount = hashCount;
        this.bucketCount = bucketCount;
        this.hashSetSize = hashSetSize;
        this.withRotation = withRotation;
        this.bucketSize = 0x100000000L / (long)bucketCount;
        if (0x100000000L % (long)bucketCount != 0L) {
            ++this.bucketSize;
        }
        this.minHashSets = new ArrayList<List<FixedSizeTreeSet<LongPair>>>(this.hashCount);
        for (int i = 0; i < this.hashCount; ++i) {
            ArrayList buckets = new ArrayList(this.bucketCount);
            this.minHashSets.add(buckets);
            for (int j = 0; j < this.bucketCount; ++j) {
                FixedSizeTreeSet minSet = new FixedSizeTreeSet(this.hashSetSize);
                buckets.add(minSet);
            }
        }
        this.doRest();
    }

    @Override
    public final boolean incrementToken() throws IOException {
        int positionIncrement = 0;
        if (this.requiresInitialisation) {
            this.requiresInitialisation = false;
            boolean found = false;
            while (this.input.incrementToken()) {
                found = true;
                String current = new String(this.termAttribute.buffer(), 0, this.termAttribute.length());
                for (int i = 0; i < this.hashCount; ++i) {
                    byte[] bytes = current.getBytes("UTF-16LE");
                    LongPair hash = new LongPair();
                    MinHashFilter.murmurhash3_x64_128(bytes, 0, bytes.length, 0, hash);
                    LongPair rehashed = MinHashFilter.combineOrdered(hash, MinHashFilter.getIntHash(i));
                    this.minHashSets.get(i).get((int)((rehashed.val2 >>> 32) / this.bucketSize)).add(rehashed);
                }
                this.endOffset = this.offsetAttribute.endOffset();
            }
            this.exhausted = true;
            this.input.end();
            this.endState = this.captureState();
            if (!found) {
                return false;
            }
            positionIncrement = 1;
            if (this.withRotation && this.hashSetSize == 1) {
                for (int hashLoop = 0; hashLoop < this.hashCount; ++hashLoop) {
                    block3: for (int bucketLoop = 0; bucketLoop < this.bucketCount; ++bucketLoop) {
                        if (this.minHashSets.get(hashLoop).get(bucketLoop).size() != 0) continue;
                        for (int bucketOffset = 1; bucketOffset < this.bucketCount; ++bucketOffset) {
                            if (this.minHashSets.get(hashLoop).get((bucketLoop + bucketOffset) % this.bucketCount).size() <= 0) continue;
                            LongPair replacementHash = (LongPair)this.minHashSets.get(hashLoop).get((bucketLoop + bucketOffset) % this.bucketCount).first();
                            this.minHashSets.get(hashLoop).get(bucketLoop).add(replacementHash);
                            continue block3;
                        }
                    }
                }
            }
        }
        this.clearAttributes();
        while (this.hashPosition < this.hashCount) {
            if (this.hashPosition == -1) {
                ++this.hashPosition;
                continue;
            }
            while (this.bucketPosition < this.bucketCount) {
                if (this.bucketPosition == -1) {
                    ++this.bucketPosition;
                    continue;
                }
                LongPair hash = (LongPair)this.minHashSets.get(this.hashPosition).get(this.bucketPosition).pollFirst();
                if (hash != null) {
                    this.termAttribute.setEmpty();
                    if (this.hashCount > 1) {
                        this.termAttribute.append(MinHashFilter.int0(this.hashPosition));
                        this.termAttribute.append(MinHashFilter.int1(this.hashPosition));
                    }
                    long high = hash.val2;
                    this.termAttribute.append(MinHashFilter.long0(high));
                    this.termAttribute.append(MinHashFilter.long1(high));
                    this.termAttribute.append(MinHashFilter.long2(high));
                    this.termAttribute.append(MinHashFilter.long3(high));
                    long low = hash.val1;
                    this.termAttribute.append(MinHashFilter.long0(low));
                    this.termAttribute.append(MinHashFilter.long1(low));
                    if (this.hashCount == 1) {
                        this.termAttribute.append(MinHashFilter.long2(low));
                        this.termAttribute.append(MinHashFilter.long3(low));
                    }
                    this.posIncAttribute.setPositionIncrement(positionIncrement);
                    this.offsetAttribute.setOffset(0, this.endOffset);
                    this.typeAttribute.setType(MIN_HASH_TYPE);
                    this.posLenAttribute.setPositionLength(1);
                    return true;
                }
                ++this.bucketPosition;
            }
            this.bucketPosition = -1;
            ++this.hashPosition;
        }
        return false;
    }

    private static LongPair getIntHash(int i) {
        if (i < 512) {
            return cachedIntHashes[i];
        }
        LongPair answer = new LongPair();
        MinHashFilter.murmurhash3_x64_128(MinHashFilter.getBytes(i), 0, 4, 0, answer);
        return answer;
    }

    @Override
    public void end() throws IOException {
        if (!this.exhausted) {
            this.input.end();
        }
        this.restoreState(this.endState);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.doRest();
    }

    private void doRest() {
        for (int i = 0; i < this.hashCount; ++i) {
            for (int j = 0; j < this.bucketCount; ++j) {
                this.minHashSets.get(i).get(j).clear();
            }
        }
        this.endState = null;
        this.hashPosition = -1;
        this.bucketPosition = -1;
        this.requiresInitialisation = true;
        this.exhausted = false;
    }

    private static char long0(long x) {
        return (char)(x >> 48);
    }

    private static char long1(long x) {
        return (char)(x >> 32);
    }

    private static char long2(long x) {
        return (char)(x >> 16);
    }

    private static char long3(long x) {
        return (char)x;
    }

    private static char int0(int x) {
        return (char)(x >> 16);
    }

    private static char int1(int x) {
        return (char)x;
    }

    static boolean isLessThanUnsigned(long n1, long n2) {
        return n1 < n2 ^ n1 < 0L != n2 < 0L;
    }

    private static LongPair combineOrdered(LongPair ... hashCodes) {
        LongPair result = new LongPair();
        for (LongPair hashCode : hashCodes) {
            result.val1 = result.val1 * 37L + hashCode.val1;
            result.val2 = result.val2 * 37L + hashCode.val2;
        }
        return result;
    }

    private static long getLongLittleEndian(byte[] buf, int offset) {
        return (long)buf[offset + 7] << 56 | ((long)buf[offset + 6] & 0xFFL) << 48 | ((long)buf[offset + 5] & 0xFFL) << 40 | ((long)buf[offset + 4] & 0xFFL) << 32 | ((long)buf[offset + 3] & 0xFFL) << 24 | ((long)buf[offset + 2] & 0xFFL) << 16 | ((long)buf[offset + 1] & 0xFFL) << 8 | (long)buf[offset] & 0xFFL;
    }

    static void murmurhash3_x64_128(byte[] key, int offset, int len, int seed, LongPair out) {
        long h1 = (long)seed & 0xFFFFFFFFL;
        long h2 = (long)seed & 0xFFFFFFFFL;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int roundedEnd = offset + (len & 0xFFFFFFF0);
        for (int i = offset; i < roundedEnd; i += 16) {
            long k1 = MinHashFilter.getLongLittleEndian(key, i);
            long k2 = MinHashFilter.getLongLittleEndian(key, i + 8);
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch (len & 0xF) {
            case 15: {
                k2 = ((long)key[roundedEnd + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 |= ((long)key[roundedEnd + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 |= ((long)key[roundedEnd + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 |= ((long)key[roundedEnd + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 |= ((long)key[roundedEnd + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 |= ((long)key[roundedEnd + 9] & 0xFFL) << 8;
            }
            case 9: {
                k2 |= (long)key[roundedEnd + 8] & 0xFFL;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 = (long)key[roundedEnd + 7] << 56;
            }
            case 7: {
                k1 |= ((long)key[roundedEnd + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 |= ((long)key[roundedEnd + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 |= ((long)key[roundedEnd + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 |= ((long)key[roundedEnd + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 |= ((long)key[roundedEnd + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 |= ((long)key[roundedEnd + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 |= (long)key[roundedEnd] & 0xFFL;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)len;
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = MinHashFilter.fmix64(h1);
        h2 = MinHashFilter.fmix64(h2);
        h1 += h2;
        out.val1 = h1;
        out.val2 = h2 += h1;
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    static {
        for (int i = 0; i < 512; ++i) {
            MinHashFilter.cachedIntHashes[i] = new LongPair();
            MinHashFilter.murmurhash3_x64_128(MinHashFilter.getBytes(i), 0, 4, 0, cachedIntHashes[i]);
        }
    }

    static class FixedSizeTreeSet<E extends Comparable<E>>
    extends TreeSet<E> {
        private static final long serialVersionUID = -8237117170340299630L;
        private final int capacity;

        FixedSizeTreeSet() {
            this(20);
        }

        FixedSizeTreeSet(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public boolean add(E toAdd) {
            if (this.capacity <= this.size()) {
                Comparable lastElm = (Comparable)this.last();
                if (toAdd.compareTo((Comparable)lastElm) >= 0) {
                    return false;
                }
                this.pollLast();
            }
            return super.add(toAdd);
        }
    }

    static final class LongPair
    implements Comparable<LongPair> {
        public long val1;
        public long val2;

        LongPair() {
        }

        @Override
        public int compareTo(LongPair other) {
            if (MinHashFilter.isLessThanUnsigned(this.val2, other.val2)) {
                return -1;
            }
            if (this.val2 == other.val2) {
                if (MinHashFilter.isLessThanUnsigned(this.val1, other.val1)) {
                    return -1;
                }
                if (this.val1 == other.val1) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongPair longPair = (LongPair)o;
            return this.val1 == longPair.val1 && this.val2 == longPair.val2;
        }

        public int hashCode() {
            int result = (int)(this.val1 ^ this.val1 >>> 32);
            result = 31 * result + (int)(this.val2 ^ this.val2 >>> 32);
            return result;
        }
    }
}

