/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesRangeQuery;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;

public class SortedSetDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedSetDocValuesField(String name, BytesRef bytes) {
        super(name, TYPE);
        this.fieldsData = bytes;
    }

    public static Query newSlowRangeQuery(String field2, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field2, lowerValue, upperValue, lowerInclusive, upperInclusive);
    }

    public static Query newSlowExactQuery(String field2, BytesRef value) {
        return SortedSetDocValuesField.newSlowRangeQuery(field2, value, value, true, true);
    }

    public static Query newSlowSetQuery(String field2, BytesRef ... values) {
        return new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field2, values);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_SET);
        TYPE.freeze();
    }
}

