/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Objects;

public class CollectionStatistics {
    private final String field;
    private final long maxDoc;
    private final long docCount;
    private final long sumTotalTermFreq;
    private final long sumDocFreq;

    public CollectionStatistics(String field2, long maxDoc, long docCount, long sumTotalTermFreq, long sumDocFreq) {
        Objects.requireNonNull(field2);
        if (maxDoc <= 0L) {
            throw new IllegalArgumentException("maxDoc must be positive, maxDoc: " + maxDoc);
        }
        if (docCount <= 0L) {
            throw new IllegalArgumentException("docCount must be positive, docCount: " + docCount);
        }
        if (docCount > maxDoc) {
            throw new IllegalArgumentException("docCount must not exceed maxDoc, docCount: " + docCount + ", maxDoc: " + maxDoc);
        }
        if (sumDocFreq <= 0L) {
            throw new IllegalArgumentException("sumDocFreq must be positive, sumDocFreq: " + sumDocFreq);
        }
        if (sumDocFreq < docCount) {
            throw new IllegalArgumentException("sumDocFreq must be at least docCount, sumDocFreq: " + sumDocFreq + ", docCount: " + docCount);
        }
        if (sumTotalTermFreq <= 0L) {
            throw new IllegalArgumentException("sumTotalTermFreq must be positive, sumTotalTermFreq: " + sumTotalTermFreq);
        }
        if (sumTotalTermFreq < sumDocFreq) {
            throw new IllegalArgumentException("sumTotalTermFreq must be at least sumDocFreq, sumTotalTermFreq: " + sumTotalTermFreq + ", sumDocFreq: " + sumDocFreq);
        }
        this.field = field2;
        this.maxDoc = maxDoc;
        this.docCount = docCount;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
    }

    public final String field() {
        return this.field;
    }

    public final long maxDoc() {
        return this.maxDoc;
    }

    public final long docCount() {
        return this.docCount;
    }

    public final long sumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    public final long sumDocFreq() {
        return this.sumDocFreq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("field=");
        sb.append('\"');
        sb.append(this.field());
        sb.append('\"');
        sb.append(",maxDoc=");
        sb.append(this.maxDoc());
        sb.append(",docCount=");
        sb.append(this.docCount());
        sb.append(",sumTotalTermFreq=");
        sb.append(this.sumTotalTermFreq());
        sb.append(",sumDocFreq=");
        sb.append(this.sumDocFreq);
        return sb.toString();
    }
}

