/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.RollingBuffer;
import org.apache.lucene.util.fst.FST;

public final class SynonymGraphFilter
extends TokenFilter {
    public static final String TYPE_SYNONYM = "SYNONYM";
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = this.addAttribute(PositionLengthAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final SynonymMap synonyms;
    private final boolean ignoreCase;
    private final FST<BytesRef> fst;
    private final FST.BytesReader fstReader;
    private final FST.Arc<BytesRef> scratchArc;
    private final ByteArrayDataInput bytesReader = new ByteArrayDataInput();
    private final BytesRef scratchBytes = new BytesRef();
    private final CharsRefBuilder scratchChars = new CharsRefBuilder();
    private final LinkedList<BufferedOutputToken> outputBuffer = new LinkedList();
    private int nextNodeOut;
    private int lastNodeOut;
    private int maxLookaheadUsed;
    private int captureCount;
    private boolean liveToken;
    private int matchStartOffset;
    private int matchEndOffset;
    private boolean finished;
    private int lookaheadNextRead;
    private int lookaheadNextWrite;
    private RollingBuffer<BufferedInputToken> lookahead = new RollingBuffer<BufferedInputToken>(){

        @Override
        protected BufferedInputToken newInstance() {
            return new BufferedInputToken();
        }
    };

    public SynonymGraphFilter(TokenStream input, SynonymMap synonyms, boolean ignoreCase) {
        super(input);
        this.synonyms = synonyms;
        this.fst = synonyms.fst;
        if (this.fst == null) {
            throw new IllegalArgumentException("fst must be non-null");
        }
        this.fstReader = this.fst.getBytesReader();
        this.scratchArc = new FST.Arc();
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean incrementToken() throws IOException {
        assert (this.lastNodeOut <= this.nextNodeOut);
        if (!this.outputBuffer.isEmpty()) {
            this.releaseBufferedToken();
            assert (!this.liveToken);
            return true;
        }
        if (this.parse()) {
            this.releaseBufferedToken();
            assert (!this.liveToken);
            return true;
        }
        if (this.lookaheadNextRead == this.lookaheadNextWrite) {
            if (this.finished) {
                return false;
            }
            assert (this.liveToken);
            this.liveToken = false;
        } else {
            assert (this.lookaheadNextRead < this.lookaheadNextWrite) : "read=" + this.lookaheadNextRead + " write=" + this.lookaheadNextWrite;
            BufferedInputToken token = this.lookahead.get(this.lookaheadNextRead);
            ++this.lookaheadNextRead;
            this.restoreState(token.state);
            this.lookahead.freeBefore(this.lookaheadNextRead);
            assert (!this.liveToken);
        }
        this.lastNodeOut += this.posIncrAtt.getPositionIncrement();
        this.nextNodeOut = this.lastNodeOut + this.posLenAtt.getPositionLength();
        return true;
    }

    private void releaseBufferedToken() throws IOException {
        BufferedOutputToken token = this.outputBuffer.pollFirst();
        if (token.state != null) {
            this.restoreState(token.state);
        } else {
            this.clearAttributes();
            this.termAtt.append(token.term);
            assert (this.matchStartOffset != -1);
            this.offsetAtt.setOffset(this.matchStartOffset, this.matchEndOffset);
            this.typeAtt.setType(TYPE_SYNONYM);
        }
        this.posIncrAtt.setPositionIncrement(token.startNode - this.lastNodeOut);
        this.lastNodeOut = token.startNode;
        this.posLenAtt.setPositionLength(token.endNode - token.startNode);
    }

    private boolean parse() throws IOException {
        BytesRef matchOutput = null;
        int matchInputLength = 0;
        BytesRef pendingOutput = (BytesRef)this.fst.outputs.getNoOutput();
        this.fst.getFirstArc(this.scratchArc);
        assert (this.scratchArc.output() == this.fst.outputs.getNoOutput());
        int matchLength = 0;
        boolean doFinalCapture = false;
        int lookaheadUpto = this.lookaheadNextRead;
        this.matchStartOffset = -1;
        block0: while (true) {
            int bufUpto;
            int codePoint;
            int inputEndOffset;
            int bufferLen;
            char[] buffer;
            if (lookaheadUpto <= this.lookahead.getMaxPos()) {
                BufferedInputToken token = this.lookahead.get(lookaheadUpto);
                ++lookaheadUpto;
                buffer = token.term.chars();
                bufferLen = token.term.length();
                inputEndOffset = token.endOffset;
                if (this.matchStartOffset == -1) {
                    this.matchStartOffset = token.startOffset;
                }
            } else {
                assert (this.finished || !this.liveToken);
                if (this.finished) break;
                if (this.input.incrementToken()) {
                    this.liveToken = true;
                    buffer = this.termAtt.buffer();
                    bufferLen = this.termAtt.length();
                    if (this.matchStartOffset == -1) {
                        this.matchStartOffset = this.offsetAtt.startOffset();
                    }
                    inputEndOffset = this.offsetAtt.endOffset();
                    ++lookaheadUpto;
                } else {
                    this.finished = true;
                    break;
                }
            }
            ++matchLength;
            for (bufUpto = 0; bufUpto < bufferLen; bufUpto += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(buffer, bufUpto, bufferLen);
                if (this.fst.findTargetArc(this.ignoreCase ? Character.toLowerCase(codePoint) : codePoint, this.scratchArc, this.scratchArc, this.fstReader) == null) break block0;
                pendingOutput = this.fst.outputs.add(pendingOutput, this.scratchArc.output());
            }
            assert (bufUpto == bufferLen);
            if (this.scratchArc.isFinal()) {
                matchOutput = this.fst.outputs.add(pendingOutput, this.scratchArc.nextFinalOutput());
                matchInputLength = matchLength;
                this.matchEndOffset = inputEndOffset;
            }
            if (this.fst.findTargetArc(0, this.scratchArc, this.scratchArc, this.fstReader) == null) break;
            pendingOutput = this.fst.outputs.add(pendingOutput, this.scratchArc.output());
            doFinalCapture = true;
            if (!this.liveToken) continue;
            this.capture();
        }
        if (doFinalCapture && this.liveToken && !this.finished) {
            this.capture();
        }
        if (matchOutput != null) {
            if (this.liveToken) {
                this.capture();
            }
            this.bufferOutputTokens(matchOutput, matchInputLength);
            this.lookaheadNextRead += matchInputLength;
            this.lookahead.freeBefore(this.lookaheadNextRead);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void bufferOutputTokens(BytesRef bytes, int matchInputLength) {
        int totalPathNodes;
        boolean keepOrig;
        this.bytesReader.reset(bytes.bytes, bytes.offset, bytes.length);
        int code = this.bytesReader.readVInt();
        boolean bl = keepOrig = (code & 1) == 0;
        if (keepOrig) {
            assert (matchInputLength > 0);
            totalPathNodes = matchInputLength - 1;
        } else {
            totalPathNodes = 0;
        }
        int count = code >>> 1;
        ArrayList<Object> paths = new ArrayList<Object>();
        for (int outputIDX = 0; outputIDX < count; ++outputIDX) {
            int wordID = this.bytesReader.readVInt();
            this.synonyms.words.get(wordID, this.scratchBytes);
            this.scratchChars.copyUTF8Bytes(this.scratchBytes);
            int lastStart = 0;
            ArrayList path = new ArrayList();
            paths.add(path);
            int n = this.scratchChars.length();
            for (int chUpto = 0; chUpto <= n; ++chUpto) {
                if (chUpto != n && this.scratchChars.charAt(chUpto) != '\u0000') continue;
                path.add(new String(this.scratchChars.chars(), lastStart, chUpto - lastStart));
                lastStart = 1 + chUpto;
            }
            assert (path.size() > 0);
            totalPathNodes += path.size() - 1;
        }
        int startNode = this.nextNodeOut;
        int endNode = startNode + totalPathNodes + 1;
        int newNodeCount = 0;
        for (List list : paths) {
            int pathEndNode;
            if (list.size() == 1) {
                pathEndNode = endNode;
            } else {
                pathEndNode = this.nextNodeOut + newNodeCount + 1;
                newNodeCount += list.size() - 1;
            }
            this.outputBuffer.add(new BufferedOutputToken(null, (String)list.get(0), startNode, pathEndNode));
        }
        if (keepOrig) {
            void var12_17;
            BufferedInputToken token = this.lookahead.get(this.lookaheadNextRead);
            if (matchInputLength == 1) {
                int n = endNode;
            } else {
                int n = this.nextNodeOut + newNodeCount + 1;
            }
            this.outputBuffer.add(new BufferedOutputToken(token.state, token.term.toString(), startNode, (int)var12_17));
        }
        this.nextNodeOut = endNode;
        for (int pathID = 0; pathID < paths.size(); ++pathID) {
            List list = (List)paths.get(pathID);
            if (list.size() <= 1) continue;
            int lastNode = this.outputBuffer.get((int)pathID).endNode;
            for (int i = 1; i < list.size() - 1; ++i) {
                this.outputBuffer.add(new BufferedOutputToken(null, (String)list.get(i), lastNode, lastNode + 1));
                ++lastNode;
            }
            this.outputBuffer.add(new BufferedOutputToken(null, (String)list.get(list.size() - 1), lastNode, endNode));
        }
        if (keepOrig && matchInputLength > 1) {
            void var12_20;
            int lastNode = this.outputBuffer.get((int)paths.size()).endNode;
            boolean bl2 = true;
            while (var12_20 < matchInputLength - 1) {
                BufferedInputToken token = this.lookahead.get(this.lookaheadNextRead + var12_20);
                this.outputBuffer.add(new BufferedOutputToken(token.state, token.term.toString(), lastNode, lastNode + 1));
                ++lastNode;
                ++var12_20;
            }
            BufferedInputToken bufferedInputToken = this.lookahead.get(this.lookaheadNextRead + matchInputLength - 1);
            this.outputBuffer.add(new BufferedOutputToken(bufferedInputToken.state, bufferedInputToken.term.toString(), lastNode, endNode));
        }
    }

    private void capture() {
        assert (this.liveToken);
        this.liveToken = false;
        BufferedInputToken token = this.lookahead.get(this.lookaheadNextWrite);
        ++this.lookaheadNextWrite;
        token.state = this.captureState();
        token.startOffset = this.offsetAtt.startOffset();
        token.endOffset = this.offsetAtt.endOffset();
        assert (token.term.length() == 0);
        token.term.append(this.termAtt);
        ++this.captureCount;
        this.maxLookaheadUsed = Math.max(this.maxLookaheadUsed, this.lookahead.getBufferSize());
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.lookahead.reset();
        this.lookaheadNextWrite = 0;
        this.lookaheadNextRead = 0;
        this.captureCount = 0;
        this.lastNodeOut = -1;
        this.nextNodeOut = 0;
        this.matchStartOffset = -1;
        this.matchEndOffset = -1;
        this.finished = false;
        this.liveToken = false;
        this.outputBuffer.clear();
        this.maxLookaheadUsed = 0;
    }

    int getCaptureCount() {
        return this.captureCount;
    }

    int getMaxLookaheadUsed() {
        return this.maxLookaheadUsed;
    }

    static class BufferedInputToken
    implements RollingBuffer.Resettable {
        final CharsRefBuilder term = new CharsRefBuilder();
        AttributeSource.State state;
        int startOffset = -1;
        int endOffset = -1;

        BufferedInputToken() {
        }

        @Override
        public void reset() {
            this.state = null;
            this.term.clear();
            this.startOffset = -1;
            this.endOffset = -1;
        }
    }

    static class BufferedOutputToken {
        final String term;
        final AttributeSource.State state;
        final int startNode;
        final int endNode;

        public BufferedOutputToken(AttributeSource.State state, String term, int startNode, int endNode) {
            this.state = state;
            this.term = term;
            this.startNode = startNode;
            this.endNode = endNode;
        }
    }
}

