/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SingletonSortedNumericDocValues;
import org.apache.lucene.index.SingletonSortedSetDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;

public final class DocValues {
    private DocValues() {
    }

    public static final BinaryDocValues emptyBinary() {
        return new BinaryDocValues(){
            private int doc = -1;

            @Override
            public int advance(int target) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 0L;
            }

            @Override
            public BytesRef binaryValue() {
                assert (false);
                return null;
            }
        };
    }

    public static final NumericDocValues emptyNumeric() {
        return new NumericDocValues(){
            private int doc = -1;

            @Override
            public int advance(int target) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 0L;
            }

            @Override
            public long longValue() {
                assert (false);
                return 0L;
            }
        };
    }

    public static final SortedDocValues emptySorted() {
        final BytesRef empty = new BytesRef();
        return new SortedDocValues(){
            private int doc = -1;

            @Override
            public int advance(int target) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 0L;
            }

            @Override
            public int ordValue() {
                assert (false);
                return -1;
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return empty;
            }

            @Override
            public int getValueCount() {
                return 0;
            }
        };
    }

    public static final SortedNumericDocValues emptySortedNumeric() {
        return DocValues.singleton(DocValues.emptyNumeric());
    }

    public static final SortedSetDocValues emptySortedSet() {
        return DocValues.singleton(DocValues.emptySorted());
    }

    public static SortedSetDocValues singleton(SortedDocValues dv) {
        return new SingletonSortedSetDocValues(dv);
    }

    public static SortedDocValues unwrapSingleton(SortedSetDocValues dv) {
        if (dv instanceof SingletonSortedSetDocValues) {
            return ((SingletonSortedSetDocValues)dv).getSortedDocValues();
        }
        return null;
    }

    public static NumericDocValues unwrapSingleton(SortedNumericDocValues dv) {
        if (dv instanceof SingletonSortedNumericDocValues) {
            return ((SingletonSortedNumericDocValues)dv).getNumericDocValues();
        }
        return null;
    }

    public static SortedNumericDocValues singleton(NumericDocValues dv) {
        return new SingletonSortedNumericDocValues(dv);
    }

    private static void checkField(LeafReader in, String field2, DocValuesType ... expected) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field2);
        if (fi != null) {
            DocValuesType actual = fi.getDocValuesType();
            throw new IllegalStateException("unexpected docvalues type " + String.valueOf((Object)actual) + " for field '" + field2 + "' " + (expected.length == 1 ? "(expected=" + String.valueOf((Object)expected[0]) : "(expected one of " + Arrays.toString((Object[])expected)) + "). Re-index with correct docvalues type.");
        }
    }

    public static NumericDocValues getNumeric(LeafReader reader, String field2) throws IOException {
        NumericDocValues dv = reader.getNumericDocValues(field2);
        if (dv == null) {
            DocValues.checkField(reader, field2, DocValuesType.NUMERIC);
            return DocValues.emptyNumeric();
        }
        return dv;
    }

    public static BinaryDocValues getBinary(LeafReader reader, String field2) throws IOException {
        BinaryDocValues dv = reader.getBinaryDocValues(field2);
        if (dv == null) {
            DocValues.checkField(reader, field2, DocValuesType.BINARY);
            return DocValues.emptyBinary();
        }
        return dv;
    }

    public static SortedDocValues getSorted(LeafReader reader, String field2) throws IOException {
        SortedDocValues dv = reader.getSortedDocValues(field2);
        if (dv == null) {
            DocValues.checkField(reader, field2, DocValuesType.SORTED);
            return DocValues.emptySorted();
        }
        return dv;
    }

    public static SortedNumericDocValues getSortedNumeric(LeafReader reader, String field2) throws IOException {
        SortedNumericDocValues dv = reader.getSortedNumericDocValues(field2);
        if (dv == null) {
            NumericDocValues single = reader.getNumericDocValues(field2);
            if (single == null) {
                DocValues.checkField(reader, field2, DocValuesType.SORTED_NUMERIC, DocValuesType.NUMERIC);
                return DocValues.emptySortedNumeric();
            }
            return DocValues.singleton(single);
        }
        return dv;
    }

    public static SortedSetDocValues getSortedSet(LeafReader reader, String field2) throws IOException {
        SortedSetDocValues dv = reader.getSortedSetDocValues(field2);
        if (dv == null) {
            SortedDocValues sorted = reader.getSortedDocValues(field2);
            if (sorted == null) {
                DocValues.checkField(reader, field2, DocValuesType.SORTED, DocValuesType.SORTED_SET);
                return DocValues.emptySortedSet();
            }
            dv = DocValues.singleton(sorted);
        }
        return dv;
    }

    public static boolean isCacheable(LeafReaderContext ctx, String ... fields) {
        for (String field2 : fields) {
            FieldInfo fi = ctx.reader().getFieldInfos().fieldInfo(field2);
            if (fi == null || fi.getDocValuesGen() <= -1L) continue;
            return false;
        }
        return true;
    }
}

