/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefComparator;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;

final class FieldUpdatesBuffer {
    private static final long SELF_SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldUpdatesBuffer.class);
    private static final long STRING_SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(String.class);
    private final Counter bytesUsed;
    private int numUpdates = 1;
    private final BytesRefArray termValues;
    private BytesRefArray.SortState termSortState;
    private final BytesRefArray byteValues;
    private int[] docsUpTo;
    private long[] numericValues;
    private FixedBitSet hasValues;
    private long maxNumeric = Long.MIN_VALUE;
    private long minNumeric = Long.MAX_VALUE;
    private String[] fields;
    private final boolean isNumeric;
    private boolean finished = false;

    private FieldUpdatesBuffer(Counter bytesUsed, DocValuesUpdate initialValue, int docUpTo, boolean isNumeric) {
        this.bytesUsed = bytesUsed;
        this.bytesUsed.addAndGet(SELF_SHALLOW_SIZE);
        this.termValues = new BytesRefArray(bytesUsed);
        this.termValues.append(initialValue.term.bytes);
        this.fields = new String[]{initialValue.term.field};
        bytesUsed.addAndGet(FieldUpdatesBuffer.sizeOfString(initialValue.term.field));
        this.docsUpTo = new int[]{docUpTo};
        if (!initialValue.hasValue) {
            this.hasValues = new FixedBitSet(1);
            bytesUsed.addAndGet(this.hasValues.ramBytesUsed());
        }
        this.isNumeric = isNumeric;
        this.byteValues = isNumeric ? null : new BytesRefArray(bytesUsed);
    }

    private static long sizeOfString(String string) {
        return STRING_SHALLOW_SIZE + (long)string.length() * 2L;
    }

    FieldUpdatesBuffer(Counter bytesUsed, DocValuesUpdate.NumericDocValuesUpdate initialValue, int docUpTo) {
        this(bytesUsed, initialValue, docUpTo, true);
        if (initialValue.hasValue()) {
            this.numericValues = new long[]{initialValue.getValue()};
            this.maxNumeric = this.minNumeric = initialValue.getValue();
        } else {
            this.numericValues = new long[]{0L};
        }
        bytesUsed.addAndGet(8L);
    }

    FieldUpdatesBuffer(Counter bytesUsed, DocValuesUpdate.BinaryDocValuesUpdate initialValue, int docUpTo) {
        this(bytesUsed, initialValue, docUpTo, false);
        if (initialValue.hasValue()) {
            this.byteValues.append(initialValue.getValue());
        }
    }

    long getMaxNumeric() {
        assert (this.isNumeric);
        if (this.minNumeric == Long.MAX_VALUE && this.maxNumeric == Long.MIN_VALUE) {
            return 0L;
        }
        return this.maxNumeric;
    }

    long getMinNumeric() {
        assert (this.isNumeric);
        if (this.minNumeric == Long.MAX_VALUE && this.maxNumeric == Long.MIN_VALUE) {
            return 0L;
        }
        return this.minNumeric;
    }

    void add(String field2, int docUpTo, int ord, boolean hasValue) {
        Object[] array;
        assert (!this.finished) : "buffer was finished already";
        if (!this.fields[0].equals(field2) || this.fields.length != 1) {
            if (this.fields.length <= ord) {
                array = ArrayUtil.grow(this.fields, ord + 1);
                if (this.fields.length == 1) {
                    Arrays.fill(array, 1, ord, this.fields[0]);
                }
                this.bytesUsed.addAndGet((long)(array.length - this.fields.length) * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF);
                this.fields = array;
            }
            if (field2 != this.fields[0]) {
                this.bytesUsed.addAndGet(FieldUpdatesBuffer.sizeOfString(field2));
            }
            this.fields[ord] = field2;
        }
        if (this.docsUpTo[0] != docUpTo || this.docsUpTo.length != 1) {
            if (this.docsUpTo.length <= ord) {
                array = ArrayUtil.grow(this.docsUpTo, ord + 1);
                if (this.docsUpTo.length == 1) {
                    Arrays.fill((int[])array, 1, ord, this.docsUpTo[0]);
                }
                this.bytesUsed.addAndGet((long)(array.length - this.docsUpTo.length) * 4L);
                this.docsUpTo = (int[])array;
            }
            this.docsUpTo[ord] = docUpTo;
        }
        if (!hasValue || this.hasValues != null) {
            if (this.hasValues == null) {
                this.hasValues = new FixedBitSet(ord + 1);
                this.hasValues.set(0, ord);
                this.bytesUsed.addAndGet(this.hasValues.ramBytesUsed());
            } else if (this.hasValues.length() <= ord) {
                FixedBitSet fixedBitSet = FixedBitSet.ensureCapacity(this.hasValues, ArrayUtil.oversize(ord + 1, 1));
                this.bytesUsed.addAndGet(fixedBitSet.ramBytesUsed() - this.hasValues.ramBytesUsed());
                this.hasValues = fixedBitSet;
            }
            if (hasValue) {
                this.hasValues.set(ord);
            }
        }
    }

    void addUpdate(Term term, long value, int docUpTo) {
        assert (this.isNumeric);
        int ord = this.append(term);
        String field2 = term.field;
        this.add(field2, docUpTo, ord, true);
        this.minNumeric = Math.min(this.minNumeric, value);
        this.maxNumeric = Math.max(this.maxNumeric, value);
        if (this.numericValues[0] != value || this.numericValues.length != 1) {
            if (this.numericValues.length <= ord) {
                long[] array = ArrayUtil.grow(this.numericValues, ord + 1);
                if (this.numericValues.length == 1) {
                    Arrays.fill(array, 1, ord, this.numericValues[0]);
                }
                this.bytesUsed.addAndGet((long)(array.length - this.numericValues.length) * 8L);
                this.numericValues = array;
            }
            this.numericValues[ord] = value;
        }
    }

    void addNoValue(Term term, int docUpTo) {
        int ord = this.append(term);
        this.add(term.field, docUpTo, ord, false);
    }

    void addUpdate(Term term, BytesRef value, int docUpTo) {
        assert (!this.isNumeric);
        int ord = this.append(term);
        this.byteValues.append(value);
        this.add(term.field, docUpTo, ord, true);
    }

    private int append(Term term) {
        this.termValues.append(term.bytes);
        return this.numUpdates++;
    }

    void finish() {
        boolean sortedTerms;
        if (this.finished) {
            throw new IllegalStateException("buffer was finished already");
        }
        this.finished = true;
        boolean bl = sortedTerms = this.hasSingleValue() && this.hasValues == null && this.fields.length == 1;
        if (sortedTerms) {
            this.termSortState = this.termValues.sort(BytesRefComparator.NATURAL, true);
            assert (this.assertTermAndDocInOrder());
            this.bytesUsed.addAndGet(this.termSortState.ramBytesUsed());
        }
    }

    private boolean assertTermAndDocInOrder() {
        block6: {
            try {
                BytesRef current;
                BytesRefArray.IndexedBytesRefIterator iterator = this.termValues.iterator(this.termSortState);
                BytesRef last = null;
                int lastOrd = -1;
                while ((current = iterator.next()) != null) {
                    if (last != null) {
                        int cmp = current.compareTo(last);
                        assert (cmp >= 0) : "term in reverse order";
                        assert (cmp != 0 || this.docsUpTo[FieldUpdatesBuffer.getArrayIndex(this.docsUpTo.length, lastOrd)] <= this.docsUpTo[FieldUpdatesBuffer.getArrayIndex(this.docsUpTo.length, iterator.ord())]) : "doc id in reverse order";
                    }
                    last = BytesRef.deepCopyOf(current);
                    lastOrd = iterator.ord();
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        return true;
    }

    BufferedUpdateIterator iterator() {
        if (!this.finished) {
            throw new IllegalStateException("buffer is not finished yet");
        }
        return new BufferedUpdateIterator();
    }

    boolean isNumeric() {
        assert (this.isNumeric || this.byteValues != null);
        return this.isNumeric;
    }

    boolean hasSingleValue() {
        return this.isNumeric && this.numericValues.length == 1;
    }

    long getNumericValue(int idx) {
        if (this.hasValues != null && !this.hasValues.get(idx)) {
            return 0L;
        }
        return this.numericValues[FieldUpdatesBuffer.getArrayIndex(this.numericValues.length, idx)];
    }

    private static int getArrayIndex(int arrayLength, int index) {
        assert (arrayLength == 1 || arrayLength > index) : "illegal array index length: " + arrayLength + " index: " + index;
        return Math.min(arrayLength - 1, index);
    }

    class BufferedUpdateIterator {
        private final BytesRefArray.IndexedBytesRefIterator termValuesIterator;
        private final BytesRefArray.IndexedBytesRefIterator lookAheadTermIterator;
        private final BytesRefIterator byteValuesIterator;
        private final BufferedUpdate bufferedUpdate = new BufferedUpdate();
        private final Bits updatesWithValue;

        BufferedUpdateIterator() {
            this.termValuesIterator = FieldUpdatesBuffer.this.termValues.iterator(FieldUpdatesBuffer.this.termSortState);
            this.lookAheadTermIterator = FieldUpdatesBuffer.this.termSortState != null ? FieldUpdatesBuffer.this.termValues.iterator(FieldUpdatesBuffer.this.termSortState) : null;
            this.byteValuesIterator = FieldUpdatesBuffer.this.isNumeric ? null : FieldUpdatesBuffer.this.byteValues.iterator();
            this.updatesWithValue = FieldUpdatesBuffer.this.hasValues == null ? new Bits.MatchAllBits(FieldUpdatesBuffer.this.numUpdates) : FieldUpdatesBuffer.this.hasValues;
        }

        boolean isSortedTerms() {
            return FieldUpdatesBuffer.this.termSortState != null;
        }

        BufferedUpdate next() throws IOException {
            BytesRef next = this.nextTerm();
            if (next != null) {
                int idx = this.termValuesIterator.ord();
                this.bufferedUpdate.termValue = next;
                this.bufferedUpdate.hasValue = this.updatesWithValue.get(idx);
                this.bufferedUpdate.termField = FieldUpdatesBuffer.this.fields[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.fields.length, idx)];
                this.bufferedUpdate.docUpTo = FieldUpdatesBuffer.this.docsUpTo[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.docsUpTo.length, idx)];
                if (this.bufferedUpdate.hasValue) {
                    if (FieldUpdatesBuffer.this.isNumeric) {
                        this.bufferedUpdate.numericValue = FieldUpdatesBuffer.this.numericValues[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.numericValues.length, idx)];
                        this.bufferedUpdate.binaryValue = null;
                    } else {
                        this.bufferedUpdate.binaryValue = this.byteValuesIterator.next();
                    }
                } else {
                    this.bufferedUpdate.binaryValue = null;
                    this.bufferedUpdate.numericValue = 0L;
                }
                return this.bufferedUpdate;
            }
            return null;
        }

        BytesRef nextTerm() throws IOException {
            if (this.lookAheadTermIterator != null) {
                BytesRef lastTerm;
                BytesRef aheadTerm;
                if (this.bufferedUpdate.termValue == null) {
                    this.lookAheadTermIterator.next();
                }
                do {
                    aheadTerm = this.lookAheadTermIterator.next();
                    lastTerm = this.termValuesIterator.next();
                } while (aheadTerm != null && this.lookAheadTermIterator.ord() > this.termValuesIterator.ord() && aheadTerm.equals(lastTerm));
                return lastTerm;
            }
            return this.termValuesIterator.next();
        }
    }

    static class BufferedUpdate {
        int docUpTo;
        long numericValue;
        BytesRef binaryValue;
        boolean hasValue;
        String termField;
        BytesRef termValue;

        private BufferedUpdate() {
        }

        public int hashCode() {
            throw new UnsupportedOperationException("this struct should not be use in map or other data-structures that use hashCode / equals");
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException("this struct should not be use in map or other data-structures that use hashCode / equals");
        }
    }
}

