/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90.blocktree;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.lucene90.blocktree.FieldReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.Outputs;

public final class Lucene90BlockTreeTermsReader
extends FieldsProducer {
    static final Outputs<BytesRef> FST_OUTPUTS = ByteSequenceOutputs.getSingleton();
    static final BytesRef NO_OUTPUT = FST_OUTPUTS.getNoOutput();
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    static final String TERMS_EXTENSION = "tim";
    static final String TERMS_CODEC_NAME = "BlockTreeTermsDict";
    public static final int VERSION_START = 0;
    public static final int VERSION_MSB_VLONG_OUTPUT = 1;
    public static final int VERSION_FST_CONTINUOUS_ARCS = 2;
    public static final int VERSION_CURRENT = 2;
    static final String TERMS_INDEX_EXTENSION = "tip";
    static final String TERMS_INDEX_CODEC_NAME = "BlockTreeTermsIndex";
    static final String TERMS_META_EXTENSION = "tmd";
    static final String TERMS_META_CODEC_NAME = "BlockTreeTermsMeta";
    final IndexInput termsIn;
    final IndexInput indexIn;
    final PostingsReaderBase postingsReader;
    private final Map<String, FieldReader> fieldMap;
    private final List<String> fieldList;
    final String segment;
    final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene90BlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        boolean success = false;
        this.postingsReader = postingsReader;
        this.segment = state.segmentInfo.name;
        try {
            long termsLength;
            long indexLength;
            HashMap<String, FieldReader> fieldMap;
            block25: {
                String termsName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_EXTENSION);
                this.termsIn = state.directory.openInput(termsName, state.context);
                this.version = CodecUtil.checkIndexHeader(this.termsIn, TERMS_CODEC_NAME, 0, 2, state.segmentInfo.getId(), state.segmentSuffix);
                String indexName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_INDEX_EXTENSION);
                this.indexIn = state.directory.openInput(indexName, IOContext.LOAD);
                CodecUtil.checkIndexHeader(this.indexIn, TERMS_INDEX_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                String metaName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_META_EXTENSION);
                fieldMap = null;
                Throwable priorE = null;
                indexLength = -1L;
                termsLength = -1L;
                try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(metaName, IOContext.READONCE);){
                    block24: {
                        try {
                            CodecUtil.checkIndexHeader(metaIn, TERMS_META_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                            postingsReader.init(metaIn, state);
                            int numFields = metaIn.readVInt();
                            if (numFields < 0) {
                                throw new CorruptIndexException("invalid numFields: " + numFields, metaIn);
                            }
                            fieldMap = CollectionUtil.newHashMap(numFields);
                            for (int i = 0; i < numFields; ++i) {
                                int field2 = metaIn.readVInt();
                                long numTerms = metaIn.readVLong();
                                if (numTerms <= 0L) {
                                    throw new CorruptIndexException("Illegal numTerms for field number: " + field2, metaIn);
                                }
                                BytesRef rootCode = Lucene90BlockTreeTermsReader.readBytesRef(metaIn);
                                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field2);
                                if (fieldInfo == null) {
                                    throw new CorruptIndexException("invalid field number: " + field2, metaIn);
                                }
                                long sumTotalTermFreq = metaIn.readVLong();
                                long sumDocFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? sumTotalTermFreq : metaIn.readVLong();
                                int docCount = metaIn.readVInt();
                                BytesRef minTerm = Lucene90BlockTreeTermsReader.readBytesRef(metaIn);
                                BytesRef maxTerm = Lucene90BlockTreeTermsReader.readBytesRef(metaIn);
                                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), metaIn);
                                }
                                if (sumDocFreq < (long)docCount) {
                                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, metaIn);
                                }
                                if (sumTotalTermFreq < sumDocFreq) {
                                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, metaIn);
                                }
                                long indexStartFP = metaIn.readVLong();
                                FieldReader previous = fieldMap.put(fieldInfo.name, new FieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, metaIn, this.indexIn, minTerm, maxTerm));
                                if (previous == null) continue;
                                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, metaIn);
                            }
                            indexLength = metaIn.readLong();
                            termsLength = metaIn.readLong();
                            if (metaIn == null) break block24;
                        }
                        catch (Throwable exception) {
                            try {
                                priorE = exception;
                                break block25;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (metaIn != null) {
                                    CodecUtil.checkFooter(metaIn, priorE);
                                } else if (priorE != null) {
                                    IOUtils.rethrowAlways(priorE);
                                }
                            }
                        }
                        CodecUtil.checkFooter(metaIn, priorE);
                        break block25;
                    }
                    if (priorE != null) {
                        IOUtils.rethrowAlways(priorE);
                    }
                }
            }
            CodecUtil.retrieveChecksum(this.indexIn, indexLength);
            CodecUtil.retrieveChecksum(this.termsIn, termsLength);
            ArrayList fieldList = new ArrayList(fieldMap.keySet());
            fieldList.sort(null);
            this.fieldMap = fieldMap;
            this.fieldList = Collections.unmodifiableList(fieldList);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(new Closeable[]{this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        int numBytes = in.readVInt();
        if (numBytes < 0) {
            throw new CorruptIndexException("invalid bytes length: " + numBytes, in);
        }
        BytesRef bytes = new BytesRef();
        bytes.length = numBytes;
        bytes.bytes = new byte[numBytes];
        in.readBytes(bytes.bytes, 0, numBytes);
        return bytes;
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.indexIn, this.termsIn, this.postingsReader);
        }
        finally {
            this.fieldMap.clear();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.fieldList.iterator();
    }

    @Override
    public Terms terms(String field2) throws IOException {
        assert (field2 != null);
        return this.fieldMap.get(field2);
    }

    @Override
    public int size() {
        return this.fieldMap.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + String.valueOf(b);
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.indexIn);
        CodecUtil.checksumEntireFile(this.termsIn);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fieldMap.size() + ",delegate=" + String.valueOf(this.postingsReader) + ")";
    }
}

