/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Multiset;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private final int minimumNumberShouldMatch;
    private final List<BooleanClause> clauses;
    private final Map<BooleanClause.Occur, Collection<Query>> clauseSets;
    private int hashCode;

    @Deprecated
    public static int getMaxClauseCount() {
        return IndexSearcher.getMaxClauseCount();
    }

    @Deprecated
    public static void setMaxClauseCount(int maxClauseCount) {
        IndexSearcher.setMaxClauseCount(maxClauseCount);
    }

    private BooleanQuery(int minimumNumberShouldMatch, BooleanClause[] clauses) {
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
        this.clauses = Collections.unmodifiableList(Arrays.asList(clauses));
        this.clauseSets = new EnumMap<BooleanClause.Occur, Collection<Query>>(BooleanClause.Occur.class);
        this.clauseSets.put(BooleanClause.Occur.SHOULD, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.MUST, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.FILTER, new HashSet());
        this.clauseSets.put(BooleanClause.Occur.MUST_NOT, new HashSet());
        for (BooleanClause clause : clauses) {
            this.clauseSets.get((Object)clause.getOccur()).add(clause.getQuery());
        }
    }

    public int getMinimumNumberShouldMatch() {
        return this.minimumNumberShouldMatch;
    }

    public List<BooleanClause> clauses() {
        return this.clauses;
    }

    Collection<Query> getClauses(BooleanClause.Occur occur) {
        return this.clauseSets.get((Object)occur);
    }

    boolean isPureDisjunction() {
        return this.clauses.size() == this.getClauses(BooleanClause.Occur.SHOULD).size() && this.minimumNumberShouldMatch <= 1;
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    BooleanQuery rewriteNoScoring() {
        boolean actuallyRewritten = false;
        Builder newQuery = new Builder().setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean keepShould = this.getMinimumNumberShouldMatch() > 0 || this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() + this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() == 0;
        for (BooleanClause clause : this.clauses) {
            BooleanClause.Occur occur;
            Query query = clause.getQuery();
            Query rewritten = query;
            if (rewritten instanceof BoostQuery) {
                rewritten = ((BoostQuery)rewritten).getQuery();
            }
            if (rewritten instanceof ConstantScoreQuery) {
                rewritten = ((ConstantScoreQuery)rewritten).getQuery();
            }
            if (rewritten instanceof BooleanQuery) {
                rewritten = ((BooleanQuery)rewritten).rewriteNoScoring();
            }
            if ((occur = clause.getOccur()) == BooleanClause.Occur.SHOULD && !keepShould) {
                actuallyRewritten = true;
                continue;
            }
            if (occur == BooleanClause.Occur.MUST) {
                newQuery.add(rewritten, BooleanClause.Occur.FILTER);
                actuallyRewritten = true;
                continue;
            }
            if (query != rewritten) {
                newQuery.add(rewritten, occur);
                actuallyRewritten = true;
                continue;
            }
            newQuery.add(clause);
        }
        if (!actuallyRewritten) {
            return this;
        }
        return newQuery.build();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new BooleanWeight(this, searcher, scoreMode, boost);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Collection<Query> shoulds;
        Query query;
        BoostQuery bq;
        Collection<Query> filters;
        Query rewritten;
        if (this.clauses.size() == 0) {
            return new MatchNoDocsQuery("empty BooleanQuery");
        }
        if (this.clauses.size() == 1) {
            BooleanClause c = this.clauses.get(0);
            Query query2 = c.getQuery();
            if (this.minimumNumberShouldMatch == 1 && c.getOccur() == BooleanClause.Occur.SHOULD) {
                return query2;
            }
            if (this.minimumNumberShouldMatch == 0) {
                switch (c.getOccur()) {
                    case SHOULD: 
                    case MUST: {
                        return query2;
                    }
                    case FILTER: {
                        return new BoostQuery(new ConstantScoreQuery(query2), 0.0f);
                    }
                    case MUST_NOT: {
                        return new MatchNoDocsQuery("pure negative BooleanQuery");
                    }
                }
                throw new AssertionError();
            }
        }
        Builder builder2 = new Builder();
        builder2.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean actuallyRewritten = false;
        for (BooleanClause booleanClause : this) {
            Query query2 = booleanClause.getQuery();
            Object occur = booleanClause.getOccur();
            if (occur == BooleanClause.Occur.FILTER || occur == BooleanClause.Occur.MUST_NOT) {
                rewritten = new ConstantScoreQuery(query2).rewrite(indexSearcher);
                if (rewritten instanceof ConstantScoreQuery) {
                    rewritten = ((ConstantScoreQuery)rewritten).getQuery();
                }
            } else {
                rewritten = query2.rewrite(indexSearcher);
            }
            if (rewritten != query2 || query2.getClass() == MatchNoDocsQuery.class) {
                actuallyRewritten = true;
                if (rewritten.getClass() == MatchNoDocsQuery.class) {
                    switch (occur) {
                        case SHOULD: 
                        case MUST_NOT: {
                            break;
                        }
                        case MUST: 
                        case FILTER: {
                            return rewritten;
                        }
                    }
                    continue;
                }
                builder2.add(rewritten, (BooleanClause.Occur)((Object)occur));
                continue;
            }
            builder2.add(booleanClause);
        }
        if (actuallyRewritten) {
            return builder2.build();
        }
        int clauseCount = 0;
        for (Collection<Query> collection : this.clauseSets.values()) {
            clauseCount += collection.size();
        }
        if (clauseCount != this.clauses.size()) {
            Builder rewritten2 = new Builder();
            rewritten2.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
            for (Map.Entry<BooleanClause.Occur, Collection<Query>> entry : this.clauseSets.entrySet()) {
                BooleanClause.Occur occur = entry.getKey();
                for (Object query4 : entry.getValue()) {
                    rewritten2.add((Query)query4, occur);
                }
            }
            return rewritten2.build();
        }
        Collection<Query> mustNotClauses = this.clauseSets.get((Object)BooleanClause.Occur.MUST_NOT);
        if (!mustNotClauses.isEmpty()) {
            Predicate<Query> p = this.clauseSets.get((Object)BooleanClause.Occur.MUST)::contains;
            if (mustNotClauses.stream().anyMatch(p.or(this.clauseSets.get((Object)BooleanClause.Occur.FILTER)::contains))) {
                return new MatchNoDocsQuery("FILTER or MUST clause also in MUST_NOT");
            }
            if (mustNotClauses.contains(new MatchAllDocsQuery())) {
                return new MatchNoDocsQuery("MUST_NOT clause is MatchAllDocsQuery");
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            boolean bl;
            boolean bl2;
            filters = new HashSet<Query>(this.clauseSets.get((Object)BooleanClause.Occur.FILTER));
            boolean bl3 = false;
            if (filters.size() > 1 || !this.clauseSets.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
                bl2 = filters.remove(new MatchAllDocsQuery());
            }
            if (bl = bl2 | filters.removeAll(this.clauseSets.get((Object)BooleanClause.Occur.MUST))) {
                Builder builder = new Builder();
                builder.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
                for (BooleanClause clause : this.clauses) {
                    if (clause.getOccur() == BooleanClause.Occur.FILTER) continue;
                    builder.add(clause);
                }
                for (Query filter : filters) {
                    builder.add(filter, BooleanClause.Occur.FILTER);
                }
                return builder.build();
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            filters = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
            Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
            HashSet<Query> hashSet = new HashSet<Query>(filters);
            hashSet.retainAll(collection);
            if (!hashSet.isEmpty()) {
                Builder builder = new Builder();
                int minShouldMatch = this.getMinimumNumberShouldMatch();
                for (BooleanClause booleanClause : this.clauses) {
                    if (hashSet.contains(booleanClause.getQuery())) {
                        if (booleanClause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                        builder.add(new BooleanClause(booleanClause.getQuery(), BooleanClause.Occur.MUST));
                        --minShouldMatch;
                        continue;
                    }
                    builder.add(booleanClause);
                }
                builder.setMinimumNumberShouldMatch(Math.max(0, minShouldMatch));
                return builder.build();
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && this.minimumNumberShouldMatch <= 1) {
            HashMap<void, Double> shouldClauses = new HashMap<void, Double>();
            for (Query query3 : this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)) {
                void var5_35;
                double d = 1.0;
                while (var5_35 instanceof BoostQuery) {
                    bq = (BoostQuery)var5_35;
                    d *= (double)bq.getBoost();
                    Query query4 = bq.getQuery();
                }
                shouldClauses.put(var5_35, shouldClauses.getOrDefault(var5_35, 0.0) + d);
            }
            if (shouldClauses.size() != this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size()) {
                Builder builder = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (Map.Entry entry : shouldClauses.entrySet()) {
                    query = (Query)entry.getKey();
                    float boost = ((Double)entry.getValue()).floatValue();
                    if (boost != 1.0f) {
                        query = new BoostQuery(query, boost);
                    }
                    builder.add(query, BooleanClause.Occur.SHOULD);
                }
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.getOccur() == BooleanClause.Occur.SHOULD) continue;
                    builder.add(booleanClause);
                }
                return builder.build();
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() > 0) {
            HashMap<void, Double> mustClauses = new HashMap<void, Double>();
            for (Query query5 : this.clauseSets.get((Object)BooleanClause.Occur.MUST)) {
                void var5_41;
                double d = 1.0;
                while (var5_41 instanceof BoostQuery) {
                    bq = (BoostQuery)var5_41;
                    d *= (double)bq.getBoost();
                    Query query6 = bq.getQuery();
                }
                mustClauses.put(var5_41, mustClauses.getOrDefault(var5_41, 0.0) + d);
            }
            if (mustClauses.size() != this.clauseSets.get((Object)BooleanClause.Occur.MUST).size()) {
                Builder builder = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (Map.Entry entry : mustClauses.entrySet()) {
                    query = (Query)entry.getKey();
                    float boost = ((Double)entry.getValue()).floatValue();
                    if (boost != 1.0f) {
                        query = new BoostQuery(query, boost);
                    }
                    builder.add(query, BooleanClause.Occur.MUST);
                }
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.getOccur() == BooleanClause.Occur.MUST) continue;
                    builder.add(booleanClause);
                }
                return builder.build();
            }
        }
        Collection<Query> musts = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
        if (musts.size() == 1 && collection.size() > 0) {
            void var5_47;
            Query query7 = musts.iterator().next();
            float f = 1.0f;
            if (query7 instanceof BoostQuery) {
                BoostQuery boostQuery = (BoostQuery)query7;
                Query query8 = boostQuery.getQuery();
                f = boostQuery.getBoost();
            }
            if (var5_47.getClass() == MatchAllDocsQuery.class) {
                Builder builder5 = new Builder();
                for (BooleanClause booleanClause : this.clauses) {
                    switch (booleanClause.getOccur()) {
                        case FILTER: 
                        case MUST_NOT: {
                            builder5.add(booleanClause);
                            break;
                        }
                    }
                }
                rewritten = builder5.build();
                rewritten = new ConstantScoreQuery(rewritten);
                if (f != 1.0f) {
                    rewritten = new BoostQuery(rewritten, f);
                }
                builder5 = new Builder().setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch()).add(rewritten, BooleanClause.Occur.MUST);
                for (Query query6 : this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)) {
                    builder5.add(query6, BooleanClause.Occur.SHOULD);
                }
                rewritten = builder5.build();
                return rewritten;
            }
        }
        if (this.minimumNumberShouldMatch <= 1) {
            boolean bl;
            Builder builder6 = new Builder();
            builder6.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
            boolean bl4 = false;
            for (BooleanClause booleanClause : this.clauses) {
                if (booleanClause.getOccur() == BooleanClause.Occur.SHOULD && booleanClause.getQuery() instanceof BooleanQuery) {
                    BooleanQuery innerQuery = (BooleanQuery)booleanClause.getQuery();
                    if (innerQuery.isPureDisjunction()) {
                        bl = true;
                        for (BooleanClause booleanClause2 : innerQuery.clauses()) {
                            builder6.add(booleanClause2);
                        }
                        continue;
                    }
                    builder6.add(booleanClause);
                    continue;
                }
                builder6.add(booleanClause);
            }
            if (bl) {
                return builder6.build();
            }
        }
        if ((shoulds = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)).size() > 0) {
            if (shoulds.size() < this.minimumNumberShouldMatch) {
                return new MatchNoDocsQuery("SHOULD clause count less than minimumNumberShouldMatch");
            }
            if (shoulds.size() == this.minimumNumberShouldMatch) {
                Builder builder = new Builder();
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.getOccur() == BooleanClause.Occur.SHOULD) {
                        builder.add(booleanClause.getQuery(), BooleanClause.Occur.MUST);
                        continue;
                    }
                    builder.add(booleanClause);
                }
                return builder.build();
            }
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        QueryVisitor sub = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        for (BooleanClause.Occur occur : this.clauseSets.keySet()) {
            if (this.clauseSets.get((Object)occur).size() <= 0) continue;
            if (occur == BooleanClause.Occur.MUST) {
                for (Query q : this.clauseSets.get((Object)occur)) {
                    q.visit(sub);
                }
                continue;
            }
            QueryVisitor v = sub.getSubVisitor(occur, this);
            for (Query q : this.clauseSets.get((Object)occur)) {
                q.visit(v);
            }
        }
    }

    @Override
    public String toString(String field2) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        int i = 0;
        for (BooleanClause c : this) {
            buffer.append(c.getOccur().toString());
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subQuery.toString(field2));
                buffer.append(")");
            } else {
                buffer.append(subQuery.toString(field2));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((BooleanQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(BooleanQuery other) {
        return this.getMinimumNumberShouldMatch() == other.getMinimumNumberShouldMatch() && this.clauseSets.equals(other.clauseSets);
    }

    private int computeHashCode() {
        int hashCode = Objects.hash(this.minimumNumberShouldMatch, this.clauseSets);
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            assert (this.hashCode != 0);
        }
        assert (this.hashCode == this.computeHashCode());
        return this.hashCode;
    }

    public static class Builder {
        private int minimumNumberShouldMatch;
        private final List<BooleanClause> clauses = new ArrayList<BooleanClause>();

        public Builder setMinimumNumberShouldMatch(int min) {
            this.minimumNumberShouldMatch = min;
            return this;
        }

        public Builder add(BooleanClause clause) {
            if (this.clauses.size() >= IndexSearcher.maxClauseCount) {
                throw new IndexSearcher.TooManyClauses();
            }
            this.clauses.add(clause);
            return this;
        }

        public Builder add(Query query, BooleanClause.Occur occur) {
            return this.add(new BooleanClause(query, occur));
        }

        public BooleanQuery build() {
            return new BooleanQuery(this.minimumNumberShouldMatch, this.clauses.toArray(new BooleanClause[0]));
        }
    }

    @Deprecated
    public static class TooManyClauses
    extends IndexSearcher.TooManyClauses {
    }
}

