/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public final class FrequencyTrackingRingBuffer
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FrequencyTrackingRingBuffer.class);
    private final int maxSize;
    private final int[] buffer;
    private int position;
    private final IntBag frequencies;

    public FrequencyTrackingRingBuffer(int maxSize, int sentinel) {
        if (maxSize < 2) {
            throw new IllegalArgumentException("maxSize must be at least 2");
        }
        this.maxSize = maxSize;
        this.buffer = new int[maxSize];
        this.position = 0;
        this.frequencies = new IntBag(maxSize);
        Arrays.fill(this.buffer, sentinel);
        for (int i = 0; i < maxSize; ++i) {
            this.frequencies.add(sentinel);
        }
        assert (this.frequencies.frequency(sentinel) == maxSize);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.frequencies.ramBytesUsed() + RamUsageEstimator.sizeOf(this.buffer);
    }

    public void add(int i) {
        int removed = this.buffer[this.position];
        boolean removedFromBag = this.frequencies.remove(removed);
        assert (removedFromBag);
        this.buffer[this.position] = i;
        this.frequencies.add(i);
        ++this.position;
        if (this.position == this.maxSize) {
            this.position = 0;
        }
    }

    public int frequency(int key2) {
        return this.frequencies.frequency(key2);
    }

    Map<Integer, Integer> asFrequencyMap() {
        return this.frequencies.asMap();
    }

    private static class IntBag
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntBag.class);
        private final int[] keys;
        private final int[] freqs;
        private final int mask;

        IntBag(int maxSize) {
            int capacity = Math.max(2, maxSize * 3 / 2);
            capacity = Integer.highestOneBit(capacity - 1) << 1;
            assert (capacity > maxSize);
            this.keys = new int[capacity];
            this.freqs = new int[capacity];
            this.mask = capacity - 1;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + RamUsageEstimator.sizeOf(this.freqs);
        }

        int frequency(int key2) {
            int slot = key2 & this.mask;
            while (this.keys[slot] != key2) {
                if (this.freqs[slot] == 0) {
                    return 0;
                }
                slot = slot + 1 & this.mask;
            }
            return this.freqs[slot];
        }

        int add(int key2) {
            int slot = key2 & this.mask;
            while (true) {
                if (this.freqs[slot] == 0) {
                    this.keys[slot] = key2;
                    this.freqs[slot] = 1;
                    return 1;
                }
                if (this.keys[slot] == key2) {
                    int n = slot;
                    int n2 = this.freqs[n] + 1;
                    this.freqs[n] = n2;
                    return n2;
                }
                slot = slot + 1 & this.mask;
            }
        }

        boolean remove(int key2) {
            int slot = key2 & this.mask;
            while (this.freqs[slot] != 0) {
                if (this.keys[slot] == key2) {
                    int n = slot;
                    this.freqs[n] = this.freqs[n] - 1;
                    int newFreq = this.freqs[n];
                    if (newFreq == 0) {
                        this.relocateAdjacentKeys(slot);
                    }
                    return true;
                }
                slot = slot + 1 & this.mask;
            }
            return false;
        }

        private void relocateAdjacentKeys(int freeSlot) {
            int freq;
            int slot = freeSlot + 1 & this.mask;
            while ((freq = this.freqs[slot]) != 0) {
                int key2 = this.keys[slot];
                int expectedSlot = key2 & this.mask;
                if (IntBag.between(expectedSlot, slot, freeSlot)) {
                    this.keys[freeSlot] = key2;
                    this.freqs[freeSlot] = freq;
                    this.freqs[slot] = 0;
                    freeSlot = slot;
                }
                slot = slot + 1 & this.mask;
            }
        }

        private static boolean between(int chainStart, int chainEnd, int slot) {
            if (chainStart <= chainEnd) {
                return chainStart <= slot && slot <= chainEnd;
            }
            return slot >= chainStart || slot <= chainEnd;
        }

        Map<Integer, Integer> asMap() {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.freqs[i] <= 0) continue;
                map.put(this.keys[i], this.freqs[i]);
            }
            return map;
        }
    }
}

