/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import java.io.OutputStream;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import ujson.BaseByteRenderer$;
import ujson.DoubleToDecimalByte;
import ujson.FloatToDecimalByte;
import ujson.JsVisitor;
import upickle.core.ArrVisitor;
import upickle.core.ByteBuilder;
import upickle.core.ByteBuilder$;
import upickle.core.CharBuilder;
import upickle.core.CharBuilder$;
import upickle.core.ObjVisitor;
import upickle.core.RenderUtils$;
import upickle.core.Visitor;

public class BaseByteRenderer<T extends OutputStream>
implements JsVisitor<T, T> {
    public final T ujson$BaseByteRenderer$$out;
    public final int ujson$BaseByteRenderer$$indent;
    private final boolean escapeUnicode;
    public final ByteBuilder ujson$BaseByteRenderer$$byteBuilder;
    private final CharBuilder unicodeCharBuilder;
    public int ujson$BaseByteRenderer$$depth;
    public boolean ujson$BaseByteRenderer$$visitingKey;
    public boolean ujson$BaseByteRenderer$$commaBuffered;
    public boolean ujson$BaseByteRenderer$$indentBuffered;
    public boolean ujson$BaseByteRenderer$$quoteBuffered;

    public static <T extends OutputStream> int $lessinit$greater$default$2() {
        return BaseByteRenderer$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T extends OutputStream> boolean $lessinit$greater$default$3() {
        return BaseByteRenderer$.MODULE$.$lessinit$greater$default$3();
    }

    public BaseByteRenderer(T out, int indent, boolean escapeUnicode) {
        this.ujson$BaseByteRenderer$$out = out;
        this.ujson$BaseByteRenderer$$indent = indent;
        this.escapeUnicode = escapeUnicode;
        this.ujson$BaseByteRenderer$$byteBuilder = new ByteBuilder(ByteBuilder$.MODULE$.$lessinit$greater$default$1());
        this.unicodeCharBuilder = new CharBuilder(CharBuilder$.MODULE$.$lessinit$greater$default$1());
        this.ujson$BaseByteRenderer$$depth = 0;
        this.ujson$BaseByteRenderer$$visitingKey = false;
        this.ujson$BaseByteRenderer$$commaBuffered = false;
        this.ujson$BaseByteRenderer$$indentBuffered = false;
        this.ujson$BaseByteRenderer$$quoteBuffered = false;
    }

    public void flushByteBuilder() {
        this.ujson$BaseByteRenderer$$byteBuilder.writeOutToIfLongerThan((OutputStream)this.ujson$BaseByteRenderer$$out, this.ujson$BaseByteRenderer$$depth == 0 ? 0 : 1000);
    }

    public void flushBuffer() {
        if (this.ujson$BaseByteRenderer$$commaBuffered) {
            this.ujson$BaseByteRenderer$$commaBuffered = false;
            this.ujson$BaseByteRenderer$$byteBuilder.append(44);
        }
        if (this.ujson$BaseByteRenderer$$indentBuffered) {
            this.ujson$BaseByteRenderer$$indentBuffered = false;
            this.renderIndent();
        }
        if (this.ujson$BaseByteRenderer$$quoteBuffered) {
            this.ujson$BaseByteRenderer$$quoteBuffered = false;
            this.ujson$BaseByteRenderer$$byteBuilder.append(34);
            return;
        }
    }

    @Override
    public ArrVisitor<T, T> visitArray(int length, int index) {
        return new ArrVisitor<T, T>(this){
            private final /* synthetic */ BaseByteRenderer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                $outer.flushBuffer();
                $outer.ujson$BaseByteRenderer$$byteBuilder.append(91);
                ++$outer.ujson$BaseByteRenderer$$depth;
                $outer.ujson$BaseByteRenderer$$indentBuffered = true;
            }

            public Visitor subVisitor() {
                return this.$outer;
            }

            public void visitValue(OutputStream v, int index) {
                this.$outer.flushBuffer();
                this.$outer.ujson$BaseByteRenderer$$commaBuffered = true;
                this.$outer.ujson$BaseByteRenderer$$indentBuffered = true;
            }

            public OutputStream visitEnd(int index) {
                --this.$outer.ujson$BaseByteRenderer$$depth;
                if (this.$outer.ujson$BaseByteRenderer$$indentBuffered && this.$outer.ujson$BaseByteRenderer$$commaBuffered) {
                    this.$outer.renderIndent();
                }
                this.$outer.ujson$BaseByteRenderer$$commaBuffered = false;
                this.$outer.ujson$BaseByteRenderer$$indentBuffered = false;
                this.$outer.ujson$BaseByteRenderer$$byteBuilder.append(93);
                this.$outer.flushByteBuilder();
                return this.$outer.ujson$BaseByteRenderer$$out;
            }
        };
    }

    @Override
    public ObjVisitor<T, T> visitJsonableObject(int length, int index) {
        return new ObjVisitor<T, T>(this){
            private final /* synthetic */ BaseByteRenderer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                $outer.flushBuffer();
                $outer.ujson$BaseByteRenderer$$byteBuilder.append(123);
                ++$outer.ujson$BaseByteRenderer$$depth;
                $outer.ujson$BaseByteRenderer$$indentBuffered = true;
            }

            public Visitor subVisitor() {
                return this.$outer;
            }

            public Visitor visitKey(int index) {
                this.$outer.ujson$BaseByteRenderer$$quoteBuffered = true;
                this.$outer.ujson$BaseByteRenderer$$visitingKey = true;
                return this.$outer;
            }

            public void visitKeyValue(Object s) {
                this.$outer.ujson$BaseByteRenderer$$byteBuilder.append(34);
                this.$outer.ujson$BaseByteRenderer$$visitingKey = false;
                this.$outer.ujson$BaseByteRenderer$$byteBuilder.append(58);
                if (this.$outer.ujson$BaseByteRenderer$$indent != -1) {
                    this.$outer.ujson$BaseByteRenderer$$byteBuilder.append(32);
                    return;
                }
            }

            public void visitValue(OutputStream v, int index) {
                this.$outer.ujson$BaseByteRenderer$$commaBuffered = true;
                this.$outer.ujson$BaseByteRenderer$$indentBuffered = true;
            }

            public OutputStream visitEnd(int index) {
                --this.$outer.ujson$BaseByteRenderer$$depth;
                if (this.$outer.ujson$BaseByteRenderer$$indentBuffered && this.$outer.ujson$BaseByteRenderer$$commaBuffered) {
                    this.$outer.renderIndent();
                }
                this.$outer.ujson$BaseByteRenderer$$commaBuffered = false;
                this.$outer.ujson$BaseByteRenderer$$indentBuffered = false;
                this.$outer.ujson$BaseByteRenderer$$byteBuilder.append(125);
                this.$outer.flushByteBuilder();
                return this.$outer.ujson$BaseByteRenderer$$out;
            }
        };
    }

    @Override
    public T visitNull(int index) {
        this.flushBuffer();
        BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendNull(this.ujson$BaseByteRenderer$$byteBuilder);
        this.flushByteBuilder();
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitFalse(int index) {
        this.flushBuffer();
        BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendFalse(this.ujson$BaseByteRenderer$$byteBuilder);
        this.flushByteBuilder();
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitTrue(int index) {
        this.flushBuffer();
        BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendTrue(this.ujson$BaseByteRenderer$$byteBuilder);
        this.flushByteBuilder();
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        this.flushBuffer();
        BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendKnownAsciiString(this.ujson$BaseByteRenderer$$byteBuilder, s);
        this.flushByteBuilder();
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitFloat32(float d, int index) {
        Object object;
        float f = d;
        if (Float.POSITIVE_INFINITY == f) {
            object = this.visitNonNullString("Infinity", -1);
        } else if (Float.NEGATIVE_INFINITY == f) {
            object = this.visitNonNullString("-Infinity", -1);
        } else {
            float d2 = f;
            if (Float.isNaN(d2)) {
                object = this.visitNonNullString("NaN", -1);
            } else {
                float d3 = f;
                int i = (int)d3;
                if (d3 == (float)i) {
                    object = this.visitInt32(i, index);
                } else {
                    long i2 = (long)d3;
                    this.flushBuffer();
                    if ((float)i2 == d3) {
                        BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendKnownAsciiString(this.ujson$BaseByteRenderer$$byteBuilder, BoxesRunTime.boxToFloat(d3).toString());
                    } else {
                        this.ujson$BaseByteRenderer$$byteBuilder.ensureLength(15);
                        this.ujson$BaseByteRenderer$$byteBuilder.length_$eq(this.ujson$BaseByteRenderer$$byteBuilder.length() + FloatToDecimalByte.toString(this.ujson$BaseByteRenderer$$byteBuilder.arr(), this.ujson$BaseByteRenderer$$byteBuilder.length(), d3));
                    }
                    this.flushByteBuilder();
                    object = BoxedUnit.UNIT;
                }
            }
        }
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitFloat64(double d, int index) {
        Object object;
        double d2 = d;
        if (Double.POSITIVE_INFINITY == d2) {
            object = this.visitNonNullString("Infinity", -1);
        } else if (Double.NEGATIVE_INFINITY == d2) {
            object = this.visitNonNullString("-Infinity", -1);
        } else {
            double d3 = d2;
            if (Double.isNaN(d3)) {
                object = this.visitNonNullString("NaN", -1);
            } else {
                double d4 = d2;
                int i = (int)d4;
                if (d4 == (double)i) {
                    object = this.visitInt32(i, index);
                } else {
                    long i2 = (long)d4;
                    this.flushBuffer();
                    if ((double)i2 == d4) {
                        BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendKnownAsciiString(this.ujson$BaseByteRenderer$$byteBuilder, BoxesRunTime.boxToLong(i2).toString());
                    } else {
                        this.ujson$BaseByteRenderer$$byteBuilder.ensureLength(24);
                        this.ujson$BaseByteRenderer$$byteBuilder.length_$eq(this.ujson$BaseByteRenderer$$byteBuilder.length() + DoubleToDecimalByte.toString(this.ujson$BaseByteRenderer$$byteBuilder.arr(), this.ujson$BaseByteRenderer$$byteBuilder.length(), d4));
                    }
                    this.flushByteBuilder();
                    object = BoxedUnit.UNIT;
                }
            }
        }
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitInt32(int i, int index) {
        this.flushBuffer();
        BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendIntString(this.ujson$BaseByteRenderer$$byteBuilder, i);
        this.flushByteBuilder();
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitInt64(long i, int index) {
        this.flushBuffer();
        if (package$.MODULE$.abs(i) > 0x20000000000000L || i == Long.MIN_VALUE) {
            this.ujson$BaseByteRenderer$$byteBuilder.append(34);
            BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendLongString(this.ujson$BaseByteRenderer$$byteBuilder, i);
            this.ujson$BaseByteRenderer$$byteBuilder.append(34);
        } else {
            BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$appendLongString(this.ujson$BaseByteRenderer$$byteBuilder, i);
        }
        this.flushByteBuilder();
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitUInt64(long i, int index) {
        int n = (int)i;
        Object object = (long)n == i ? this.visitInt32(n, index) : (OutputStream)JsVisitor.visitUInt64$(this, i, index);
        return this.ujson$BaseByteRenderer$$out;
    }

    @Override
    public T visitString(CharSequence s, int index) {
        if (s == null) {
            return (T)this.visitNull(index);
        }
        return this.visitNonNullString(s, index);
    }

    public T visitNonNullString(CharSequence s, int index) {
        this.flushBuffer();
        RenderUtils$.MODULE$.escapeByte(this.unicodeCharBuilder, this.ujson$BaseByteRenderer$$byteBuilder, s, this.escapeUnicode, !this.ujson$BaseByteRenderer$$visitingKey);
        this.flushByteBuilder();
        return this.ujson$BaseByteRenderer$$out;
    }

    public final void renderIndent() {
        if (this.ujson$BaseByteRenderer$$indent == -1) {
            return;
        }
        int i = this.ujson$BaseByteRenderer$$indent * this.ujson$BaseByteRenderer$$depth;
        this.ujson$BaseByteRenderer$$byteBuilder.ensureLength(i + 1);
        BaseByteRenderer$.MODULE$.ujson$BaseByteRenderer$$$renderIdent(this.ujson$BaseByteRenderer$$byteBuilder.arr(), this.ujson$BaseByteRenderer$$byteBuilder.length(), i);
        this.ujson$BaseByteRenderer$$byteBuilder.length_$eq(this.ujson$BaseByteRenderer$$byteBuilder.length() + (i + 1));
    }
}

