/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90.compressing;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.MatchingReaders;
import org.apache.lucene.codecs.lucene90.compressing.FieldsIndex;
import org.apache.lucene.codecs.lucene90.compressing.FieldsIndexWriter;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsReader;
import org.apache.lucene.codecs.lucene90.compressing.StoredFieldsInts;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

public final class Lucene90CompressingStoredFieldsWriter
extends StoredFieldsWriter {
    public static final String FIELDS_EXTENSION = "fdt";
    public static final String INDEX_EXTENSION = "fdx";
    public static final String META_EXTENSION = "fdm";
    public static final String INDEX_CODEC_NAME = "Lucene90FieldsIndex";
    static final int STRING = 0;
    static final int BYTE_ARR = 1;
    static final int NUMERIC_INT = 2;
    static final int NUMERIC_FLOAT = 3;
    static final int NUMERIC_LONG = 4;
    static final int NUMERIC_DOUBLE = 5;
    static final int TYPE_BITS = PackedInts.bitsRequired(5L);
    static final int TYPE_MASK = (int)PackedInts.maxValue(TYPE_BITS);
    static final int VERSION_START = 1;
    static final int VERSION_CURRENT = 1;
    static final int META_VERSION_START = 0;
    private final String segment;
    private FieldsIndexWriter indexWriter;
    private IndexOutput metaStream;
    private IndexOutput fieldsStream;
    private Compressor compressor;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int maxDocsPerChunk;
    private final ByteBuffersDataOutput bufferedDocs;
    private int[] numStoredFields;
    private int[] endOffsets;
    private int docBase;
    private int numBufferedDocs;
    private long numChunks;
    private long numDirtyChunks;
    private long numDirtyDocs;
    private int numStoredFieldsInDoc;
    static final int NEGATIVE_ZERO_FLOAT = Float.floatToIntBits(-0.0f);
    static final long NEGATIVE_ZERO_DOUBLE = Double.doubleToLongBits(-0.0);
    static final long SECOND = 1000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final int SECOND_ENCODING = 64;
    static final int HOUR_ENCODING = 128;
    static final int DAY_ENCODING = 192;
    static final String BULK_MERGE_ENABLED_SYSPROP = Lucene90CompressingStoredFieldsWriter.class.getName() + ".enableBulkMerge";
    static final boolean BULK_MERGE_ENABLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene90CompressingStoredFieldsWriter(Directory directory, SegmentInfo si, String segmentSuffix, IOContext context, String formatName, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) throws IOException {
        assert (directory != null);
        this.segment = si.name;
        this.compressionMode = compressionMode;
        this.compressor = compressionMode.newCompressor();
        this.chunkSize = chunkSize;
        this.maxDocsPerChunk = maxDocsPerChunk;
        this.docBase = 0;
        this.bufferedDocs = ByteBuffersDataOutput.newResettableInstance();
        this.numStoredFields = new int[16];
        this.endOffsets = new int[16];
        this.numBufferedDocs = 0;
        boolean success = false;
        try {
            this.metaStream = directory.createOutput(IndexFileNames.segmentFileName(this.segment, segmentSuffix, META_EXTENSION), context);
            CodecUtil.writeIndexHeader(this.metaStream, "Lucene90FieldsIndexMeta", 1, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength("Lucene90FieldsIndexMeta", segmentSuffix) == this.metaStream.getFilePointer());
            this.fieldsStream = directory.createOutput(IndexFileNames.segmentFileName(this.segment, segmentSuffix, FIELDS_EXTENSION), context);
            CodecUtil.writeIndexHeader(this.fieldsStream, formatName, 1, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength(formatName, segmentSuffix) == this.fieldsStream.getFilePointer());
            this.indexWriter = new FieldsIndexWriter(directory, this.segment, segmentSuffix, INDEX_EXTENSION, INDEX_CODEC_NAME, si.getId(), blockShift, context);
            this.metaStream.writeVInt(chunkSize);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.metaStream, this.fieldsStream, this.indexWriter);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.metaStream, this.fieldsStream, this.indexWriter, this.compressor);
        }
        finally {
            this.metaStream = null;
            this.fieldsStream = null;
            this.indexWriter = null;
            this.compressor = null;
        }
    }

    @Override
    public void startDocument() throws IOException {
    }

    @Override
    public void finishDocument() throws IOException {
        if (this.numBufferedDocs == this.numStoredFields.length) {
            int newLength = ArrayUtil.oversize(this.numBufferedDocs + 1, 4);
            this.numStoredFields = ArrayUtil.growExact(this.numStoredFields, newLength);
            this.endOffsets = ArrayUtil.growExact(this.endOffsets, newLength);
        }
        this.numStoredFields[this.numBufferedDocs] = this.numStoredFieldsInDoc;
        this.numStoredFieldsInDoc = 0;
        this.endOffsets[this.numBufferedDocs] = Math.toIntExact(this.bufferedDocs.size());
        ++this.numBufferedDocs;
        if (this.triggerFlush()) {
            this.flush(false);
        }
    }

    private static void saveInts(int[] values, int length, DataOutput out) throws IOException {
        if (length == 1) {
            out.writeVInt(values[0]);
        } else {
            StoredFieldsInts.writeInts(values, 0, length, out);
        }
    }

    private void writeHeader(int docBase, int numBufferedDocs, int[] numStoredFields, int[] lengths, boolean sliced, boolean dirtyChunk) throws IOException {
        int slicedBit = sliced ? 1 : 0;
        int dirtyBit = dirtyChunk ? 2 : 0;
        this.fieldsStream.writeVInt(docBase);
        this.fieldsStream.writeVInt(numBufferedDocs << 2 | dirtyBit | slicedBit);
        Lucene90CompressingStoredFieldsWriter.saveInts(numStoredFields, numBufferedDocs, this.fieldsStream);
        Lucene90CompressingStoredFieldsWriter.saveInts(lengths, numBufferedDocs, this.fieldsStream);
    }

    private boolean triggerFlush() {
        return this.bufferedDocs.size() >= (long)this.chunkSize || this.numBufferedDocs >= this.maxDocsPerChunk;
    }

    private void flush(boolean force) throws IOException {
        assert (this.triggerFlush() != force);
        ++this.numChunks;
        if (force) {
            ++this.numDirtyChunks;
            this.numDirtyDocs += (long)this.numBufferedDocs;
        }
        this.indexWriter.writeIndex(this.numBufferedDocs, this.fieldsStream.getFilePointer());
        int[] lengths = this.endOffsets;
        for (int i = this.numBufferedDocs - 1; i > 0; --i) {
            lengths[i] = this.endOffsets[i] - this.endOffsets[i - 1];
            assert (lengths[i] >= 0);
        }
        boolean sliced = this.bufferedDocs.size() >= 2L * (long)this.chunkSize;
        boolean dirtyChunk = force;
        this.writeHeader(this.docBase, this.numBufferedDocs, this.numStoredFields, lengths, sliced, dirtyChunk);
        ByteBuffersDataInput bytebuffers = this.bufferedDocs.toDataInput();
        if (sliced) {
            int capacity = (int)bytebuffers.size();
            for (int compressed = 0; compressed < capacity; compressed += this.chunkSize) {
                int l = Math.min(this.chunkSize, capacity - compressed);
                ByteBuffersDataInput bbdi = bytebuffers.slice(compressed, l);
                this.compressor.compress(bbdi, this.fieldsStream);
            }
        } else {
            this.compressor.compress(bytebuffers, this.fieldsStream);
        }
        this.docBase += this.numBufferedDocs;
        this.numBufferedDocs = 0;
        this.bufferedDocs.reset();
    }

    @Override
    public void writeField(FieldInfo info, int value) throws IOException {
        ++this.numStoredFieldsInDoc;
        long infoAndBits = (long)info.number << TYPE_BITS | 2L;
        this.bufferedDocs.writeVLong(infoAndBits);
        this.bufferedDocs.writeZInt(value);
    }

    @Override
    public void writeField(FieldInfo info, long value) throws IOException {
        ++this.numStoredFieldsInDoc;
        long infoAndBits = (long)info.number << TYPE_BITS | 4L;
        this.bufferedDocs.writeVLong(infoAndBits);
        Lucene90CompressingStoredFieldsWriter.writeTLong(this.bufferedDocs, value);
    }

    @Override
    public void writeField(FieldInfo info, float value) throws IOException {
        ++this.numStoredFieldsInDoc;
        long infoAndBits = (long)info.number << TYPE_BITS | 3L;
        this.bufferedDocs.writeVLong(infoAndBits);
        Lucene90CompressingStoredFieldsWriter.writeZFloat(this.bufferedDocs, value);
    }

    @Override
    public void writeField(FieldInfo info, double value) throws IOException {
        ++this.numStoredFieldsInDoc;
        long infoAndBits = (long)info.number << TYPE_BITS | 5L;
        this.bufferedDocs.writeVLong(infoAndBits);
        Lucene90CompressingStoredFieldsWriter.writeZDouble(this.bufferedDocs, value);
    }

    @Override
    public void writeField(FieldInfo info, BytesRef value) throws IOException {
        ++this.numStoredFieldsInDoc;
        long infoAndBits = (long)info.number << TYPE_BITS | 1L;
        this.bufferedDocs.writeVLong(infoAndBits);
        this.bufferedDocs.writeVInt(value.length);
        this.bufferedDocs.writeBytes(value.bytes, value.offset, value.length);
    }

    @Override
    public void writeField(FieldInfo info, DataInput value, int length) throws IOException {
        ++this.numStoredFieldsInDoc;
        long infoAndBits = (long)info.number << TYPE_BITS | 1L;
        this.bufferedDocs.writeVLong(infoAndBits);
        this.bufferedDocs.writeVInt(length);
        this.bufferedDocs.copyBytes(value, length);
    }

    @Override
    public void writeField(FieldInfo info, String value) throws IOException {
        ++this.numStoredFieldsInDoc;
        long infoAndBits = (long)info.number << TYPE_BITS | 0L;
        this.bufferedDocs.writeVLong(infoAndBits);
        this.bufferedDocs.writeString(value);
    }

    static void writeZFloat(DataOutput out, float f) throws IOException {
        int intVal = (int)f;
        int floatBits = Float.floatToIntBits(f);
        if (f == (float)intVal && intVal >= -1 && intVal <= 125 && floatBits != NEGATIVE_ZERO_FLOAT) {
            out.writeByte((byte)(0x80 | 1 + intVal));
        } else if (floatBits >>> 31 == 0) {
            out.writeByte((byte)(floatBits >> 24));
            out.writeShort((short)(floatBits >>> 8));
            out.writeByte((byte)floatBits);
        } else {
            out.writeByte((byte)-1);
            out.writeInt(floatBits);
        }
    }

    static void writeZDouble(DataOutput out, double d) throws IOException {
        int intVal = (int)d;
        long doubleBits = Double.doubleToLongBits(d);
        if (d == (double)intVal && intVal >= -1 && intVal <= 124 && doubleBits != NEGATIVE_ZERO_DOUBLE) {
            out.writeByte((byte)(0x80 | intVal + 1));
            return;
        }
        if (d == (double)((float)d)) {
            out.writeByte((byte)-2);
            out.writeInt(Float.floatToIntBits((float)d));
        } else if (doubleBits >>> 63 == 0L) {
            out.writeByte((byte)(doubleBits >> 56));
            out.writeInt((int)(doubleBits >>> 24));
            out.writeShort((short)(doubleBits >>> 8));
            out.writeByte((byte)doubleBits);
        } else {
            out.writeByte((byte)-1);
            out.writeLong(doubleBits);
        }
    }

    static void writeTLong(DataOutput out, long l) throws IOException {
        int header;
        if (l % 1000L != 0L) {
            header = 0;
        } else if (l % 86400000L == 0L) {
            header = 192;
            l /= 86400000L;
        } else if (l % 3600000L == 0L) {
            header = 128;
            l /= 3600000L;
        } else {
            header = 64;
            l /= 1000L;
        }
        long zigZagL = BitUtil.zigZagEncode(l);
        header = (int)((long)header | zigZagL & 0x1FL);
        long upperBits = zigZagL >>> 5;
        if (upperBits != 0L) {
            header |= 0x20;
        }
        out.writeByte((byte)header);
        if (upperBits != 0L) {
            out.writeVLong(upperBits);
        }
    }

    @Override
    public void finish(int numDocs) throws IOException {
        if (this.numBufferedDocs > 0) {
            this.flush(true);
        } else assert (this.bufferedDocs.size() == 0L);
        if (this.docBase != numDocs) {
            throw new RuntimeException("Wrote " + this.docBase + " docs, finish called with numDocs=" + numDocs);
        }
        this.indexWriter.finish(numDocs, this.fieldsStream.getFilePointer(), this.metaStream);
        this.metaStream.writeVLong(this.numChunks);
        this.metaStream.writeVLong(this.numDirtyChunks);
        this.metaStream.writeVLong(this.numDirtyDocs);
        CodecUtil.writeFooter(this.metaStream);
        CodecUtil.writeFooter(this.fieldsStream);
        assert (this.bufferedDocs.size() == 0L);
    }

    private void copyOneDoc(Lucene90CompressingStoredFieldsReader reader, int docID) throws IOException {
        assert (reader.getVersion() == 1);
        Lucene90CompressingStoredFieldsReader.SerializedDocument doc = reader.serializedDocument(docID);
        this.startDocument();
        this.bufferedDocs.copyBytes(doc.in, doc.length);
        this.numStoredFieldsInDoc = doc.numStoredFields;
        this.finishDocument();
    }

    private void copyChunks(MergeState mergeState, CompressingStoredFieldsMergeSub sub, int fromDocID, int toDocID) throws IOException {
        long toPointer;
        Lucene90CompressingStoredFieldsReader reader = (Lucene90CompressingStoredFieldsReader)mergeState.storedFieldsReaders[sub.readerIndex];
        assert (reader.getVersion() == 1);
        assert (reader.getChunkSize() == this.chunkSize);
        assert (reader.getCompressionMode() == this.compressionMode);
        assert (!this.tooDirty(reader));
        assert (mergeState.liveDocs[sub.readerIndex] == null);
        int docID = fromDocID;
        FieldsIndex index = reader.getIndexReader();
        while (docID < toDocID && reader.isLoaded(docID)) {
            this.copyOneDoc(reader, docID++);
        }
        if (docID >= toDocID) {
            return;
        }
        long fromPointer = index.getStartPointer(docID);
        long l = toPointer = toDocID == sub.maxDoc ? reader.getMaxPointer() : index.getStartPointer(toDocID);
        if (fromPointer < toPointer) {
            long endChunkPointer;
            if (this.numBufferedDocs > 0) {
                this.flush(true);
            }
            IndexInput rawDocs = reader.getFieldsStream();
            rawDocs.seek(fromPointer);
            do {
                boolean dirtyChunk;
                int base = rawDocs.readVInt();
                int code = rawDocs.readVInt();
                int bufferedDocs = code >>> 2;
                if (base != docID) {
                    throw new CorruptIndexException("invalid state: base=" + base + ", docID=" + docID, rawDocs);
                }
                this.indexWriter.writeIndex(bufferedDocs, this.fieldsStream.getFilePointer());
                this.fieldsStream.writeVInt(this.docBase);
                this.fieldsStream.writeVInt(code);
                this.docBase += bufferedDocs;
                if ((docID += bufferedDocs) > toDocID) {
                    throw new CorruptIndexException("invalid state: base=" + base + ", count=" + bufferedDocs + ", toDocID=" + toDocID, rawDocs);
                }
                endChunkPointer = docID == sub.maxDoc ? reader.getMaxPointer() : index.getStartPointer(docID);
                this.fieldsStream.copyBytes(rawDocs, endChunkPointer - rawDocs.getFilePointer());
                ++this.numChunks;
                boolean bl = dirtyChunk = (code & 2) != 0;
                if (!dirtyChunk) continue;
                assert (bufferedDocs < this.maxDocsPerChunk);
                ++this.numDirtyChunks;
                this.numDirtyDocs += (long)bufferedDocs;
            } while ((fromPointer = endChunkPointer) < toPointer);
        }
        assert (!reader.isLoaded(docID));
        while (docID < toDocID) {
            this.copyOneDoc(reader, docID++);
        }
    }

    @Override
    public int merge(MergeState mergeState) throws IOException {
        MatchingReaders matchingReaders = new MatchingReaders(mergeState);
        StoredFieldsWriter.MergeVisitor[] visitors = new StoredFieldsWriter.MergeVisitor[mergeState.storedFieldsReaders.length];
        ArrayList<CompressingStoredFieldsMergeSub> subs = new ArrayList<CompressingStoredFieldsMergeSub>(mergeState.storedFieldsReaders.length);
        for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
            StoredFieldsReader reader = mergeState.storedFieldsReaders[i];
            reader.checkIntegrity();
            MergeStrategy mergeStrategy = this.getMergeStrategy(mergeState, matchingReaders, i);
            if (mergeStrategy == MergeStrategy.VISITOR) {
                visitors[i] = new StoredFieldsWriter.MergeVisitor(mergeState, i);
            }
            subs.add(new CompressingStoredFieldsMergeSub(mergeState, mergeStrategy, i));
        }
        int docCount = 0;
        DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
        CompressingStoredFieldsMergeSub sub = (CompressingStoredFieldsMergeSub)docIDMerger.next();
        while (sub != null) {
            assert (sub.mappedDocID == docCount) : sub.mappedDocID + " != " + docCount;
            StoredFieldsReader reader = mergeState.storedFieldsReaders[sub.readerIndex];
            if (sub.mergeStrategy == MergeStrategy.BULK) {
                int fromDocID;
                int toDocID = fromDocID = sub.docID;
                CompressingStoredFieldsMergeSub current = sub;
                while ((sub = (CompressingStoredFieldsMergeSub)docIDMerger.next()) == current) {
                    assert (sub.docID == ++toDocID);
                }
                this.copyChunks(mergeState, current, fromDocID, ++toDocID);
                docCount += toDocID - fromDocID;
                continue;
            }
            if (sub.mergeStrategy == MergeStrategy.DOC) {
                this.copyOneDoc((Lucene90CompressingStoredFieldsReader)reader, sub.docID);
                ++docCount;
                sub = (CompressingStoredFieldsMergeSub)docIDMerger.next();
                continue;
            }
            if (sub.mergeStrategy == MergeStrategy.VISITOR) {
                assert (visitors[sub.readerIndex] != null);
                this.startDocument();
                reader.document(sub.docID, visitors[sub.readerIndex]);
                this.finishDocument();
                ++docCount;
                sub = (CompressingStoredFieldsMergeSub)docIDMerger.next();
                continue;
            }
            throw new AssertionError((Object)("Unknown merge strategy [" + String.valueOf((Object)sub.mergeStrategy) + "]"));
        }
        this.finish(docCount);
        return docCount;
    }

    boolean tooDirty(Lucene90CompressingStoredFieldsReader candidate) {
        return candidate.getNumDirtyDocs() > (long)this.maxDocsPerChunk && candidate.getNumDirtyChunks() * 100L > candidate.getNumChunks();
    }

    private MergeStrategy getMergeStrategy(MergeState mergeState, MatchingReaders matchingReaders, int readerIndex) {
        StoredFieldsReader candidate = mergeState.storedFieldsReaders[readerIndex];
        if (!matchingReaders.matchingReaders[readerIndex] || !(candidate instanceof Lucene90CompressingStoredFieldsReader) || ((Lucene90CompressingStoredFieldsReader)candidate).getVersion() != 1) {
            return MergeStrategy.VISITOR;
        }
        Lucene90CompressingStoredFieldsReader reader = (Lucene90CompressingStoredFieldsReader)candidate;
        if (BULK_MERGE_ENABLED && reader.getCompressionMode() == this.compressionMode && reader.getChunkSize() == this.chunkSize && mergeState.liveDocs[readerIndex] == null && !this.tooDirty(reader)) {
            return MergeStrategy.BULK;
        }
        return MergeStrategy.DOC;
    }

    @Override
    public long ramBytesUsed() {
        return this.bufferedDocs.ramBytesUsed() + (long)this.numStoredFields.length * 4L + (long)this.endOffsets.length * 4L;
    }

    static {
        boolean v = true;
        try {
            v = Boolean.parseBoolean(System.getProperty(BULK_MERGE_ENABLED_SYSPROP, "true"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        BULK_MERGE_ENABLED = v;
    }

    private static class CompressingStoredFieldsMergeSub
    extends DocIDMerger.Sub {
        private final int readerIndex;
        private final int maxDoc;
        private final MergeStrategy mergeStrategy;
        int docID = -1;

        CompressingStoredFieldsMergeSub(MergeState mergeState, MergeStrategy mergeStrategy, int readerIndex) {
            super(mergeState.docMaps[readerIndex]);
            this.readerIndex = readerIndex;
            this.mergeStrategy = mergeStrategy;
            this.maxDoc = mergeState.maxDocs[readerIndex];
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }

    private static enum MergeStrategy {
        BULK,
        DOC,
        VISITOR;

    }
}

