/*
 * Decompiled with CFR 0.152.
 */
package upickle.core;

import java.io.Serializable;
import scala.runtime.ModuleSerializationProxy;
import upickle.core.Abort;
import upickle.core.CharBuilder;
import upickle.core.RenderUtils$;

public final class CharUtils$
implements Serializable {
    public static final CharUtils$ MODULE$ = new CharUtils$();

    private CharUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CharUtils$.class);
    }

    public boolean appendEscapedChar(CharBuilder charBuilder, char c, int i) {
        char c2 = c;
        switch (c2) {
            case '\"': {
                this.escapeSingleChar(charBuilder, i, '\"');
                return true;
            }
            case '\\': {
                this.escapeSingleChar(charBuilder, i, '\\');
                return true;
            }
            case '\b': {
                this.escapeSingleChar(charBuilder, i, 'b');
                return true;
            }
            case '\f': {
                this.escapeSingleChar(charBuilder, i, 'f');
                return true;
            }
            case '\n': {
                this.escapeSingleChar(charBuilder, i, 'n');
                return true;
            }
            case '\r': {
                this.escapeSingleChar(charBuilder, i, 'r');
                return true;
            }
            case '\t': {
                this.escapeSingleChar(charBuilder, i, 't');
                return true;
            }
        }
        return false;
    }

    public void escapeSingleChar(CharBuilder charBuilder, int i, char c) {
        charBuilder.ensureLength(2);
        int length = charBuilder.length();
        char[] arr = charBuilder.arr();
        arr[length] = 92;
        arr[length + 1] = c;
        charBuilder.length_$eq(charBuilder.length() + 2);
    }

    public void escapeSingleCharUnicodeEscape(CharBuilder charBuilder, int i, char c) {
        charBuilder.ensureLength(6);
        char[] arr = charBuilder.arr();
        int length = charBuilder.length();
        arr[length] = 92;
        arr[length + 1] = 117;
        arr[length + 2] = RenderUtils$.MODULE$.toHex(c >> 12 & 0xF);
        arr[length + 3] = RenderUtils$.MODULE$.toHex(c >> 8 & 0xF);
        arr[length + 4] = RenderUtils$.MODULE$.toHex(c >> 4 & 0xF);
        arr[length + 5] = RenderUtils$.MODULE$.toHex(c & 0xF);
        charBuilder.length_$eq(charBuilder.length() + 6);
    }

    public int appendSimpleStringSection(CharBuilder charBuilder, int i0, int len, CharSequence s) {
        charBuilder.ensureLength(len - i0);
        int i = this.appendSimpleStringSection0(charBuilder.arr(), charBuilder.length(), i0, len, s);
        charBuilder.length_$eq(charBuilder.length() + (i - i0) + 1);
        return i;
    }

    public int appendSimpleStringSectionNoUnicode(CharBuilder charBuilder, int i0, int len, CharSequence s) {
        charBuilder.ensureLength(len - i0);
        int i = this.appendSimpleStringSectionNoUnicode0(charBuilder.arr(), charBuilder.length(), i0, len, s);
        charBuilder.length_$eq(charBuilder.length() + (i - i0) + 1);
        return i;
    }

    private int appendSimpleStringSection0(char[] arr, int arrOffset, int i0, int len, CharSequence s) {
        int i = i0;
        while (true) {
            if (i >= len) {
                if (false) continue;
                break;
            }
            char c2 = s.charAt(i);
            if (c2 < ' ' | c2 == '\"' | c2 == '\\') {
                if (false) continue;
                break;
            }
            arr[arrOffset + i - i0] = c2;
            ++i;
            if (!true) break;
        }
        return i - 1;
    }

    private int appendSimpleStringSectionNoUnicode0(char[] arr, int arrOffset, int i0, int len, CharSequence s) {
        int i = i0;
        while (true) {
            if (i >= len) {
                if (false) continue;
                break;
            }
            char c2 = s.charAt(i);
            if (c2 < ' ' || c2 > '\u007f' || c2 == '\"' || c2 == '\\') {
                if (false) continue;
                break;
            }
            arr[arrOffset + i - i0] = c2;
            ++i;
            if (!true) break;
        }
        return i - 1;
    }

    public long parseIntegralNum(char[] arr, int arrOffset, int arrLength, int decIndex, int expIndex) {
        long l;
        int expMul;
        int n;
        if (expIndex == -1) {
            n = 1;
        } else {
            int mult = 1;
            long e = this.parseLong(arr, arrOffset + expIndex + 1, arrOffset + arrLength);
            int i = 0;
            while ((long)i < e) {
                if ((long)mult >= 0xCCCCCCCCCCCCCCCL) {
                    throw new Abort("expected integer");
                }
                mult *= 10;
                ++i;
            }
            n = expMul = mult;
        }
        int end = decIndex != -1 ? decIndex : (expIndex != -1 ? expIndex : arrLength);
        long intPortion = this.parseLong(arr, arrOffset, arrOffset + end) * (long)expMul;
        if (decIndex == -1) {
            l = 0L;
        } else {
            int end2 = expIndex != -1 ? expIndex : arrLength;
            long value = this.parseLong(arr, arrOffset + decIndex + 1, arrOffset + end2) * (long)expMul;
            for (int i = end2 - (decIndex + 1); i > 0; --i) {
                value /= 10L;
            }
            l = arr[arrOffset] == '-' ? -value : value;
        }
        long decPortion = l;
        return intPortion + decPortion;
    }

    public long parseLong(char[] cs0, int start0, int end0) {
        int size;
        if ((start0 | end0 | end0 - start0 | cs0.length - end0) < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cs = new char[end0 - start0];
        System.arraycopy(cs0, start0, cs, 0, end0 - start0);
        long inverseSum = 0L;
        long inverseSign = -1L;
        int i = 0;
        int end = end0 - start0;
        if (cs[0] == '-') {
            inverseSign = 1L;
            ++i;
        }
        if ((size = end - i) <= 0 || size > 19) {
            throw new NumberFormatException(new String(cs));
        }
        while (i < end) {
            int digit = cs[i] - 48;
            if (digit < 0 || 9 < digit) {
                throw new NumberFormatException(new String(cs));
            }
            inverseSum = inverseSum * 10L - (long)digit;
            ++i;
        }
        if (size == 19 && (inverseSum >= 0L || inverseSum == Long.MIN_VALUE && inverseSign < 0L)) {
            throw new NumberFormatException(new String(cs));
        }
        return inverseSum * inverseSign;
    }
}

