/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;

public class MultiDocValues {
    private MultiDocValues() {
    }

    public static NumericDocValues getNormValues(IndexReader r, final String field2) throws IOException {
        final List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getNormValues(field2);
        }
        boolean normFound = false;
        for (LeafReaderContext leaf : leaves) {
            LeafReader reader = leaf.reader();
            FieldInfo info = reader.getFieldInfos().fieldInfo(field2);
            if (info == null || !info.hasNorms()) continue;
            normFound = true;
            break;
        }
        if (!normFound) {
            return null;
        }
        return new NumericDocValues(){
            private int nextLeaf;
            private NumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID = -1;

            @Override
            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = (LeafReaderContext)leaves.get(this.nextLeaf);
                        this.currentValues = this.currentLeaf.reader().getNormValues(field2);
                        ++this.nextLeaf;
                        continue;
                    }
                    newDocID = this.currentValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int targetDocID) throws IOException {
                int newDocID;
                if (targetDocID <= this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getNormValues(field2);
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                    this.nextLeaf = readerIndex + 1;
                }
                if ((newDocID = this.currentValues.advance(targetDocID - this.currentLeaf.docBase)) == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public boolean advanceExact(int targetDocID) throws IOException {
                if (targetDocID < this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        throw new IllegalArgumentException("Out of range: " + targetDocID);
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getNormValues(field2);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                return this.currentValues.advanceExact(targetDocID - this.currentLeaf.docBase);
            }

            @Override
            public long longValue() throws IOException {
                return this.currentValues.longValue();
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }

    public static NumericDocValues getNumericValues(IndexReader r, final String field2) throws IOException {
        final List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getNumericDocValues(field2);
        }
        boolean anyReal = false;
        for (LeafReaderContext leaf : leaves) {
            DocValuesType dvType;
            FieldInfo fieldInfo = leaf.reader().getFieldInfos().fieldInfo(field2);
            if (fieldInfo == null || (dvType = fieldInfo.getDocValuesType()) != DocValuesType.NUMERIC) continue;
            anyReal = true;
            break;
        }
        if (!anyReal) {
            return null;
        }
        return new NumericDocValues(){
            private int nextLeaf;
            private NumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID = -1;

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = (LeafReaderContext)leaves.get(this.nextLeaf);
                        this.currentValues = this.currentLeaf.reader().getNumericDocValues(field2);
                        ++this.nextLeaf;
                        continue;
                    }
                    newDocID = this.currentValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public int advance(int targetDocID) throws IOException {
                int newDocID;
                if (targetDocID <= this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getNumericDocValues(field2);
                    this.nextLeaf = readerIndex + 1;
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                }
                if ((newDocID = this.currentValues.advance(targetDocID - this.currentLeaf.docBase)) == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public boolean advanceExact(int targetDocID) throws IOException {
                if (targetDocID < this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        throw new IllegalArgumentException("Out of range: " + targetDocID);
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getNumericDocValues(field2);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                return this.currentValues.advanceExact(targetDocID - this.currentLeaf.docBase);
            }

            @Override
            public long longValue() throws IOException {
                return this.currentValues.longValue();
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }

    public static BinaryDocValues getBinaryValues(IndexReader r, final String field2) throws IOException {
        final List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getBinaryDocValues(field2);
        }
        boolean anyReal = false;
        for (LeafReaderContext leaf : leaves) {
            DocValuesType dvType;
            FieldInfo fieldInfo = leaf.reader().getFieldInfos().fieldInfo(field2);
            if (fieldInfo == null || (dvType = fieldInfo.getDocValuesType()) != DocValuesType.BINARY) continue;
            anyReal = true;
            break;
        }
        if (!anyReal) {
            return null;
        }
        return new BinaryDocValues(){
            private int nextLeaf;
            private BinaryDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID = -1;

            @Override
            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = (LeafReaderContext)leaves.get(this.nextLeaf);
                        this.currentValues = this.currentLeaf.reader().getBinaryDocValues(field2);
                        ++this.nextLeaf;
                        continue;
                    }
                    newDocID = this.currentValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int targetDocID) throws IOException {
                int newDocID;
                if (targetDocID <= this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getBinaryDocValues(field2);
                    this.nextLeaf = readerIndex + 1;
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                }
                if ((newDocID = this.currentValues.advance(targetDocID - this.currentLeaf.docBase)) == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public boolean advanceExact(int targetDocID) throws IOException {
                if (targetDocID < this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        throw new IllegalArgumentException("Out of range: " + targetDocID);
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = this.currentLeaf.reader().getBinaryDocValues(field2);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                return this.currentValues.advanceExact(targetDocID - this.currentLeaf.docBase);
            }

            @Override
            public BytesRef binaryValue() throws IOException {
                return this.currentValues.binaryValue();
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }

    public static SortedNumericDocValues getSortedNumericValues(IndexReader r, String field2) throws IOException {
        final List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedNumericDocValues(field2);
        }
        boolean anyReal = false;
        final SortedNumericDocValues[] values = new SortedNumericDocValues[size];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedNumericDocValues v = context.reader().getSortedNumericDocValues(field2);
            if (v == null) {
                v = DocValues.emptySortedNumeric();
            } else {
                anyReal = true;
            }
            values[i] = v;
            totalCost += v.cost();
        }
        if (!anyReal) {
            return null;
        }
        final long finalTotalCost = totalCost;
        return new SortedNumericDocValues(){
            private int nextLeaf;
            private SortedNumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID = -1;

            @Override
            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = (LeafReaderContext)leaves.get(this.nextLeaf);
                        this.currentValues = values[this.nextLeaf];
                        ++this.nextLeaf;
                    }
                    if ((newDocID = this.currentValues.nextDoc()) != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int targetDocID) throws IOException {
                int newDocID;
                if (targetDocID <= this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = values[readerIndex];
                    this.nextLeaf = readerIndex + 1;
                }
                if ((newDocID = this.currentValues.advance(targetDocID - this.currentLeaf.docBase)) == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                this.docID = this.currentLeaf.docBase + newDocID;
                return this.docID;
            }

            @Override
            public boolean advanceExact(int targetDocID) throws IOException {
                if (targetDocID < this.docID) {
                    throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
                }
                int readerIndex = ReaderUtil.subIndex(targetDocID, leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == leaves.size()) {
                        throw new IllegalArgumentException("Out of range: " + targetDocID);
                    }
                    this.currentLeaf = (LeafReaderContext)leaves.get(readerIndex);
                    this.currentValues = values[readerIndex];
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                return this.currentValues.advanceExact(targetDocID - this.currentLeaf.docBase);
            }

            @Override
            public long cost() {
                return finalTotalCost;
            }

            @Override
            public int docValueCount() {
                return this.currentValues.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                return this.currentValues.nextValue();
            }
        };
    }

    public static SortedDocValues getSortedValues(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedDocValues(field2);
        }
        boolean anyReal = false;
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedDocValues v = context.reader().getSortedDocValues(field2);
            if (v == null) {
                v = DocValues.emptySorted();
            } else {
                anyReal = true;
                totalCost += v.cost();
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        IndexReader.CacheHelper cacheHelper = r.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper == null ? null : cacheHelper.getKey();
        OrdinalMap mapping = OrdinalMap.build(owner, values, 0.25f);
        return new MultiSortedDocValues(values, starts, mapping, totalCost);
    }

    public static SortedSetDocValues getSortedSetValues(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedSetDocValues(field2);
        }
        boolean anyReal = false;
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedSetDocValues v = context.reader().getSortedSetDocValues(field2);
            if (v == null) {
                v = DocValues.emptySortedSet();
            } else {
                anyReal = true;
                totalCost += v.cost();
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        IndexReader.CacheHelper cacheHelper = r.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper == null ? null : cacheHelper.getKey();
        OrdinalMap mapping = OrdinalMap.build(owner, values, 0.25f);
        return new MultiSortedSetDocValues(values, starts, mapping, totalCost);
    }

    public static class MultiSortedSetDocValues
    extends SortedSetDocValues {
        public final int[] docStarts;
        public final SortedSetDocValues[] values;
        public final OrdinalMap mapping;
        private final long totalCost;
        private int nextLeaf;
        private SortedSetDocValues currentValues;
        private int currentDocStart;
        private int docID = -1;

        public MultiSortedSetDocValues(SortedSetDocValues[] values, int[] docStarts, OrdinalMap mapping, long totalCost) {
            assert (docStarts.length == values.length + 1);
            this.values = values;
            this.docStarts = docStarts;
            this.mapping = mapping;
            this.totalCost = totalCost;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            int newDocID;
            while (true) {
                if (this.currentValues == null) {
                    if (this.nextLeaf == this.values.length) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentDocStart = this.docStarts[this.nextLeaf];
                    this.currentValues = this.values[this.nextLeaf];
                    ++this.nextLeaf;
                    continue;
                }
                newDocID = this.currentValues.nextDoc();
                if (newDocID != Integer.MAX_VALUE) break;
                this.currentValues = null;
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public int advance(int targetDocID) throws IOException {
            int newDocID;
            if (targetDocID <= this.docID) {
                throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
            }
            int readerIndex = ReaderUtil.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    this.currentValues = null;
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            if ((newDocID = this.currentValues.advance(targetDocID - this.currentDocStart)) == Integer.MAX_VALUE) {
                this.currentValues = null;
                return this.nextDoc();
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public boolean advanceExact(int targetDocID) throws IOException {
            if (targetDocID < this.docID) {
                throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
            }
            int readerIndex = ReaderUtil.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    throw new IllegalArgumentException("Out of range: " + targetDocID);
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            this.docID = targetDocID;
            if (this.currentValues == null) {
                return false;
            }
            return this.currentValues.advanceExact(targetDocID - this.currentDocStart);
        }

        @Override
        public long nextOrd() throws IOException {
            long segmentOrd = this.currentValues.nextOrd();
            if (segmentOrd == -1L) {
                return segmentOrd;
            }
            return this.mapping.getGlobalOrds(this.nextLeaf - 1).get(segmentOrd);
        }

        @Override
        public int docValueCount() {
            return this.currentValues.docValueCount();
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            long segmentOrd = this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public long getValueCount() {
            return this.mapping.getValueCount();
        }

        @Override
        public long cost() {
            return this.totalCost;
        }
    }

    public static class MultiSortedDocValues
    extends SortedDocValues {
        public final int[] docStarts;
        public final SortedDocValues[] values;
        public final OrdinalMap mapping;
        private final long totalCost;
        private int nextLeaf;
        private SortedDocValues currentValues;
        private int currentDocStart;
        private int docID = -1;

        public MultiSortedDocValues(SortedDocValues[] values, int[] docStarts, OrdinalMap mapping, long totalCost) {
            assert (docStarts.length == values.length + 1);
            this.values = values;
            this.docStarts = docStarts;
            this.mapping = mapping;
            this.totalCost = totalCost;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            int newDocID;
            while (true) {
                if (this.currentValues == null) {
                    if (this.nextLeaf == this.values.length) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentDocStart = this.docStarts[this.nextLeaf];
                    this.currentValues = this.values[this.nextLeaf];
                    ++this.nextLeaf;
                    continue;
                }
                newDocID = this.currentValues.nextDoc();
                if (newDocID != Integer.MAX_VALUE) break;
                this.currentValues = null;
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public int advance(int targetDocID) throws IOException {
            int newDocID;
            if (targetDocID <= this.docID) {
                throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
            }
            int readerIndex = ReaderUtil.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    this.currentValues = null;
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            if ((newDocID = this.currentValues.advance(targetDocID - this.currentDocStart)) == Integer.MAX_VALUE) {
                this.currentValues = null;
                return this.nextDoc();
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public boolean advanceExact(int targetDocID) throws IOException {
            if (targetDocID < this.docID) {
                throw new IllegalArgumentException("can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID);
            }
            int readerIndex = ReaderUtil.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    throw new IllegalArgumentException("Out of range: " + targetDocID);
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            this.docID = targetDocID;
            if (this.currentValues == null) {
                return false;
            }
            return this.currentValues.advanceExact(targetDocID - this.currentDocStart);
        }

        @Override
        public int ordValue() throws IOException {
            return (int)this.mapping.getGlobalOrds(this.nextLeaf - 1).get(this.currentValues.ordValue());
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            int segmentOrd = (int)this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public int getValueCount() {
            return (int)this.mapping.getValueCount();
        }

        @Override
        public long cost() {
            return this.totalCost;
        }
    }
}

