/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.search.SortField;

public class IntFieldSource
extends FieldCacheSource {
    public IntFieldSource(String field2) {
        super(field2);
    }

    @Override
    public String description() {
        return "int(" + this.field + ")";
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortField(this.field, SortField.Type.INT, reverse);
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = this.getNumericDocValues(context, readerContext);
        return new IntDocValues(this){
            int lastDocID;

            @Override
            public int intVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    return (int)arr.longValue();
                }
                return 0;
            }

            @Override
            public String strVal(int doc) throws IOException {
                return Integer.toString(this.intVal(doc));
            }

            @Override
            public boolean exists(int doc) throws IOException {
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                this.lastDocID = doc;
                int curDocID = arr.docID();
                if (doc > curDocID) {
                    curDocID = arr.advance(doc);
                }
                return doc == curDocID;
            }
        };
    }

    protected NumericDocValues getNumericDocValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        return DocValues.getNumeric(readerContext.reader(), this.field);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != IntFieldSource.class) {
            return false;
        }
        IntFieldSource other = (IntFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = Integer.class.hashCode();
        return h += super.hashCode();
    }
}

