/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.AbstractVectorSimilarityQuery;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.VectorSimilarityCollector;
import org.apache.lucene.util.Bits;

public class ByteVectorSimilarityQuery
extends AbstractVectorSimilarityQuery {
    private final byte[] target;

    public ByteVectorSimilarityQuery(String field2, byte[] target, float traversalSimilarity, float resultSimilarity, Query filter) {
        super(field2, traversalSimilarity, resultSimilarity, filter);
        this.target = Objects.requireNonNull(target, "target");
    }

    public ByteVectorSimilarityQuery(String field2, byte[] target, float traversalSimilarity, float resultSimilarity) {
        this(field2, target, traversalSimilarity, resultSimilarity, null);
    }

    public ByteVectorSimilarityQuery(String field2, byte[] target, float resultSimilarity, Query filter) {
        this(field2, target, resultSimilarity, resultSimilarity, filter);
    }

    public ByteVectorSimilarityQuery(String field2, byte[] target, float resultSimilarity) {
        this(field2, target, resultSimilarity, resultSimilarity, null);
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context) throws IOException {
        FieldInfo fi = context.reader().getFieldInfos().fieldInfo(this.field);
        if (fi == null || fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return null;
        }
        return VectorScorer.create(context, fi, this.target);
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitLimit) throws IOException {
        VectorSimilarityCollector collector = new VectorSimilarityCollector(this.traversalSimilarity, this.resultSimilarity, visitLimit);
        context.reader().searchNearestVectors(this.field, this.target, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    @Override
    public String toString(String field2) {
        return String.format(Locale.ROOT, "%s[field=%s target=[%d...] traversalSimilarity=%f resultSimilarity=%f filter=%s]", this.getClass().getSimpleName(), field2, this.target[0], Float.valueOf(this.traversalSimilarity), Float.valueOf(this.resultSimilarity), this.filter);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && super.equals(o) && Arrays.equals(this.target, ((ByteVectorSimilarityQuery)o).target);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.target);
        return result;
    }
}

