/*
 * Decompiled with CFR 0.152.
 */
package esc.index;

import esc.commons.Constants$;
import esc.commons.FinderMatch;
import esc.commons.FinderMatch$;
import esc.commons.Match;
import esc.commons.Match$;
import esc.commons.NormalizedAddress;
import esc.commons.NormalizedDate;
import esc.commons.NormalizedName;
import esc.commons.NormalizedName$;
import esc.configuration.SimilarityConfig;
import esc.index.Finder$;
import esc.normalization.AddressNormalizer;
import esc.normalization.DateNormalizer$;
import esc.normalization.NameNormalizer;
import esc.normalization.TextNormalizer$;
import esc.similarity.NameSimilarity;
import esc.similarity.nameElementSimilarityDb$;
import esc.utils.BasicFunctions$;
import esc.utils.Countries$;
import esc.utils.Persistence$;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$DeprecatedDoubleOrdering$;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public class Finder {
    private final IndexSearcher indexSearcher;
    private final SimilarityConfig similarityConfig;
    private final NameNormalizer nameNormalizer;
    private final NameSimilarity nameSimilarity;
    private final AddressNormalizer addressNormalizer;
    private final Date loadTimestamp;

    public static SimilarityConfig $lessinit$greater$default$2() {
        return Finder$.MODULE$.$lessinit$greater$default$2();
    }

    public static List<String> $lessinit$greater$default$3() {
        return Finder$.MODULE$.$lessinit$greater$default$3();
    }

    public static List<String> $lessinit$greater$default$4() {
        return Finder$.MODULE$.$lessinit$greater$default$4();
    }

    public Finder(IndexSearcher indexSearcher, SimilarityConfig similarityConfig, List<String> adrCheckStopWords, List<String> adrCheckHitWords) {
        this.indexSearcher = indexSearcher;
        this.similarityConfig = similarityConfig;
        this.nameNormalizer = new NameNormalizer(similarityConfig);
        this.nameSimilarity = new NameSimilarity(similarityConfig);
        this.addressNormalizer = new AddressNormalizer(similarityConfig, adrCheckStopWords, adrCheckHitWords);
        this.loadTimestamp = Calendar.getInstance().getTime();
    }

    public IndexSearcher indexSearcher() {
        return this.indexSearcher;
    }

    public SimilarityConfig similarityConfig() {
        return this.similarityConfig;
    }

    public NameNormalizer nameNormalizer() {
        return this.nameNormalizer;
    }

    public NameSimilarity nameSimilarity() {
        return this.nameSimilarity;
    }

    public AddressNormalizer addressNormalizer() {
        return this.addressNormalizer;
    }

    public Date loadTimestamp() {
        return this.loadTimestamp;
    }

    public List<FinderMatch> findPerson(String fullName, List<String> datesOfBirth, List<String> countries, String label) {
        NormalizedName normName = this.nameNormalizer().normalizePersonName(fullName);
        BooleanQuery query = this.createNmQuery(normName, datesOfBirth, countries, Constants$.MODULE$.IndexPersonNameTypeCode(), label);
        return this.searchNmQuery(query, normName);
    }

    public String findPerson$default$4() {
        return "";
    }

    public List<FinderMatch> findPersonByIR(String nameQuery, List<String> datesOfBirth, List<String> countries, String label) {
        BooleanQuery query = this.createIrQuery(nameQuery, datesOfBirth, countries, Constants$.MODULE$.IndexPersonNameTypeCode(), label);
        return this.searchIrQuery(query);
    }

    public String findPersonByIR$default$4() {
        return "";
    }

    public List<FinderMatch> findOrganisation(String fullName, List<String> datesOfFounding, List<String> countries, String label) {
        NormalizedName normName = this.nameNormalizer().normalizeOrganisationName(fullName);
        BooleanQuery query = this.createNmQuery(normName, datesOfFounding, countries, Constants$.MODULE$.IndexOrganisationNameTypeCode(), label);
        return this.searchNmQuery(query, normName);
    }

    public String findOrganisation$default$4() {
        return "";
    }

    public List<FinderMatch> findOrganisationByIR(String nameQuery, List<String> datesOfFounding, List<String> countries, String label) {
        BooleanQuery query = this.createIrQuery(nameQuery, datesOfFounding, countries, Constants$.MODULE$.IndexOrganisationNameTypeCode(), label);
        return this.searchIrQuery(query);
    }

    public String findOrganisationByIR$default$4() {
        return "";
    }

    public List<FinderMatch> findByAddress(String address, String label) {
        NormalizedAddress normAddress = this.addressNormalizer().normalizeAddress(address);
        BooleanQuery query = this.createIrAddressQuery(normAddress.addressItems(), normAddress.countries(), label);
        return this.searchIrQuery(query);
    }

    public String findByAddress$default$2() {
        return "";
    }

    public Date getLoadTime() {
        return this.loadTimestamp();
    }

    public int getDocCount() {
        return this.indexSearcher().getIndexReader().numDocs();
    }

    private List<FinderMatch> searchNmQuery(BooleanQuery booleanQuery, NormalizedName normNameA) {
        TopDocs hits = this.indexSearcher().search((Query)booleanQuery, this.similarityConfig().maxNumberOfCandidatesFromSearch());
        if (hits.totalHits.value < 1L) {
            return (List)((Object)Nil$.MODULE$);
        }
        Object mutAllMatches = ListBuffer$.MODULE$.empty();
        Object object = Predef$.MODULE$.refArrayOps(hits.scoreDocs);
        ArrayOps$.MODULE$.foreach$extension(object, arg_0 -> this.searchNmQuery$$anonfun$1(normNameA, (ListBuffer)mutAllMatches, arg_0));
        ObjectRef<Object> mutListResult = ObjectRef.create(ListBuffer$.MODULE$.empty());
        ((AbstractIterable)mutAllMatches).groupBy((Function1<Tuple2, String> & Serializable)_$1 -> (String)_$1._1()).foreach((Function1<Tuple2, ListBuffer> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                ListBuffer v = (ListBuffer)tuple2._2();
                int n = this.similarityConfig().matchSelectionMode();
                if (1 == n) {
                    return (ListBuffer)((ListBuffer)mutListResult$1.elem).$plus$eq(((Tuple2)((IterableOps)((SeqOps)v.sortBy((Function1<Tuple2, int> & Serializable)_$2 -> ((FinderMatch)_$2._2()).matchResult().nofHits(), (Ordering)Ordering$Int$.MODULE$)).reverse()).head())._2());
                }
                return (ListBuffer)((ListBuffer)mutListResult$1.elem).$plus$eq(((Tuple2)((IterableOps)((SeqOps)v.sortBy((Function1<Tuple2, double> & Serializable)_$3 -> ((FinderMatch)_$3._2()).matchResult().similarity(), (Ordering)Ordering$DeprecatedDoubleOrdering$.MODULE$)).reverse()).head())._2());
            }
            throw new MatchError(tuple2);
        });
        return ((ListBuffer)mutListResult.elem).toList();
    }

    private List<FinderMatch> searchIrQuery(BooleanQuery booleanQuery) {
        TopDocs hits = this.indexSearcher().search((Query)booleanQuery, this.similarityConfig().maxNumberOfCandidatesFromSearch());
        if (hits.totalHits.value < 1L) {
            return (List)((Object)Nil$.MODULE$);
        }
        Object mutAllMatches = ListBuffer$.MODULE$.empty();
        Object object = Predef$.MODULE$.refArrayOps(hits.scoreDocs);
        ArrayOps$.MODULE$.foreach$extension(object, arg_0 -> this.searchIrQuery$$anonfun$1((ListBuffer)mutAllMatches, arg_0));
        return ((ListBuffer)mutAllMatches).toList();
    }

    private BooleanQuery createNmQuery(NormalizedName normName, List<String> dates, List<String> countries, String nameType, String label) {
        int x;
        int n;
        Serializable serializable;
        BooleanQuery.setMaxClauseCount(Integer.MAX_VALUE);
        List<String> csList = ((List)((List)countries.map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.toIsoCountry(TextNormalizer$.MODULE$.normalize((String)c));
            if (tuple2 != null) {
                boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
                String string2 = tuple2._2();
                if (bl) {
                    String x = string2;
                    return new java.lang.StringBuilder(3).append("cs:").append(x).toString();
                }
                if (!bl) {
                    String x = string2;
                    return "_";
                }
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, boolean> & Serializable)_$4 -> {
            String string2 = _$4;
            String string3 = "_";
            return string2 == null ? string3 != null : !string2.equals(string3);
        })).$colon$colon("cs:xx");
        List ysList = (List)((List)((List)dates.map((Function1<String, int> & Serializable)y -> {
            NormalizedDate nd = DateNormalizer$.MODULE$.normalizeDate((String)y);
            byte by = nd.dateType();
            if (99 == by) {
                return 9999;
            }
            return nd.year();
        })).filter(_$5 -> _$5 != 9999)).sorted((Ordering)Ordering$Int$.MODULE$);
        boolean mutWithDate = true;
        StringBuilder mutDateBuilder = new StringBuilder();
        int n2 = ysList.length();
        if (0 == n2) {
            mutWithDate = false;
            serializable = BoxedUnit.UNIT;
        } else {
            mutDateBuilder.$plus$plus$eq("((ys:[");
            mutDateBuilder.$plus$plus$eq(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(ysList.head()) - this.similarityConfig().maxDateYearDifferenceForHit()).toString());
            mutDateBuilder.$plus$plus$eq(" TO ");
            mutDateBuilder.$plus$plus$eq(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(ysList.last()) + this.similarityConfig().maxDateYearDifferenceForHit()).toString());
            serializable = mutDateBuilder.$plus$plus$eq("]) OR ys:9999)");
        }
        BooleanQuery.Builder nameQuery = new BooleanQuery.Builder();
        ObjectRef mutMinShoudMatchList = ObjectRef.create(new ListBuffer());
        normName.normNames().foreach((Function1<Vector, ListBuffer> & Serializable)variant -> {
            DoubleRef mutMinShouldMatchCounter = DoubleRef.create(0.0);
            variant.foreach((Function1<Tuple3, Object> & Serializable)element -> {
                block2: {
                    block5: {
                        Tuple2<Object, Object> tuple2;
                        block3: {
                            boolean bl;
                            block4: {
                                byte by = BoxesRunTime.unboxToByte(element._3());
                                if (1 != by) break block2;
                                tuple2 = this.nameNormalizer().persNameElementReducedWeight((String)element._1(), 1.0);
                                if (tuple2 == null) break block3;
                                bl = tuple2._2$mcZ$sp();
                                if (bl) break block4;
                                nameElementSimilarityDb$.MODULE$.getMatchList((String)element._1(), this.similarityConfig().nameElementSimilarityForHit()).foreach((Function1<String, BooleanQuery.Builder> & Serializable)s -> nameQuery.add(new TermQuery(new Term("doc", (String)s)), BooleanClause.Occur.SHOULD));
                                String string2 = Predef$.MODULE$.augmentString((String)element._1());
                                List triGList = StringOps$.MODULE$.sliding$extension(string2, 3, StringOps$.MODULE$.sliding$default$2$extension(string2)).toList();
                                triGList.foreach((Function1<String, BooleanQuery.Builder> & Serializable)s -> nameQuery.add(new TermQuery(new Term("doc", (String)s)), BooleanClause.Occur.SHOULD));
                                mutMinShouldMatchCounter$1.elem += (double)(triGList.length() / 2);
                                break block5;
                            }
                            if (bl) break block5;
                        }
                        throw new MatchError(tuple2);
                    }
                    return BoxedUnit.UNIT;
                }
                return nameQuery.add(new TermQuery(new Term("doc", (String)element._1())), BooleanClause.Occur.SHOULD);
            });
            return (ListBuffer)((ListBuffer)mutMinShoudMatchList$1.elem).$plus$eq(BoxesRunTime.boxToDouble(mutMinShouldMatchCounter.elem));
        });
        int x2 = n = (int)scala.math.package$.MODULE$.floor(BoxesRunTime.unboxToDouble(((IterableOps)((ListBuffer)mutMinShoudMatchList.elem).sorted((Ordering)Ordering$DeprecatedDoubleOrdering$.MODULE$)).head()) - 0.5);
        nameQuery.setMinimumNumberShouldMatch(x2 < 1 ? 1 : (x = n));
        BooleanQuery.Builder findQuery = new BooleanQuery.Builder();
        findQuery.add(new TermQuery(new Term("t", nameType)), BooleanClause.Occur.MUST);
        findQuery.add(nameQuery.build(), BooleanClause.Occur.MUST);
        QueryParser queryParser = new QueryParser("doc", new PerFieldAnalyzerWrapper(new WhitespaceAnalyzer()));
        if (csList.length() > 1) {
            findQuery.add(queryParser.parse(csList.mkString(" ")), BooleanClause.Occur.MUST);
        }
        if (mutWithDate) {
            findQuery.add(queryParser.parse(mutDateBuilder.toString()), BooleanClause.Occur.MUST);
        }
        if (!BasicFunctions$.MODULE$.isNullOrEmpty(label)) {
            findQuery.add(new TermQuery(new Term("l", label)), BooleanClause.Occur.MUST);
        }
        return findQuery.build();
    }

    private BooleanQuery createIrQuery(String queryString, List<String> dates, List<String> countries, String nameType, String label) {
        Serializable serializable;
        BooleanQuery.setMaxClauseCount(Integer.MAX_VALUE);
        List<String> csList = ((List)((List)countries.map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.toIsoCountry(TextNormalizer$.MODULE$.normalize((String)c));
            if (tuple2 != null) {
                boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
                String string2 = tuple2._2();
                if (bl) {
                    String x = string2;
                    return new java.lang.StringBuilder(3).append("cs:").append(x).toString();
                }
                if (!bl) {
                    String x = string2;
                    return "_";
                }
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, boolean> & Serializable)_$6 -> {
            String string2 = _$6;
            String string3 = "_";
            return string2 == null ? string3 != null : !string2.equals(string3);
        })).$colon$colon("cs:xx");
        List ysList = (List)((List)((List)dates.map((Function1<String, int> & Serializable)y -> {
            NormalizedDate nd = DateNormalizer$.MODULE$.normalizeDate((String)y);
            byte by = nd.dateType();
            if (99 == by) {
                return 9999;
            }
            return nd.year();
        })).filter(_$7 -> _$7 != 9999)).sorted((Ordering)Ordering$Int$.MODULE$);
        boolean mutWithDate = true;
        StringBuilder mutDateBuilder = new StringBuilder();
        int n = ysList.length();
        if (0 == n) {
            mutWithDate = false;
            serializable = BoxedUnit.UNIT;
        } else {
            mutDateBuilder.$plus$plus$eq("((ys:[");
            mutDateBuilder.$plus$plus$eq(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(ysList.head()) - this.similarityConfig().maxDateYearDifferenceForHit()).toString());
            mutDateBuilder.$plus$plus$eq(" TO ");
            mutDateBuilder.$plus$plus$eq(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(ysList.last()) + this.similarityConfig().maxDateYearDifferenceForHit()).toString());
            serializable = mutDateBuilder.$plus$plus$eq("]) OR ys:9999)");
        }
        SimpleQueryParser nameQuery = new SimpleQueryParser((Analyzer)new WhitespaceAnalyzer(), "ir");
        BooleanQuery.Builder findQuery = new BooleanQuery.Builder();
        findQuery.add(new TermQuery(new Term("t", nameType)), BooleanClause.Occur.MUST);
        findQuery.add(nameQuery.parse(queryString.toLowerCase()), BooleanClause.Occur.MUST);
        QueryParser queryParser = new QueryParser("doc", new PerFieldAnalyzerWrapper(new WhitespaceAnalyzer()));
        if (csList.length() > 1) {
            findQuery.add(queryParser.parse(csList.mkString(" ")), BooleanClause.Occur.MUST);
        }
        if (mutWithDate) {
            findQuery.add(queryParser.parse(mutDateBuilder.toString()), BooleanClause.Occur.MUST);
        }
        if (!BasicFunctions$.MODULE$.isNullOrEmpty(label)) {
            findQuery.add(new TermQuery(new Term("l", label)), BooleanClause.Occur.MUST);
        }
        return findQuery.build();
    }

    private BooleanQuery createIrAddressQuery(List<String> addressItems, List<String> countries, String label) {
        BooleanQuery.setMaxClauseCount(Integer.MAX_VALUE);
        List<String> csList = ((List)((List)countries.map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.toIsoCountry(TextNormalizer$.MODULE$.normalize((String)c));
            if (tuple2 != null) {
                boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
                String string2 = tuple2._2();
                if (bl) {
                    String x = string2;
                    return new java.lang.StringBuilder(3).append("cs:").append(x).toString();
                }
                if (!bl) {
                    String x = string2;
                    return "_";
                }
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, boolean> & Serializable)_$8 -> {
            String string2 = _$8;
            String string3 = "_";
            return string2 == null ? string3 != null : !string2.equals(string3);
        })).$colon$colon("cs:xx");
        QueryParser wordQuery = new QueryParser("ir", new WhitespaceAnalyzer());
        BooleanQuery.Builder addressQueryBuilder = new BooleanQuery.Builder();
        addressItems.foreach(e -> ((List)((SeqOps)((StrictOptimizedIterableOps)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)e), Nil$.MODULE$)))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)nameElementSimilarityDb$.MODULE$.getMatchList((String)e, nameElementSimilarityDb$.MODULE$.getMatchList$default$2())), Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms())).distinct()).foreach((Function1<String, BooleanQuery.Builder> & Serializable)xe -> addressQueryBuilder.add(wordQuery.parse(new java.lang.StringBuilder(1).append((String)xe).append("~").append(this.similarityConfig().fuzzyScoreForAddressSearch()).toString()), BooleanClause.Occur.SHOULD)));
        BooleanQuery addressQuery = addressQueryBuilder.setMinimumNumberShouldMatch(this.similarityConfig().numberOfHitsForAddressSearchHit()).build();
        BooleanQuery.Builder findQuery = new BooleanQuery.Builder();
        findQuery.add(addressQuery, BooleanClause.Occur.MUST);
        QueryParser queryParser = new QueryParser("doc", new PerFieldAnalyzerWrapper(new WhitespaceAnalyzer()));
        if (csList.length() > 1) {
            findQuery.add(queryParser.parse(csList.mkString(" ")), BooleanClause.Occur.MUST);
        }
        if (!BasicFunctions$.MODULE$.isNullOrEmpty(label)) {
            findQuery.add(new TermQuery(new Term("l", label)), BooleanClause.Occur.MUST);
        }
        return findQuery.build();
    }

    private final /* synthetic */ Object searchNmQuery$$anonfun$1(NormalizedName normNameA$1, ListBuffer mutAllMatches$1, ScoreDoc scoreDoc) {
        Document doc = this.indexSearcher().doc(scoreDoc.doc);
        NormalizedName normNameB = NormalizedName$.MODULE$.apply(Persistence$.MODULE$.toNormalizedNameVector(doc.get("json")), "");
        Match simMatch = this.nameSimilarity().getNameSimilarity(normNameA$1, normNameB);
        int n = this.similarityConfig().matchSelectionMode();
        if (1 == n && simMatch.nofHits() >= this.similarityConfig().numberOfHitsForSearchHit()) {
            String id = doc.get("id");
            String exid = doc.get("exid");
            String name = doc.get("name");
            FinderMatch finderMatch = FinderMatch$.MODULE$.apply(id, exid, name, simMatch);
            int n2 = this.similarityConfig().searchEntityGroupMode();
            String grpId = 1 == n2 ? id : exid;
            return mutAllMatches$1.$plus$eq(Tuple2$.MODULE$.apply(grpId, finderMatch));
        }
        if (simMatch.similarity() >= this.similarityConfig().similarityValueForSearchHit()) {
            String id = doc.get("id");
            String exid = doc.get("exid");
            String name = doc.get("name");
            FinderMatch finderMatch = FinderMatch$.MODULE$.apply(id, exid, name, simMatch);
            int n3 = this.similarityConfig().searchEntityGroupMode();
            String grpId = 1 == n3 ? id : exid;
            return mutAllMatches$1.$plus$eq(Tuple2$.MODULE$.apply(grpId, finderMatch));
        }
        return BoxedUnit.UNIT;
    }

    private final /* synthetic */ ListBuffer searchIrQuery$$anonfun$1(ListBuffer mutAllMatches$2, ScoreDoc scoreDoc) {
        Document doc = this.indexSearcher().doc(scoreDoc.doc);
        String id = doc.get("id");
        String exid = doc.get("exid");
        String name = doc.get("name");
        int n = this.similarityConfig().searchEntityGroupMode();
        String grpId = 1 == n ? id : exid;
        return (ListBuffer)mutAllMatches$2.$plus$eq(FinderMatch$.MODULE$.apply(id, exid, name, Match$.MODULE$.apply(0, 0.0, 0.0, 0.0, 0.0, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Nothing$[0])))));
    }
}

