/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.XYDocValuesPointInGeometryQuery;
import org.apache.lucene.document.XYPointSortField;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

public class XYDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public XYDocValuesField(String name, float x, float y) {
        super(name, TYPE);
        this.setLocationValue(x, y);
    }

    public void setLocationValue(float x, float y) {
        int xEncoded = XYEncodingUtils.encode(x);
        int yEncoded = XYEncodingUtils.encode(y);
        this.fieldsData = (long)xEncoded << 32 | (long)yEncoded & 0xFFFFFFFFL;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + fieldInfo.getDocValuesType() + " but this type has docValuesType=" + TYPE.docValuesType() + ", is the field really a XYDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(XYEncodingUtils.decode((int)(currentValue >> 32)));
        result.append(',');
        result.append(XYEncodingUtils.decode((int)(currentValue & 0xFFFFFFFFFFFFFFFFL)));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field2, float x, float y) {
        return new XYPointSortField(field2, x, y);
    }

    public static Query newSlowBoxQuery(String field2, float minX, float maxX, float minY, float maxY) {
        XYRectangle rectangle = new XYRectangle(minX, maxX, minY, maxY);
        return new XYDocValuesPointInGeometryQuery(field2, rectangle);
    }

    public static Query newSlowDistanceQuery(String field2, float x, float y, float radius) {
        XYCircle circle = new XYCircle(x, y, radius);
        return new XYDocValuesPointInGeometryQuery(field2, circle);
    }

    public static Query newSlowPolygonQuery(String field2, XYPolygon ... polygons) {
        return XYDocValuesField.newSlowGeometryQuery(field2, polygons);
    }

    public static Query newSlowGeometryQuery(String field2, XYGeometry ... geometries) {
        return new XYDocValuesPointInGeometryQuery(field2, geometries);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

