/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;

public abstract class MultiRangeQuery
extends Query
implements Cloneable {
    final String field;
    final int numDims;
    final int bytesPerDim;
    List<RangeClause> rangeClauses;

    protected MultiRangeQuery(String field2, int numDims, int bytesPerDim, List<RangeClause> rangeClauses) {
        this.field = field2;
        this.numDims = numDims;
        this.bytesPerDim = bytesPerDim;
        this.rangeClauses = rangeClauses;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.numDims != 1) {
            return this;
        }
        List<RangeClause> mergedRanges = MultiRangeQuery.mergeOverlappingRanges(this.rangeClauses, this.bytesPerDim);
        if (mergedRanges != this.rangeClauses) {
            try {
                MultiRangeQuery clone = (MultiRangeQuery)super.clone();
                clone.rangeClauses = mergedRanges;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this;
    }

    static List<RangeClause> mergeOverlappingRanges(List<RangeClause> rangeClauses, int bytesPerDim) {
        if (rangeClauses.size() <= 1) {
            return rangeClauses;
        }
        ArrayList<RangeClause> originRangeClause = new ArrayList<RangeClause>(rangeClauses);
        final ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(bytesPerDim);
        originRangeClause.sort(new Comparator<RangeClause>(){

            @Override
            public int compare(RangeClause o1, RangeClause o2) {
                int result = comparator.compare(o1.lowerValue, 0, o2.lowerValue, 0);
                if (result == 0) {
                    return comparator.compare(o1.upperValue, 0, o2.upperValue, 0);
                }
                return result;
            }
        });
        ArrayList<RangeClause> finalRangeClause = new ArrayList<RangeClause>();
        RangeClause current = (RangeClause)originRangeClause.get(0);
        for (int i = 1; i < originRangeClause.size(); ++i) {
            RangeClause nextClause = (RangeClause)originRangeClause.get(i);
            if (comparator.compare(nextClause.lowerValue, 0, current.upperValue, 0) > 0) {
                finalRangeClause.add(current);
                current = nextClause;
                continue;
            }
            if (comparator.compare(nextClause.upperValue, 0, current.upperValue, 0) <= 0) continue;
            current = new RangeClause(current.lowerValue, nextClause.upperValue);
        }
        finalRangeClause.add(current);
        if (finalRangeClause.size() != rangeClauses.size()) {
            return finalRangeClause;
        }
        return rangeClauses;
    }

    @Override
    public final Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(this.bytesPerDim);
        return new ConstantScoreWeight(this, boost){

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result, final Relatable range) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator) throws IOException {
                        this.adder.add(iterator);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (range.matches(packedValue)) {
                            this.adder.add(docID);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return range.relate(minPackedValue, maxPackedValue);
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                byte[] fieldPackedUpper;
                byte[] fieldPackedLower;
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(MultiRangeQuery.this.field);
                if (values == null) {
                    return null;
                }
                if (values.getNumIndexDimensions() != MultiRangeQuery.this.numDims) {
                    throw new IllegalArgumentException("field=\"" + MultiRangeQuery.this.field + "\" was indexed with numIndexDimensions=" + values.getNumIndexDimensions() + " but this query has numDims=" + MultiRangeQuery.this.numDims);
                }
                if (MultiRangeQuery.this.bytesPerDim != values.getBytesPerDimension()) {
                    throw new IllegalArgumentException("field=\"" + MultiRangeQuery.this.field + "\" was indexed with bytesPerDim=" + values.getBytesPerDimension() + " but this query has bytesPerDim=" + MultiRangeQuery.this.bytesPerDim);
                }
                final Relatable range = MultiRangeQuery.this.rangeClauses.size() == 1 ? MultiRangeQuery.getRange(MultiRangeQuery.this.rangeClauses.get(0), MultiRangeQuery.this.numDims, MultiRangeQuery.this.bytesPerDim, comparator) : MultiRangeQuery.createTree(MultiRangeQuery.this.rangeClauses, MultiRangeQuery.this.numDims, MultiRangeQuery.this.bytesPerDim, comparator);
                boolean allDocsMatch = values.getDocCount() == reader.maxDoc() ? range.relate(fieldPackedLower = values.getMinPackedValue(), fieldPackedUpper = values.getMaxPackedValue()) == PointValues.Relation.CELL_INSIDE_QUERY : false;
                final 2 weight = this;
                if (allDocsMatch) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.all(reader.maxDoc()));
                        }

                        @Override
                        public long cost() {
                            return reader.maxDoc();
                        }
                    };
                }
                return new ScorerSupplier(){
                    final DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    long cost;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, MultiRangeQuery.this.field);
                        this.visitor = this.getIntersectVisitor(this.result, range);
                        this.cost = -1L;
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        values.intersect(this.visitor);
                        DocIdSetIterator iterator = this.result.build().iterator();
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor) * (long)MultiRangeQuery.this.rangeClauses.size();
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public int count(LeafReaderContext context) throws IOException {
                if (MultiRangeQuery.this.numDims != 1 || context.reader().hasDeletions()) {
                    return super.count(context);
                }
                PointValues pointValues = context.reader().getPointValues(MultiRangeQuery.this.field);
                if (pointValues == null || pointValues.size() != (long)pointValues.getDocCount()) {
                    return super.count(context);
                }
                int total = 0;
                for (RangeClause rangeClause : MultiRangeQuery.this.rangeClauses) {
                    PointRangeQuery pointRangeQuery = new PointRangeQuery(MultiRangeQuery.this.field, rangeClause.lowerValue, rangeClause.upperValue, MultiRangeQuery.this.numDims){

                        @Override
                        protected String toString(int dimension, byte[] value) {
                            return MultiRangeQuery.this.toString(dimension, value);
                        }
                    };
                    int count = pointRangeQuery.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, 1.0f).count(context);
                    if (count != -1) {
                        total += count;
                        continue;
                    }
                    return super.count(context);
                }
                return total;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int getBytesPerDim() {
        return this.bytesPerDim;
    }

    @Override
    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.rangeClauses.hashCode();
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + Objects.hashCode(this.bytesPerDim);
        return hash;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((MultiRangeQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(MultiRangeQuery other) {
        return Objects.equals(this.field, other.field) && this.numDims == other.numDims && this.bytesPerDim == other.bytesPerDim && this.rangeClauses.equals(other.rangeClauses);
    }

    @Override
    public final String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field2)) {
            sb.append(this.field);
            sb.append(':');
        }
        int count = 0;
        for (RangeClause rangeClause : this.rangeClauses) {
            if (count > 0) {
                sb.append(',');
            }
            sb.append('{');
            for (int i = 0; i < this.numDims; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                int startOffset = this.bytesPerDim * i;
                sb.append('[');
                sb.append(this.toString(i, ArrayUtil.copyOfSubArray(rangeClause.lowerValue, startOffset, startOffset + this.bytesPerDim)));
                sb.append(" TO ");
                sb.append(this.toString(i, ArrayUtil.copyOfSubArray(rangeClause.upperValue, startOffset, startOffset + this.bytesPerDim)));
                sb.append(']');
            }
            sb.append('}');
            ++count;
        }
        return sb.toString();
    }

    protected abstract String toString(int var1, byte[] var2);

    static RangeTree createTree(List<RangeClause> clauses, int numIndexDim, int bytesPerDim, ArrayUtil.ByteArrayComparator comparator) {
        Range[] ranges = new Range[clauses.size()];
        for (int i = 0; i < clauses.size(); ++i) {
            ranges[i] = MultiRangeQuery.getRange(clauses.get(i), numIndexDim, bytesPerDim, comparator);
        }
        return MultiRangeQuery.createTree(ranges, 0, ranges.length - 1, 0, numIndexDim, bytesPerDim, comparator);
    }

    private static RangeTree createTree(Range[] components, int low, int high, int split, int numIndexDim, int bytesPerDim, ArrayUtil.ByteArrayComparator comparator) {
        int offset;
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            int offset2 = split * bytesPerDim;
            Comparator comp = (left, right) -> {
                int ret = comparator.compare(left.getMinPackedValue(), offset2, right.getMinPackedValue(), offset2);
                if (ret == 0) {
                    ret = comparator.compare(left.getMaxPackedValue(), offset2, right.getMaxPackedValue(), offset2);
                }
                return ret;
            };
            ArrayUtil.select(components, low, high + 1, mid, comp);
        }
        RangeTree newNode = new RangeTree(components[mid], split, comparator, numIndexDim, bytesPerDim);
        if (++split == numIndexDim) {
            split = 0;
        }
        newNode.left = MultiRangeQuery.createTree(components, low, mid - 1, split, numIndexDim, bytesPerDim, comparator);
        newNode.right = MultiRangeQuery.createTree(components, mid + 1, high, split, numIndexDim, bytesPerDim, comparator);
        if (newNode.left != null) {
            for (int i = 0; i < numIndexDim; ++i) {
                offset = i * bytesPerDim;
                if (comparator.compare(newNode.maxPackedValue, offset, newNode.left.maxPackedValue, offset) >= 0) continue;
                System.arraycopy(newNode.left.maxPackedValue, offset, newNode.maxPackedValue, offset, bytesPerDim);
            }
        }
        if (newNode.right != null) {
            for (int i = 0; i < numIndexDim; ++i) {
                offset = i * bytesPerDim;
                if (comparator.compare(newNode.maxPackedValue, offset, newNode.right.maxPackedValue, offset) >= 0) continue;
                System.arraycopy(newNode.right.maxPackedValue, offset, newNode.maxPackedValue, offset, bytesPerDim);
            }
        }
        return newNode;
    }

    private static Range getRange(final RangeClause clause, final int numIndexDim, final int bytesPerDim, final ArrayUtil.ByteArrayComparator comparator) {
        return new Range(){

            @Override
            public byte[] getMinPackedValue() {
                return clause.lowerValue;
            }

            @Override
            public byte[] getMaxPackedValue() {
                return clause.upperValue;
            }

            @Override
            public boolean matches(byte[] packedValue) {
                for (int dim = 0; dim < numIndexDim; ++dim) {
                    int offset = dim * bytesPerDim;
                    if (comparator.compare(packedValue, offset, clause.lowerValue, offset) < 0) {
                        return false;
                    }
                    if (comparator.compare(packedValue, offset, clause.upperValue, offset) <= 0) continue;
                    return false;
                }
                return true;
            }

            @Override
            public PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                boolean crosses = false;
                for (int dim = 0; dim < numIndexDim; ++dim) {
                    int offset = dim * bytesPerDim;
                    if (comparator.compare(minPackedValue, offset, clause.upperValue, offset) > 0 || comparator.compare(maxPackedValue, offset, clause.lowerValue, offset) < 0) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    crosses |= comparator.compare(minPackedValue, offset, clause.lowerValue, offset) < 0 || comparator.compare(maxPackedValue, offset, clause.upperValue, offset) > 0;
                }
                if (crosses) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
        };
    }

    private static class RangeTree
    implements Relatable {
        private final byte[] maxPackedValue;
        private RangeTree left;
        private RangeTree right;
        private final int split;
        private final Range component;
        private final ArrayUtil.ByteArrayComparator comparator;
        private final int numIndexDim;
        private final int bytesPerDim;

        private RangeTree(Range component, int split, ArrayUtil.ByteArrayComparator comparator, int numIndexDim, int bytesPerDim) {
            this.maxPackedValue = (byte[])component.getMaxPackedValue().clone();
            this.component = component;
            this.split = split;
            this.comparator = comparator;
            this.numIndexDim = numIndexDim;
            this.bytesPerDim = bytesPerDim;
        }

        @Override
        public boolean matches(byte[] packedValue) {
            boolean valid = true;
            for (int i = 0; i < this.numIndexDim; ++i) {
                int offset = this.bytesPerDim * i;
                if (this.comparator.compare(packedValue, offset, this.maxPackedValue, offset) <= 0) continue;
                valid = false;
                break;
            }
            if (valid) {
                if (this.component.matches(packedValue)) {
                    return true;
                }
                if (this.left != null && this.left.matches(packedValue)) {
                    return true;
                }
                if (this.right != null && this.comparator.compare(packedValue, this.split * this.bytesPerDim, this.component.getMinPackedValue(), this.split * this.bytesPerDim) >= 0 && this.right.matches(packedValue)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
            boolean valid = true;
            for (int i = 0; i < this.numIndexDim; ++i) {
                int offset = this.bytesPerDim * i;
                if (this.comparator.compare(minPackedValue, offset, this.maxPackedValue, offset) <= 0) continue;
                valid = false;
                break;
            }
            if (valid) {
                PointValues.Relation relation = this.component.relate(minPackedValue, maxPackedValue);
                if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return relation;
                }
                if (this.left != null && (relation = this.left.relate(minPackedValue, maxPackedValue)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return relation;
                }
                if (this.right != null && this.comparator.compare(maxPackedValue, this.split * this.bytesPerDim, this.component.getMinPackedValue(), this.split * this.bytesPerDim) >= 0 && (relation = this.right.relate(minPackedValue, maxPackedValue)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return relation;
                }
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    private static interface Range
    extends Relatable {
        public byte[] getMinPackedValue();

        public byte[] getMaxPackedValue();
    }

    private static interface Relatable {
        public boolean matches(byte[] var1);

        public PointValues.Relation relate(byte[] var1, byte[] var2);
    }

    public static abstract class Builder {
        protected final String field;
        protected final int bytesPerDim;
        protected final int numDims;
        protected final List<RangeClause> clauses = new ArrayList<RangeClause>();

        public Builder(String field2, int bytesPerDim, int numDims) {
            if (field2 == null) {
                throw new IllegalArgumentException("field should not be null");
            }
            if (bytesPerDim <= 0) {
                throw new IllegalArgumentException("bytesPerDim should be a valid value");
            }
            if (numDims <= 0) {
                throw new IllegalArgumentException("numDims should be a valid value");
            }
            this.field = field2;
            this.bytesPerDim = bytesPerDim;
            this.numDims = numDims;
        }

        public Builder add(RangeClause clause) {
            this.clauses.add(clause);
            return this;
        }

        public Builder add(byte[] lowerValue, byte[] upperValue) {
            this.checkArgs(lowerValue, upperValue);
            return this.add(new RangeClause(lowerValue, upperValue));
        }

        public abstract MultiRangeQuery build();

        private void checkArgs(Object lowerPoint, Object upperPoint) {
            if (lowerPoint == null) {
                throw new IllegalArgumentException("lowerPoint must not be null");
            }
            if (upperPoint == null) {
                throw new IllegalArgumentException("upperPoint must not be null");
            }
        }
    }

    public static final class RangeClause {
        byte[] lowerValue;
        byte[] upperValue;

        public RangeClause(byte[] lowerValue, byte[] upperValue) {
            this.lowerValue = lowerValue;
            this.upperValue = upperValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangeClause that = (RangeClause)o;
            return Arrays.equals(this.lowerValue, that.lowerValue) && Arrays.equals(this.upperValue, that.upperValue);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.lowerValue);
            result = 31 * result + Arrays.hashCode(this.upperValue);
            return result;
        }
    }
}

