/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.AbstractKnnVectorQuery;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;

public class KnnByteVectorQuery
extends AbstractKnnVectorQuery {
    private static final TopDocs NO_RESULTS = TopDocsCollector.EMPTY_TOPDOCS;
    private final byte[] target;

    public KnnByteVectorQuery(String field2, byte[] target, int k) {
        this(field2, target, k, null);
    }

    public KnnByteVectorQuery(String field2, byte[] target, int k, Query filter) {
        super(field2, k, filter);
        this.target = Objects.requireNonNull(target, "target");
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        KnnCollector knnCollector = knnCollectorManager.newCollector(visitedLimit, context);
        FieldInfo fi = context.reader().getFieldInfos().fieldInfo(this.field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        if (Math.min(knnCollector.k(), context.reader().getByteVectorValues(fi.name).size()) == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        context.reader().searchNearestVectors(this.field, this.target, knnCollector, acceptDocs);
        TopDocs results = knnCollector.topDocs();
        return results != null ? results : NO_RESULTS;
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context, FieldInfo fi) throws IOException {
        if (fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return null;
        }
        return VectorScorer.create(context, fi, this.target);
    }

    @Override
    public String toString(String field2) {
        return this.getClass().getSimpleName() + ":" + this.field + "[" + this.target[0] + ",...][" + this.k + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnnByteVectorQuery that = (KnnByteVectorQuery)o;
        return Arrays.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.target));
    }

    public byte[] getTargetCopy() {
        return ArrayUtil.copyOfSubArray(this.target, 0, this.target.length);
    }
}

