/*
 * Decompiled with CFR 0.152.
 */
package upickle.core;

import java.io.Serializable;
import scala.Function1;
import upickle.core.ArrVisitor;
import upickle.core.ObjVisitor;

public interface Visitor<T, J> {
    public ArrVisitor<T, J> visitArray(int var1, int var2);

    public ObjVisitor<T, J> visitObject(int var1, boolean var2, int var3);

    public J visitNull(int var1);

    public J visitFalse(int var1);

    public J visitTrue(int var1);

    public J visitFloat64StringParts(CharSequence var1, int var2, int var3, int var4);

    public static Object visitFloat64ByteParts$(Visitor $this, byte[] s, int arrOffset, int arrLength, int decIndex, int expIndex, int index) {
        return $this.visitFloat64ByteParts(s, arrOffset, arrLength, decIndex, expIndex, index);
    }

    default public J visitFloat64ByteParts(byte[] s, int arrOffset, int arrLength, int decIndex, int expIndex, int index) {
        return this.visitFloat64StringParts(new String(s, arrOffset, arrLength), decIndex, expIndex, index);
    }

    public static Object visitFloat64CharParts$(Visitor $this, char[] s, int arrOffset, int arrLength, int decIndex, int expIndex, int index) {
        return $this.visitFloat64CharParts(s, arrOffset, arrLength, decIndex, expIndex, index);
    }

    default public J visitFloat64CharParts(char[] s, int arrOffset, int arrLength, int decIndex, int expIndex, int index) {
        return this.visitFloat64StringParts(new String(s, arrOffset, arrLength), decIndex, expIndex, index);
    }

    public J visitFloat64(double var1, int var3);

    public J visitFloat32(float var1, int var2);

    public J visitInt32(int var1, int var2);

    public J visitInt64(long var1, int var3);

    public J visitUInt64(long var1, int var3);

    public J visitFloat64String(String var1, int var2);

    public J visitString(CharSequence var1, int var2);

    public J visitChar(char var1, int var2);

    public J visitBinary(byte[] var1, int var2, int var3, int var4);

    public J visitExt(byte var1, byte[] var2, int var3, int var4, int var5);

    public static Visitor map$(Visitor $this, Function1 f) {
        return $this.map(f);
    }

    default public <Z> Visitor<T, Z> map(Function1<J, Z> f) {
        return new MapReader<T, J, Z>(f, this){
            private final Function1 f$1;
            {
                this.f$1 = f$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer);
            }

            public Object mapNonNullsFunction(Object v) {
                return this.f$1.apply(v);
            }
        };
    }

    public static Visitor mapNulls$(Visitor $this, Function1 f) {
        return $this.mapNulls(f);
    }

    default public <Z> Visitor<T, Z> mapNulls(Function1<J, Z> f) {
        return new MapReader<T, J, Z>(f, this){
            private final Function1 f$2;
            {
                this.f$2 = f$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer);
            }

            public Object mapFunction(Object v) {
                return this.f$2.apply(v);
            }

            public Object mapNonNullsFunction(Object v) {
                return this.f$2.apply(v);
            }
        };
    }

    public static class Delegate<T, V>
    implements Visitor<T, V> {
        private final Visitor<T, V> delegatedReader;

        public Delegate(Visitor<T, V> delegatedReader) {
            this.delegatedReader = delegatedReader;
        }

        @Override
        public V visitNull(int index) {
            return this.delegatedReader.visitNull(index);
        }

        @Override
        public V visitTrue(int index) {
            return this.delegatedReader.visitTrue(index);
        }

        @Override
        public V visitFalse(int index) {
            return this.delegatedReader.visitFalse(index);
        }

        @Override
        public V visitString(CharSequence s, int index) {
            return this.delegatedReader.visitString(s, index);
        }

        @Override
        public V visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
            return this.delegatedReader.visitFloat64StringParts(s, decIndex, expIndex, index);
        }

        @Override
        public V visitFloat64(double d, int index) {
            return this.delegatedReader.visitFloat64(d, index);
        }

        @Override
        public ObjVisitor<T, V> visitObject(int length, boolean jsonableKeys, int index) {
            return this.delegatedReader.visitObject(length, jsonableKeys, index);
        }

        @Override
        public ArrVisitor<T, V> visitArray(int length, int index) {
            return this.delegatedReader.visitArray(length, index);
        }

        @Override
        public V visitFloat32(float d, int index) {
            return this.delegatedReader.visitFloat32(d, index);
        }

        @Override
        public V visitInt32(int i, int index) {
            return this.delegatedReader.visitInt32(i, index);
        }

        @Override
        public V visitInt64(long i, int index) {
            return this.delegatedReader.visitInt64(i, index);
        }

        @Override
        public V visitUInt64(long i, int index) {
            return this.delegatedReader.visitUInt64(i, index);
        }

        @Override
        public V visitFloat64String(String s, int index) {
            return this.delegatedReader.visitFloat64String(s, index);
        }

        @Override
        public V visitChar(char s, int index) {
            return this.delegatedReader.visitChar(s, index);
        }

        @Override
        public V visitBinary(byte[] bytes, int offset, int len, int index) {
            return this.delegatedReader.visitBinary(bytes, offset, len, index);
        }

        @Override
        public V visitExt(byte tag, byte[] bytes, int offset, int len, int index) {
            return this.delegatedReader.visitExt(tag, bytes, offset, len, index);
        }
    }

    public static class MapArrContext<T, V, Z>
    implements ArrVisitor<T, Z> {
        private final ArrVisitor<T, V> src;
        private final Function1<V, Z> f;

        public MapArrContext(ArrVisitor<T, V> src, Function1<V, Z> f) {
            this.src = src;
            this.f = f;
        }

        @Override
        public Visitor<?, ?> subVisitor() {
            return this.src.subVisitor();
        }

        @Override
        public void visitValue(T v, int index) {
            this.src.visitValue(v, index);
        }

        @Override
        public Z visitEnd(int index) {
            return this.f.apply(this.src.visitEnd(index));
        }
    }

    public static class MapObjContext<T, V, Z>
    implements ObjVisitor<T, Z> {
        private final ObjVisitor<T, V> src;
        private final Function1<V, Z> f;

        public MapObjContext(ObjVisitor<T, V> src, Function1<V, Z> f) {
            this.src = src;
            this.f = f;
        }

        @Override
        public Visitor<?, ?> subVisitor() {
            return this.src.subVisitor();
        }

        @Override
        public Visitor<?, ?> visitKey(int index) {
            return this.src.visitKey(index);
        }

        @Override
        public void visitKeyValue(Object s) {
            this.src.visitKeyValue(s);
        }

        @Override
        public void visitValue(T v, int index) {
            this.src.visitValue(v, index);
        }

        @Override
        public Z visitEnd(int index) {
            return this.f.apply(this.src.visitEnd(index));
        }
    }

    public static abstract class MapReader<T, V, Z>
    implements Visitor<T, Z> {
        private final Visitor<T, V> delegatedReader;

        public MapReader(Visitor<T, V> delegatedReader) {
            this.delegatedReader = delegatedReader;
        }

        public abstract Z mapNonNullsFunction(V var1);

        public Z mapFunction(V v) {
            if (v == null) {
                return null;
            }
            return this.mapNonNullsFunction(v);
        }

        @Override
        public Z visitFalse(int index) {
            return this.mapFunction(this.delegatedReader.visitFalse(index));
        }

        @Override
        public Z visitNull(int index) {
            return this.mapFunction(this.delegatedReader.visitNull(index));
        }

        @Override
        public Z visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
            return this.mapFunction(this.delegatedReader.visitFloat64StringParts(s, decIndex, expIndex, index));
        }

        @Override
        public Z visitFloat64(double d, int index) {
            return this.mapFunction(this.delegatedReader.visitFloat64(d, index));
        }

        @Override
        public Z visitString(CharSequence s, int index) {
            return this.mapFunction(this.delegatedReader.visitString(s, index));
        }

        @Override
        public Z visitTrue(int index) {
            return this.mapFunction(this.delegatedReader.visitTrue(index));
        }

        @Override
        public ObjVisitor<T, Z> visitObject(int length, boolean jsonableKeys, int index) {
            return new MapObjContext(this.delegatedReader.visitObject(length, jsonableKeys, index), (Function1<Object, Object> & Serializable)t -> this.mapNonNullsFunction(t));
        }

        @Override
        public ArrVisitor<T, Z> visitArray(int length, int index) {
            return new MapArrContext(this.delegatedReader.visitArray(length, index), (Function1<Object, Object> & Serializable)t -> this.mapNonNullsFunction(t));
        }

        @Override
        public Z visitFloat32(float d, int index) {
            return this.mapFunction(this.delegatedReader.visitFloat32(d, index));
        }

        @Override
        public Z visitInt32(int i, int index) {
            return this.mapFunction(this.delegatedReader.visitInt32(i, index));
        }

        @Override
        public Z visitInt64(long i, int index) {
            return this.mapFunction(this.delegatedReader.visitInt64(i, index));
        }

        @Override
        public Z visitUInt64(long i, int index) {
            return this.mapFunction(this.delegatedReader.visitUInt64(i, index));
        }

        @Override
        public Z visitFloat64String(String s, int index) {
            return this.mapFunction(this.delegatedReader.visitFloat64String(s, index));
        }

        @Override
        public Z visitChar(char s, int index) {
            return this.mapFunction(this.delegatedReader.visitChar(s, index));
        }

        @Override
        public Z visitBinary(byte[] bytes, int offset, int len, int index) {
            return this.mapFunction(this.delegatedReader.visitBinary(bytes, offset, len, index));
        }

        @Override
        public Z visitExt(byte tag, byte[] bytes, int offset, int len, int index) {
            return this.mapFunction(this.delegatedReader.visitExt(tag, bytes, offset, len, index));
        }
    }
}

