/*
 * Decompiled with CFR 0.152.
 */
package esc.normalization;

import esc.commons.NormalizedName;
import esc.commons.NormalizedName$;
import esc.configuration.SimilarityConfig;
import esc.normalization.NameNormalizer$;
import esc.normalization.TextNormalizer$;
import esc.utils.Countries$;
import esc.utils.LegalForm$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class NameNormalizer {
    private final SimilarityConfig similarityConfig;

    public static SimilarityConfig $lessinit$greater$default$1() {
        return NameNormalizer$.MODULE$.$lessinit$greater$default$1();
    }

    public NameNormalizer(SimilarityConfig similarityConfig) {
        this.similarityConfig = similarityConfig;
    }

    public SimilarityConfig similarityConfig() {
        return this.similarityConfig;
    }

    public NormalizedName normalizePersonName(String fullName) {
        Object object;
        int n;
        Predef$.MODULE$.require(fullName.length() > 1);
        Object mutWhitespaceVariations = ArrayBuffer$.MODULE$.empty();
        Object object2 = Predef$.MODULE$.refArrayOps(TextNormalizer$.MODULE$.normalize(fullName).split(" "));
        Vector<String> whitespaceSplit = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1<String, String> & Serializable)e -> TextNormalizer$.MODULE$.normalizeNameElement((String)e), ClassTag$.MODULE$.apply(String.class))).toVector();
        int x = n = whitespaceSplit.length();
        if (x > 2) {
            this.buildWhitespaceVariations(whitespaceSplit, (ArrayBuffer<ArrayBuffer<String>>)mutWhitespaceVariations, 0, whitespaceSplit.length());
            object = BoxedUnit.UNIT;
        } else {
            object = ((AbstractBuffer)mutWhitespaceVariations).$plus$eq(whitespaceSplit.to(IterableFactory$.MODULE$.toFactory(ArrayBuffer$.MODULE$)));
        }
        Vector whitespaceVariations = ((IterableOnceOps)((ArrayBuffer)mutWhitespaceVariations).map((Function1<ArrayBuffer, Vector> & Serializable)_$1 -> _$1.toVector())).toVector();
        Object mutNameElementCombinations = ArrayBuffer$.MODULE$.empty();
        whitespaceVariations.foreach(arg_0 -> this.normalizePersonName$$anonfun$1((ArrayBuffer)mutNameElementCombinations, arg_0));
        Vector<Vector<Tuple3<String, Object, Object>>> nameElementCombinations = ((IterableOnceOps)((ArrayBuffer)mutNameElementCombinations).map((Function1<ArrayBuffer, Vector> & Serializable)_$2 -> _$2.toVector())).toVector();
        return NormalizedName$.MODULE$.apply(nameElementCombinations, fullName);
    }

    public NormalizedName normalizeOrganisationName(String fullName) {
        Object object;
        int n;
        Predef$.MODULE$.require(fullName.length() > 1);
        Object mutWhitespaceVariations = ArrayBuffer$.MODULE$.empty();
        Object object2 = Predef$.MODULE$.refArrayOps(TextNormalizer$.MODULE$.normalizeWithLegalForm(fullName).split(" "));
        Vector<String> whitespaceSplit = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1<String, String> & Serializable)e -> TextNormalizer$.MODULE$.normalizeNameElement((String)e), ClassTag$.MODULE$.apply(String.class))).toVector();
        int x = n = whitespaceSplit.length();
        if (x > 2) {
            this.buildWhitespaceVariations(whitespaceSplit, (ArrayBuffer<ArrayBuffer<String>>)mutWhitespaceVariations, 0, whitespaceSplit.length());
            object = BoxedUnit.UNIT;
        } else {
            object = ((AbstractBuffer)mutWhitespaceVariations).$plus$eq(whitespaceSplit.to(IterableFactory$.MODULE$.toFactory(ArrayBuffer$.MODULE$)));
        }
        Vector whitespaceVariations = ((IterableOnceOps)((ArrayBuffer)mutWhitespaceVariations).map((Function1<ArrayBuffer, Vector> & Serializable)_$3 -> _$3.toVector())).toVector();
        Object mutNameElementCombinations = ArrayBuffer$.MODULE$.empty();
        whitespaceVariations.foreach(arg_0 -> this.normalizeOrganisationName$$anonfun$1((ArrayBuffer)mutNameElementCombinations, arg_0));
        Vector<Vector<Tuple3<String, Object, Object>>> nameElementCombinations = ((IterableOnceOps)((ArrayBuffer)mutNameElementCombinations).map((Function1<ArrayBuffer, Vector> & Serializable)_$4 -> _$4.toVector())).toVector();
        return NormalizedName$.MODULE$.apply(nameElementCombinations, fullName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tuple2<Object, Object> persNameElementReducedWeight(String nameElement, double initialWeight) {
        boolean isReduced;
        double reducedWeight;
        block29: {
            reducedWeight = 1.0;
            isReduced = false;
            String string2 = nameElement;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -823769586: {
                    if (!"vander".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case -810840292: {
                    if (!"vonder".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3115: {
                    if (!"al".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3121: {
                    if (!"ar".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3197: {
                    if (!"da".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3201: {
                    if (!"de".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3205: {
                    if (!"di".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3214: {
                    if (!"dr".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3239: {
                    if (!"el".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3899: {
                    if (!"zu".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 96355: {
                    if (!"abd".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 97543: {
                    if (!"bin".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 99339: {
                    if (!"del".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 99345: {
                    if (!"der".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 99656: {
                    if (!"dos".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 116515: {
                    if (!"van".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 116949: {
                    if (!"von".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 120983: {
                    if (!"zur".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 3449689: {
                    if (!"prof".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 92600394: {
                    if (!"abdel".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 92600890: {
                    if (!"abdul".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 111974116: {
                    if (!"vande".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
                case 112391190: {
                    if (!"vonde".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    isReduced = true;
                    break block29;
                }
            }
            int n = nameElement.length();
            if (1 == n) {
                if (this.similarityConfig().allowOneLetterAbbreviation()) {
                    reducedWeight = initialWeight - this.similarityConfig().oneLetterAbbreviationWeight();
                }
                isReduced = true;
            } else {
                reducedWeight = initialWeight;
            }
        }
        if (reducedWeight < 0.0) {
            reducedWeight = 0.0;
        }
        return Tuple2$.MODULE$.apply(BoxesRunTime.boxToDouble(reducedWeight), BoxesRunTime.boxToBoolean(isReduced));
    }

    private void buildWhitespaceVariations(Vector<String> whitespaceSplit, ArrayBuffer<ArrayBuffer<String>> mutWhitespaceCombinations, int counter, int length) {
        while (true) {
            Object whitespaceCombination = ArrayBuffer$.MODULE$.empty();
            BooleanRef scip = BooleanRef.create(false);
            ((Vector)whitespaceSplit.zipWithIndex()).foreach(arg_0 -> this.buildWhitespaceVariations$$anonfun$1(counter, length, whitespaceSplit, scip, (ArrayBuffer)whitespaceCombination, arg_0));
            if (!scip.elem) {
                mutWhitespaceCombinations.$plus$eq((ArrayBuffer<String>)whitespaceCombination);
            }
            if (counter + 1 >= length) break;
            ++counter;
        }
    }

    private void buildPersonNameElementCombinations(Vector<String> whitespaceVariations, ArrayBuffer<ArrayBuffer<Tuple3<String, Object, Object>>> mutNameElementCombinations) {
        Object mutNameElementVariationsList = ListBuffer$.MODULE$.empty();
        whitespaceVariations.foreach(arg_0 -> this.buildPersonNameElementCombinations$$anonfun$1((ListBuffer)mutNameElementVariationsList, arg_0));
        List nameElementVariationsList = ((ListBuffer)((ListBuffer)mutNameElementVariationsList).map((Function1<ListBuffer, List> & Serializable)_$5 -> _$5.toList())).toList();
        List nameElementCombinationsList = this.combineSubLists(nameElementVariationsList);
        nameElementCombinationsList.foreach((Function1<List, ArrayBuffer> & Serializable)cl -> {
            Object mutNameElement = ArrayBuffer$.MODULE$.empty();
            cl.foreach(arg_0 -> this.buildPersonNameElementCombinations$$anonfun$2$$anonfun$1((ArrayBuffer)mutNameElement, arg_0));
            return (ArrayBuffer)mutNameElementCombinations.$plus$eq((ArrayBuffer<Tuple3<String, Object, Object>>)mutNameElement);
        });
    }

    private void buildOrganisationNameElementCombinations(Vector<String> whitespaceVariations, ArrayBuffer<ArrayBuffer<Tuple3<String, Object, Object>>> mutNameElementCombinations) {
        Object mutNameElementVariationsList = ListBuffer$.MODULE$.empty();
        whitespaceVariations.foreach(arg_0 -> this.buildOrganisationNameElementCombinations$$anonfun$1((ListBuffer)mutNameElementVariationsList, arg_0));
        List nameElementVariationsList = ((ListBuffer)((ListBuffer)mutNameElementVariationsList).map((Function1<ListBuffer, List> & Serializable)_$6 -> _$6.toList())).toList();
        List nameElementCombinationsList = this.combineSubLists(nameElementVariationsList);
        nameElementCombinationsList.foreach((Function1<List, ArrayBuffer> & Serializable)cl -> {
            Object mutNameElement = ArrayBuffer$.MODULE$.empty();
            cl.foreach(arg_0 -> this.buildOrganisationNameElementCombinations$$anonfun$2$$anonfun$1((ArrayBuffer)mutNameElement, arg_0));
            return (ArrayBuffer)mutNameElementCombinations.$plus$eq((ArrayBuffer<Tuple3<String, Object, Object>>)mutNameElement);
        });
    }

    private <T> List<List<T>> combineSubLists(List<List<T>> list) {
        List<List<T>> list2 = list;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<List<T>> list3 = list2;
        if (!(nil$ != null ? !((Object)nil$).equals(list3) : list3 != null)) {
            return package$.MODULE$.Nil().$colon$colon(package$.MODULE$.Nil());
        }
        if (list2 instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list2;
            List<List<T>> list4 = $colon$colon.next();
            List head = (List)$colon$colon.head();
            List<List<T>> tail = list4;
            List<List<T>> rec = this.combineSubLists(tail);
            return rec.flatMap((Function1<List, IterableOnce> & Serializable)r -> head.map((Function1<Object, List> & Serializable)t -> r.$colon$colon(t)));
        }
        throw new MatchError(list2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private double firstNameElementReducedWeight(String nameElement, double initialWeight) {
        double reducedWeight;
        block19: {
            reducedWeight = 1.0;
            String string2 = nameElement;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1357935714: {
                    if (!"claude".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case -988410599: {
                    if (!"pierre".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case -896664208: {
                    if (!"sophie".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 96737: {
                    if (!"ann".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 108101: {
                    if (!"mia".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 2998944: {
                    if (!"anna".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 2998948: {
                    if (!"anne".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 3046168: {
                    if (!"carl".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 3195006: {
                    if (!"hans".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 3258024: {
                    if (!"jean".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 3284496: {
                    if (!"karl".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 3721355: {
                    if (!"yves".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 102131023: {
                    if (!"klara".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 103666426: {
                    if (!"marie".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 106557964: {
                    if (!"peter".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 109613090: {
                    if (!"sofia".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
                case 109613094: {
                    if (!"sofie".equals(string2)) break;
                    reducedWeight = initialWeight - 0.4;
                    break block19;
                }
            }
            reducedWeight = this.persNameElementReducedWeight(nameElement, initialWeight)._1$mcD$sp();
        }
        if (!(reducedWeight < 0.0)) return reducedWeight;
        return 0.0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private double orgNameElementReducedWeight(String nameElement, double initialWeight) {
        double reducedWeight;
        block50: {
            reducedWeight = 1.0;
            String string2 = nameElement;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1799980989: {
                    if (!"management".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1364013995: {
                    if (!"center".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1274450430: {
                    if (!"finanz".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1250853950: {
                    if (!"umgebung".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1237460538: {
                    if (!"groupe".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1237286597: {
                    if (!"gruppe".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1149751464: {
                    if (!"assoziation".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1074038704: {
                    if (!"mining".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1067367135: {
                    if (!"trading".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -1019789636: {
                    if (!"office".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -979976414: {
                    if (!"privat".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -912358499: {
                    if (!"gruendung".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -878854963: {
                    if (!"sammelstiftung".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -853258278: {
                    if (!"finance".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -681180629: {
                    if (!"finanzen".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -658897101: {
                    if (!"personalvorsorgestiftung".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -314497661: {
                    if (!"private".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -224813765: {
                    if (!"development".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case -166722442: {
                    if (!"consulting".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 3201: {
                    if (!"de".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    break block50;
                }
                case 3365: {
                    if (!"in".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    break block50;
                }
                case 96586: {
                    if (!"air".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 101577: {
                    if (!"for".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    break block50;
                }
                case 114801: {
                    if (!"the".equals(string2)) break;
                    reducedWeight = initialWeight - 0.8;
                    break block50;
                }
                case 3016252: {
                    if (!"bank".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 3056822: {
                    if (!"club".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 3295150: {
                    if (!"klub".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 73049818: {
                    if (!"insurance".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 93121264: {
                    if (!"asset".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 98629247: {
                    if (!"group".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 110640728: {
                    if (!"trust".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 671335630: {
                    if (!"grundung".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 724284659: {
                    if (!"immobilien".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 902347594: {
                    if (!"commercial".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 949122880: {
                    if (!"security".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 978518234: {
                    if (!"organisation".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 1091761859: {
                    if (!"holding".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 1178922291: {
                    if (!"organization".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 1364817721: {
                    if (!"liquidation".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 1379209310: {
                    if (!"services".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 1401531677: {
                    if (!"treuhand".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 1574008798: {
                    if (!"securities".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 1966091395: {
                    if (!"versicherung".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 1984153269: {
                    if (!"service".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
                case 2064805518: {
                    if (!"international".equals(string2)) break;
                    reducedWeight = initialWeight - 0.5;
                    break block50;
                }
            }
            int n = nameElement.length();
            if (1 == n) {
                if (this.similarityConfig().allowOneLetterAbbreviation()) {
                    reducedWeight = initialWeight - this.similarityConfig().oneLetterAbbreviationWeight();
                }
            } else {
                reducedWeight = initialWeight;
            }
        }
        if (!(reducedWeight < 0.0)) return reducedWeight;
        return 0.0;
    }

    private Tuple3<Object, Object, String> getOrgNameElementTypeWeightNorm(String nameElement, double initWeight) {
        Tuple2<Object, String> tuple2 = LegalForm$.MODULE$.toDeLegalForm(nameElement);
        if (tuple2 != null) {
            String string2 = tuple2._2();
            if (BoxesRunTime.unboxToBoolean(tuple2._1()) && string2 != null) {
                String x = string2;
                return Tuple3$.MODULE$.apply(BoxesRunTime.boxToByte((byte)2), BoxesRunTime.boxToDouble(this.similarityConfig().normOrgLegalformWeight()), x);
            }
        } else {
            throw new MatchError(tuple2);
        }
        Tuple2<Object, String> tuple22 = Countries$.MODULE$.toIsoCountry(nameElement);
        if (tuple22 != null) {
            String string3 = tuple22._2();
            if (BoxesRunTime.unboxToBoolean(tuple22._1()) && string3 != null) {
                String x = string3;
                return Tuple3$.MODULE$.apply(BoxesRunTime.boxToByte((byte)3), BoxesRunTime.boxToDouble(this.similarityConfig().normOrgCountryWeight()), x);
            }
        } else {
            throw new MatchError(tuple22);
        }
        return Tuple3$.MODULE$.apply(BoxesRunTime.boxToByte((byte)1), BoxesRunTime.boxToDouble(this.orgNameElementReducedWeight(nameElement, initWeight)), nameElement);
    }

    private final /* synthetic */ void normalizePersonName$$anonfun$1(ArrayBuffer mutNameElementCombinations$1, Vector e) {
        this.buildPersonNameElementCombinations(e, mutNameElementCombinations$1);
    }

    private final /* synthetic */ void normalizeOrganisationName$$anonfun$1(ArrayBuffer mutNameElementCombinations$2, Vector e) {
        this.buildOrganisationNameElementCombinations(e, mutNameElementCombinations$2);
    }

    private final /* synthetic */ Object buildWhitespaceVariations$$anonfun$1(int counter$tailLocal1$1, int length$1, Vector whitespaceSplit$1, BooleanRef scip$1, ArrayBuffer whitespaceCombination$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        Tuple2 e = tuple2;
        if (BoxesRunTime.unboxToInt(e._2()) == counter$tailLocal1$1 && counter$tailLocal1$1 + 1 < length$1) {
            Tuple2<Boolean, Boolean> tuple22 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToBoolean(this.persNameElementReducedWeight((String)e._1(), 1.0)._2$mcZ$sp()), BoxesRunTime.boxToBoolean(this.persNameElementReducedWeight((String)whitespaceSplit$1.apply(BoxesRunTime.unboxToInt(e._2()) + 1), 1.0)._2$mcZ$sp()));
            if (tuple22 != null && !tuple22._1$mcZ$sp() && tuple22._2$mcZ$sp()) {
                scip$1.elem = true;
                return BoxedUnit.UNIT;
            }
            Tuple2<Boolean, Boolean> tuple23 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToBoolean(Countries$.MODULE$.isCountry((String)e._1())), BoxesRunTime.boxToBoolean(Countries$.MODULE$.isCountry((String)whitespaceSplit$1.apply(BoxesRunTime.unboxToInt(e._2()) + 1))));
            if (tuple23 != null) {
                if (tuple23._1$mcZ$sp()) {
                    scip$1.elem = true;
                    return BoxedUnit.UNIT;
                }
                if (tuple23._2$mcZ$sp()) {
                    scip$1.elem = true;
                    return BoxedUnit.UNIT;
                }
            }
            return whitespaceCombination$1.$plus$eq(new StringBuilder(0).append((String)e._1()).append(whitespaceSplit$1.apply(BoxesRunTime.unboxToInt(e._2()) + 1)).toString());
        }
        Tuple2 e2 = tuple2;
        if (BoxesRunTime.unboxToInt(e2._2()) == counter$tailLocal1$1 + 1) {
            return BoxedUnit.UNIT;
        }
        Tuple2 e3 = tuple2;
        return whitespaceCombination$1.$plus$eq(e3._1());
    }

    private static final /* synthetic */ ListBuffer buildPersonNameElementCombinations$$anonfun$1$$anonfun$1(ListBuffer mutNameElementVariations$1, ArrayBuffer v) {
        return (ListBuffer)mutNameElementVariations$1.$plus$eq(v.toVector());
    }

    private final /* synthetic */ ListBuffer buildPersonNameElementCombinations$$anonfun$1(ListBuffer mutNameElementVariationsList$1, String e) {
        Object object;
        Vector<String> nameElementHyphenSplit = Predef$.MODULE$.wrapRefArray(e.split("-")).toVector();
        Object mutNameElementVariations = ListBuffer$.MODULE$.empty();
        int n = nameElementHyphenSplit.length();
        if (1 == n) {
            object = ((AbstractBuffer)mutNameElementVariations).$plus$eq(package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{(String)nameElementHyphenSplit.apply(false)})));
        } else {
            Object mutNameElementSubVariations = ArrayBuffer$.MODULE$.empty();
            this.buildWhitespaceVariations(nameElementHyphenSplit, (ArrayBuffer<ArrayBuffer<String>>)mutNameElementSubVariations, 0, nameElementHyphenSplit.length());
            ((AbstractIterable)mutNameElementSubVariations).foreach(arg_0 -> NameNormalizer.buildPersonNameElementCombinations$$anonfun$1$$anonfun$1((ListBuffer)mutNameElementVariations, arg_0));
            object = BoxedUnit.UNIT;
        }
        return (ListBuffer)mutNameElementVariationsList$1.$plus$eq(mutNameElementVariations);
    }

    private final /* synthetic */ Object buildPersonNameElementCombinations$$anonfun$2$$anonfun$1(ArrayBuffer mutNameElement$1, Vector e) {
        int n = e.length();
        if (1 == n) {
            return mutNameElement$1.$plus$eq(Tuple3$.MODULE$.apply(e.apply(false), BoxesRunTime.boxToDouble(this.persNameElementReducedWeight((String)e.apply(false), 1.0)._1$mcD$sp()), BoxesRunTime.boxToByte((byte)1)));
        }
        ((Vector)e.zipWithIndex()).foreach((Function1<Tuple2, ArrayBuffer> & Serializable)he -> {
            int n = BoxesRunTime.unboxToInt(he._2());
            if (0 == n) {
                return (ArrayBuffer)mutNameElement$1.$plus$eq(Tuple3$.MODULE$.apply(he._1(), BoxesRunTime.boxToDouble(this.firstNameElementReducedWeight((String)he._1(), 1.0)), BoxesRunTime.boxToByte((byte)1)));
            }
            return (ArrayBuffer)mutNameElement$1.$plus$eq(Tuple3$.MODULE$.apply(he._1(), BoxesRunTime.boxToDouble(this.firstNameElementReducedWeight((String)he._1(), 1.0 / (double)e.length())), BoxesRunTime.boxToByte((byte)1)));
        });
        return BoxedUnit.UNIT;
    }

    private static final /* synthetic */ ListBuffer buildOrganisationNameElementCombinations$$anonfun$1$$anonfun$1(ListBuffer mutNameElementVariations$2, ArrayBuffer v) {
        return (ListBuffer)mutNameElementVariations$2.$plus$eq(v.toVector());
    }

    private final /* synthetic */ ListBuffer buildOrganisationNameElementCombinations$$anonfun$1(ListBuffer mutNameElementVariationsList$2, String e) {
        Object object;
        Vector<String> nameElementHyphenSplit = Predef$.MODULE$.wrapRefArray(e.split("-")).toVector();
        Object mutNameElementVariations = ListBuffer$.MODULE$.empty();
        int n = nameElementHyphenSplit.length();
        if (1 == n) {
            object = ((AbstractBuffer)mutNameElementVariations).$plus$eq(package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{(String)nameElementHyphenSplit.apply(false)})));
        } else {
            Object mutNameElementSubVariations = ArrayBuffer$.MODULE$.empty();
            this.buildWhitespaceVariations(nameElementHyphenSplit, (ArrayBuffer<ArrayBuffer<String>>)mutNameElementSubVariations, 0, nameElementHyphenSplit.length());
            ((AbstractIterable)mutNameElementSubVariations).foreach(arg_0 -> NameNormalizer.buildOrganisationNameElementCombinations$$anonfun$1$$anonfun$1((ListBuffer)mutNameElementVariations, arg_0));
            object = BoxedUnit.UNIT;
        }
        return (ListBuffer)mutNameElementVariationsList$2.$plus$eq(mutNameElementVariations);
    }

    private final /* synthetic */ Object buildOrganisationNameElementCombinations$$anonfun$2$$anonfun$1(ArrayBuffer mutNameElement$3, Vector e) {
        int n = e.length();
        if (1 == n) {
            Tuple3<Object, Object, String> v = this.getOrgNameElementTypeWeightNorm((String)e.apply(false), 1.0);
            return mutNameElement$3.$plus$eq(Tuple3$.MODULE$.apply(v._3(), v._2(), v._1()));
        }
        ((Vector)e.zipWithIndex()).foreach((Function1<Tuple2, ArrayBuffer> & Serializable)he -> {
            int n = BoxesRunTime.unboxToInt(he._2());
            if (0 == n) {
                Tuple3<Object, Object, String> v = this.getOrgNameElementTypeWeightNorm((String)he._1(), 1.0);
                return (ArrayBuffer)mutNameElement$3.$plus$eq(Tuple3$.MODULE$.apply(v._3(), v._2(), v._1()));
            }
            Tuple3<Object, Object, String> v = this.getOrgNameElementTypeWeightNorm((String)he._1(), 1.0 / (double)e.length());
            return (ArrayBuffer)mutNameElement$3.$plus$eq(Tuple3$.MODULE$.apply(v._3(), v._2(), v._1()));
        });
        return BoxedUnit.UNIT;
    }
}

