/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;

final class FeatureQuery
extends Query {
    private final String fieldName;
    private final String featureName;
    private final FeatureField.FeatureFunction function;

    FeatureQuery(String fieldName, String featureName, FeatureField.FeatureFunction function) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.featureName = Objects.requireNonNull(featureName);
        this.function = Objects.requireNonNull(function);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        FeatureField.FeatureFunction rewritten = this.function.rewrite(indexSearcher);
        if (this.function != rewritten) {
            return new FeatureQuery(this.fieldName, this.featureName, rewritten);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureQuery that = (FeatureQuery)obj;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.function, that.function);
    }

    @Override
    public int hashCode() {
        int h = this.getClass().hashCode();
        h = 31 * h + this.fieldName.hashCode();
        h = 31 * h + this.featureName.hashCode();
        h = 31 * h + this.function.hashCode();
        return h;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        if (!scoreMode.needsScores()) {
            TermQuery tq = new TermQuery(new Term(this.fieldName, this.featureName));
            return searcher.rewrite(tq).createWeight(searcher, scoreMode, boost);
        }
        return new Weight(this){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                String desc = "weight(" + this.getQuery() + " in " + doc + ") [" + FeatureQuery.this.function + "]";
                Terms terms = context.reader().terms(FeatureQuery.this.fieldName);
                if (terms == null) {
                    return Explanation.noMatch(desc + ". Field " + FeatureQuery.this.fieldName + " doesn't exist.", new Explanation[0]);
                }
                TermsEnum termsEnum = terms.iterator();
                if (!termsEnum.seekExact(new BytesRef(FeatureQuery.this.featureName))) {
                    return Explanation.noMatch(desc + ". Feature " + FeatureQuery.this.featureName + " doesn't exist.", new Explanation[0]);
                }
                PostingsEnum postings = termsEnum.postings(null, 8);
                if (postings.advance(doc) != doc) {
                    return Explanation.noMatch(desc + ". Feature " + FeatureQuery.this.featureName + " isn't set.", new Explanation[0]);
                }
                return FeatureQuery.this.function.explain(FeatureQuery.this.fieldName, FeatureQuery.this.featureName, boost, postings.freq());
            }

            @Override
            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                final 1 thisWeight = this;
                Terms terms = Terms.getTerms(context.reader(), FeatureQuery.this.fieldName);
                final TermsEnum termsEnum = terms.iterator();
                if (!termsEnum.seekExact(new BytesRef(FeatureQuery.this.featureName))) {
                    return null;
                }
                final int docFreq = termsEnum.docFreq();
                return new ScorerSupplier(){
                    private boolean topLevelScoringClause = false;

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        Similarity.SimScorer scorer = FeatureQuery.this.function.scorer(boost);
                        LeafSimScorer simScorer = new LeafSimScorer(scorer, context.reader(), FeatureQuery.this.fieldName, false);
                        ImpactsEnum impacts = termsEnum.impacts(8);
                        return new TermScorer(thisWeight, impacts, simScorer, this.topLevelScoringClause);
                    }

                    @Override
                    public long cost() {
                        return docFreq;
                    }

                    @Override
                    public void setTopLevelScoringClause() throws IOException {
                        this.topLevelScoringClause = true;
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier supplier = this.scorerSupplier(context);
                if (supplier == null) {
                    return null;
                }
                return supplier.get(Long.MAX_VALUE);
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field2) {
        return "FeatureQuery(field=" + this.fieldName + ", feature=" + this.featureName + ", function=" + this.function + ")";
    }
}

