/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class FloatPoint
extends Field {
    public static float nextUp(float f) {
        if (Float.floatToIntBits(f) == Integer.MIN_VALUE) {
            return 0.0f;
        }
        return Math.nextUp(f);
    }

    public static float nextDown(float f) {
        if (Float.floatToIntBits(f) == 0) {
            return -0.0f;
        }
        return Math.nextDown(f);
    }

    private static FieldType getType(int numDims) {
        FieldType type = new FieldType();
        type.setDimensions(numDims, 4);
        type.freeze();
        return type;
    }

    @Override
    public void setFloatValue(float value) {
        this.setFloatValues(value);
    }

    public void setFloatValues(float ... point) {
        if (this.type.pointDimensionCount() != point.length) {
            throw new IllegalArgumentException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions");
        }
        this.fieldsData = FloatPoint.pack(point);
    }

    @Override
    public void setBytesValue(BytesRef bytes) {
        throw new IllegalArgumentException("cannot change value type from float to BytesRef");
    }

    @Override
    public Number numericValue() {
        if (this.type.pointDimensionCount() != 1) {
            throw new IllegalStateException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot convert to a single numeric value");
        }
        BytesRef bytes = (BytesRef)this.fieldsData;
        assert (bytes.length == 4);
        return Float.valueOf(FloatPoint.decodeDimension(bytes.bytes, bytes.offset));
    }

    public static BytesRef pack(float ... point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        byte[] packed = new byte[point.length * 4];
        for (int dim = 0; dim < point.length; ++dim) {
            FloatPoint.encodeDimension(point[dim], packed, dim * 4);
        }
        return new BytesRef(packed);
    }

    public FloatPoint(String name, float ... point) {
        super(name, FloatPoint.pack(point), (IndexableFieldType)FloatPoint.getType(point.length));
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        for (int dim = 0; dim < this.type.pointDimensionCount(); ++dim) {
            if (dim > 0) {
                result.append(',');
            }
            result.append(FloatPoint.decodeDimension(bytes.bytes, bytes.offset + dim * 4));
        }
        result.append('>');
        return result.toString();
    }

    public static void encodeDimension(float value, byte[] dest, int offset) {
        NumericUtils.intToSortableBytes(NumericUtils.floatToSortableInt(value), dest, offset);
    }

    public static float decodeDimension(byte[] value, int offset) {
        return NumericUtils.sortableIntToFloat(NumericUtils.sortableBytesToInt(value, offset));
    }

    public static Query newExactQuery(String field2, float value) {
        return FloatPoint.newRangeQuery(field2, value, value);
    }

    public static Query newRangeQuery(String field2, float lowerValue, float upperValue) {
        return FloatPoint.newRangeQuery(field2, new float[]{lowerValue}, new float[]{upperValue});
    }

    public static Query newRangeQuery(String field2, float[] lowerValue, float[] upperValue) {
        PointRangeQuery.checkArgs(field2, lowerValue, upperValue);
        return new PointRangeQuery(field2, FloatPoint.pack((float[])lowerValue).bytes, FloatPoint.pack((float[])upperValue).bytes, lowerValue.length){

            @Override
            protected String toString(int dimension, byte[] value) {
                return Float.toString(FloatPoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field2, float ... values) {
        final float[] sortedValues = (float[])values.clone();
        Arrays.sort(sortedValues);
        final BytesRef encoded = new BytesRef(new byte[4]);
        return new PointInSetQuery(field2, 1, 4, new PointInSetQuery.Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                FloatPoint.encodeDimension(sortedValues[this.upto], encoded.bytes, 0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 4);
                return Float.toString(FloatPoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field2, Collection<Float> values) {
        Float[] boxed = values.toArray(new Float[0]);
        float[] unboxed = new float[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            unboxed[i] = boxed[i].floatValue();
        }
        return FloatPoint.newSetQuery(field2, unboxed);
    }
}

