/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.BaseShapeDocValuesQuery;
import org.apache.lucene.document.LatLonShapeDocValues;
import org.apache.lucene.document.LatLonShapeQuery;
import org.apache.lucene.document.ShapeDocValues;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.SpatialQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Geometry;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.util.BytesRef;

final class LatLonShapeDocValuesQuery
extends BaseShapeDocValuesQuery {
    LatLonShapeDocValuesQuery(String field2, ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        super(field2, queryRelation, geometries);
    }

    @Override
    protected Component2D createComponent2D(Geometry ... geometries) {
        return LatLonGeometry.create((LatLonGeometry[])geometries);
    }

    @Override
    protected ShapeDocValues getShapeDocValues(BytesRef binaryValue) {
        return new LatLonShapeDocValues(binaryValue);
    }

    @Override
    public float matchCost() {
        return 6000.0f;
    }

    @Override
    protected SpatialQuery.SpatialVisitor getSpatialVisitor() {
        return LatLonShapeQuery.getSpatialVisitor(this.queryComponent2D);
    }
}

