/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;

public abstract class CodecReader
extends LeafReader {
    protected CodecReader() {
    }

    public abstract StoredFieldsReader getFieldsReader();

    public abstract TermVectorsReader getTermVectorsReader();

    public abstract NormsProducer getNormsReader();

    public abstract DocValuesProducer getDocValuesReader();

    public abstract FieldsProducer getPostingsReader();

    public abstract PointsReader getPointsReader();

    public abstract KnnVectorsReader getVectorReader();

    @Override
    @Deprecated
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        throw new UnsupportedOperationException("deprecated document access is not supported");
    }

    @Override
    @Deprecated
    public Fields getTermVectors(int docID) throws IOException {
        throw new UnsupportedOperationException("deprecated term vector access is not supported");
    }

    @Override
    public final StoredFields storedFields() throws IOException {
        final StoredFieldsReader reader = this.getFieldsReader();
        return new StoredFields(){

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                Objects.checkIndex(docID, CodecReader.this.maxDoc());
                reader.document(docID, visitor);
            }
        };
    }

    @Override
    public final TermVectors termVectors() throws IOException {
        TermVectorsReader reader = this.getTermVectorsReader();
        if (reader == null) {
            return TermVectors.EMPTY;
        }
        return reader;
    }

    @Override
    public final Terms terms(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null || fi.getIndexOptions() == IndexOptions.NONE) {
            return null;
        }
        return this.getPostingsReader().terms(field2);
    }

    private FieldInfo getDVField(String field2, DocValuesType type) {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public final NumericDocValues getNumericDocValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field2, DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getNumeric(fi);
    }

    @Override
    public final BinaryDocValues getBinaryDocValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field2, DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getBinary(fi);
    }

    @Override
    public final SortedDocValues getSortedDocValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field2, DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSorted(fi);
    }

    @Override
    public final SortedNumericDocValues getSortedNumericDocValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field2, DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedNumeric(fi);
    }

    @Override
    public final SortedSetDocValues getSortedSetDocValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field2, DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedSet(fi);
    }

    @Override
    public final NumericDocValues getNormValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.getNormsReader().getNorms(fi);
    }

    @Override
    public final PointValues getPointValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null || fi.getPointDimensionCount() == 0) {
            return null;
        }
        return this.getPointsReader().getValues(field2);
    }

    @Override
    public final FloatVectorValues getFloatVectorValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            return null;
        }
        return this.getVectorReader().getFloatVectorValues(field2);
    }

    @Override
    public final ByteVectorValues getByteVectorValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return null;
        }
        return this.getVectorReader().getByteVectorValues(field2);
    }

    @Override
    public final void searchNearestVectors(String field2, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            return;
        }
        this.getVectorReader().search(field2, target, knnCollector, acceptDocs);
    }

    @Override
    public final void searchNearestVectors(String field2, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return;
        }
        this.getVectorReader().search(field2, target, knnCollector, acceptDocs);
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        if (this.getPostingsReader() != null) {
            this.getPostingsReader().checkIntegrity();
        }
        if (this.getNormsReader() != null) {
            this.getNormsReader().checkIntegrity();
        }
        if (this.getDocValuesReader() != null) {
            this.getDocValuesReader().checkIntegrity();
        }
        if (this.getFieldsReader() != null) {
            this.getFieldsReader().checkIntegrity();
        }
        if (this.getTermVectorsReader() != null) {
            this.getTermVectorsReader().checkIntegrity();
        }
        if (this.getPointsReader() != null) {
            this.getPointsReader().checkIntegrity();
        }
        if (this.getVectorReader() != null) {
            this.getVectorReader().checkIntegrity();
        }
    }
}

