/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterBinaryDocValues;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FilterNumericDocValues;
import org.apache.lucene.index.FilterSortedDocValues;
import org.apache.lucene.index.FilterSortedNumericDocValues;
import org.apache.lucene.index.FilterSortedSetDocValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class ExitableDirectoryReader
extends FilterDirectoryReader {
    private final QueryTimeout queryTimeout;

    public ExitableDirectoryReader(DirectoryReader in, QueryTimeout queryTimeout) throws IOException {
        super(in, new ExitableSubReaderWrapper(queryTimeout));
        this.queryTimeout = Objects.requireNonNull(queryTimeout);
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        Objects.requireNonNull(this.queryTimeout, "Query timeout must not be null");
        return new ExitableDirectoryReader(in, this.queryTimeout);
    }

    public static DirectoryReader wrap(DirectoryReader in, QueryTimeout queryTimeout) throws IOException {
        Objects.requireNonNull(queryTimeout, "Query timeout must not be null");
        return new ExitableDirectoryReader(in, queryTimeout);
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    @Override
    public String toString() {
        return "ExitableDirectoryReader(" + this.in.toString() + ")";
    }

    public static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private static final int NUM_CALLS_PER_TIMEOUT_CHECK = 15;
        private int calls;
        private final QueryTimeout queryTimeout;

        public ExitableTermsEnum(TermsEnum termsEnum, QueryTimeout queryTimeout) {
            super(termsEnum);
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
            this.checkTimeoutWithSampling();
        }

        private void checkTimeoutWithSampling() {
            if ((this.calls++ & 0xF) == 0) {
                if (this.queryTimeout.shouldExit()) {
                    throw new ExitingReaderException("The request took too long to iterate over terms. Timeout: " + this.queryTimeout.toString() + ", TermsEnum=" + this.in);
                }
                if (Thread.interrupted()) {
                    throw new ExitingReaderException("Interrupted while iterating over terms. TermsEnum=" + this.in);
                }
            }
        }

        @Override
        public BytesRef next() throws IOException {
            this.checkTimeoutWithSampling();
            return this.in.next();
        }
    }

    public static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private QueryTimeout queryTimeout;

        public ExitableTerms(Terms terms, QueryTimeout queryTimeout) {
            super(terms);
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryTimeout);
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryTimeout);
        }

        @Override
        public BytesRef getMin() throws IOException {
            return this.in.getMin();
        }

        @Override
        public BytesRef getMax() throws IOException {
            return this.in.getMax();
        }
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 16;
        private PointValues.IntersectVisitor in;
        private final QueryTimeout queryTimeout;
        private int calls;

        private ExitableIntersectVisitor(QueryTimeout queryTimeout) {
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
        }

        private void setIntersectVisitor(PointValues.IntersectVisitor in) {
            this.in = in;
        }

        private void checkAndThrowWithSampling() {
            if (this.calls++ % 16 == 0) {
                this.checkAndThrow();
            }
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to intersect point values. Timeout: " + this.queryTimeout.toString() + ", PointValues=" + this.in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while intersecting point values. PointValues=" + this.in);
            }
        }

        @Override
        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.checkAndThrow();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        @Override
        public void grow(int count) {
            this.checkAndThrow();
            this.in.grow(count);
        }
    }

    private static class ExitablePointTree
    implements PointValues.PointTree {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 16;
        private final PointValues pointValues;
        private final PointValues.PointTree in;
        private final ExitableIntersectVisitor exitableIntersectVisitor;
        private final QueryTimeout queryTimeout;
        private int calls;

        private ExitablePointTree(PointValues pointValues, PointValues.PointTree in, QueryTimeout queryTimeout) {
            this.pointValues = pointValues;
            this.in = in;
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
            this.exitableIntersectVisitor = new ExitableIntersectVisitor(queryTimeout);
        }

        private void checkAndThrowWithSampling() {
            if (this.calls++ % 16 == 0) {
                this.checkAndThrow();
            }
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to intersect point values. Timeout: " + this.queryTimeout.toString() + ", PointValues=" + this.pointValues);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while intersecting point values. PointValues=" + this.in);
            }
        }

        @Override
        public PointValues.PointTree clone() {
            this.checkAndThrow();
            return new ExitablePointTree(this.pointValues, this.in.clone(), this.queryTimeout);
        }

        @Override
        public boolean moveToChild() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToChild();
        }

        @Override
        public boolean moveToSibling() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToSibling();
        }

        @Override
        public boolean moveToParent() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToParent();
        }

        @Override
        public byte[] getMinPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMaxPackedValue();
        }

        @Override
        public long size() {
            this.checkAndThrow();
            return this.in.size();
        }

        @Override
        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.checkAndThrow();
            this.in.visitDocIDs(visitor);
        }

        @Override
        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            this.checkAndThrow();
            this.exitableIntersectVisitor.setIntersectVisitor(visitor);
            this.in.visitDocValues(this.exitableIntersectVisitor);
        }
    }

    private static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryTimeout queryTimeout;

        private ExitablePointValues(PointValues in, QueryTimeout queryTimeout) {
            this.in = in;
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
            this.checkAndThrow();
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to iterate over point values. Timeout: " + this.queryTimeout.toString() + ", PointValues=" + this.in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while iterating over point values. PointValues=" + this.in);
            }
        }

        @Override
        public PointValues.PointTree getPointTree() throws IOException {
            this.checkAndThrow();
            return new ExitablePointTree(this.in, this.in.getPointTree(), this.queryTimeout);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            this.checkAndThrow();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            this.checkAndThrow();
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            this.checkAndThrow();
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            this.checkAndThrow();
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            this.checkAndThrow();
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            this.checkAndThrow();
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            this.checkAndThrow();
            return this.in.getDocCount();
        }
    }

    public static class ExitableFilterAtomicReader
    extends FilterLeafReader {
        private final QueryTimeout queryTimeout;
        static final int DOCS_BETWEEN_TIMEOUT_CHECK = 1000;

        public ExitableFilterAtomicReader(LeafReader in, QueryTimeout queryTimeout) {
            super(in);
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
        }

        @Override
        public PointValues getPointValues(String field2) throws IOException {
            PointValues pointValues = this.in.getPointValues(field2);
            if (pointValues == null) {
                return null;
            }
            return new ExitablePointValues(pointValues, this.queryTimeout);
        }

        @Override
        public Terms terms(String field2) throws IOException {
            Terms terms = this.in.terms(field2);
            if (terms == null) {
                return null;
            }
            return new ExitableTerms(terms, this.queryTimeout);
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public NumericDocValues getNumericDocValues(String field2) throws IOException {
            NumericDocValues numericDocValues = super.getNumericDocValues(field2);
            if (numericDocValues == null) {
                return null;
            }
            return new FilterNumericDocValues(numericDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field2) throws IOException {
            BinaryDocValues binaryDocValues = super.getBinaryDocValues(field2);
            if (binaryDocValues == null) {
                return null;
            }
            return new FilterBinaryDocValues(binaryDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public SortedDocValues getSortedDocValues(String field2) throws IOException {
            SortedDocValues sortedDocValues = super.getSortedDocValues(field2);
            if (sortedDocValues == null) {
                return null;
            }
            return new FilterSortedDocValues(sortedDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field2) throws IOException {
            SortedNumericDocValues sortedNumericDocValues = super.getSortedNumericDocValues(field2);
            if (sortedNumericDocValues == null) {
                return null;
            }
            return new FilterSortedNumericDocValues(sortedNumericDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field2) throws IOException {
            SortedSetDocValues sortedSetDocValues = super.getSortedSetDocValues(field2);
            if (sortedSetDocValues == null) {
                return null;
            }
            return new FilterSortedSetDocValues(sortedSetDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field2) throws IOException {
            FloatVectorValues vectorValues = this.in.getFloatVectorValues(field2);
            if (vectorValues == null) {
                return null;
            }
            return new ExitableFloatVectorValues(vectorValues);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field2) throws IOException {
            ByteVectorValues vectorValues = this.in.getByteVectorValues(field2);
            if (vectorValues == null) {
                return null;
            }
            return new ExitableByteVectorValues(vectorValues);
        }

        @Override
        public void searchNearestVectors(String field2, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            final Bits updatedAcceptDocs = acceptDocs == null ? new Bits.MatchAllBits(this.maxDoc()) : acceptDocs;
            Bits timeoutCheckingAcceptDocs = new Bits(){
                private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 16;
                private int calls;

                @Override
                public boolean get(int index) {
                    if (this.calls++ % 16 == 0) {
                        this.checkAndThrowForSearchVectors();
                    }
                    return updatedAcceptDocs.get(index);
                }

                @Override
                public int length() {
                    return updatedAcceptDocs.length();
                }
            };
            this.in.searchNearestVectors(field2, target, knnCollector, timeoutCheckingAcceptDocs);
        }

        @Override
        public void searchNearestVectors(String field2, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            final Bits updatedAcceptDocs = acceptDocs == null ? new Bits.MatchAllBits(this.maxDoc()) : acceptDocs;
            Bits timeoutCheckingAcceptDocs = new Bits(){
                private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 16;
                private int calls;

                @Override
                public boolean get(int index) {
                    if (this.calls++ % 16 == 0) {
                        this.checkAndThrowForSearchVectors();
                    }
                    return updatedAcceptDocs.get(index);
                }

                @Override
                public int length() {
                    return updatedAcceptDocs.length();
                }
            };
            this.in.searchNearestVectors(field2, target, knnCollector, timeoutCheckingAcceptDocs);
        }

        private void checkAndThrowForSearchVectors() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to search nearest vectors. Timeout: " + this.queryTimeout.toString() + ", Reader=" + this.in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while searching nearest vectors. Reader=" + this.in);
            }
        }

        private void checkAndThrow(DocIdSetIterator in) {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to iterate over doc values. Timeout: " + this.queryTimeout.toString() + ", DocValues=" + in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while iterating over doc values. DocValues=" + in);
            }
        }

        private class ExitableByteVectorValues
        extends ByteVectorValues {
            private int docToCheck;
            private final ByteVectorValues vectorValues;

            public ExitableByteVectorValues(ByteVectorValues vectorValues) {
                this.vectorValues = vectorValues;
                this.docToCheck = 0;
            }

            @Override
            public int advance(int target) throws IOException {
                int advance = this.vectorValues.advance(target);
                if (advance >= this.docToCheck) {
                    this.checkAndThrow();
                    this.docToCheck = advance + 1000;
                }
                return advance;
            }

            @Override
            public int docID() {
                return this.vectorValues.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                int nextDoc = this.vectorValues.nextDoc();
                if (nextDoc >= this.docToCheck) {
                    this.checkAndThrow();
                    this.docToCheck = nextDoc + 1000;
                }
                return nextDoc;
            }

            @Override
            public int dimension() {
                return this.vectorValues.dimension();
            }

            @Override
            public int size() {
                return this.vectorValues.size();
            }

            @Override
            public byte[] vectorValue() throws IOException {
                return this.vectorValues.vectorValue();
            }

            @Override
            public VectorScorer scorer(byte[] target) throws IOException {
                return this.vectorValues.scorer(target);
            }

            private void checkAndThrow() {
                if (ExitableFilterAtomicReader.this.queryTimeout.shouldExit()) {
                    throw new ExitingReaderException("The request took too long to iterate over vector values. Timeout: " + ExitableFilterAtomicReader.this.queryTimeout.toString() + ", ByteVectorValues=" + ExitableFilterAtomicReader.this.in);
                }
                if (Thread.interrupted()) {
                    throw new ExitingReaderException("Interrupted while iterating over vector values. ByteVectorValues=" + ExitableFilterAtomicReader.this.in);
                }
            }
        }

        private class ExitableFloatVectorValues
        extends FloatVectorValues {
            private int docToCheck;
            private final FloatVectorValues vectorValues;

            public ExitableFloatVectorValues(FloatVectorValues vectorValues) {
                this.vectorValues = vectorValues;
                this.docToCheck = 0;
            }

            @Override
            public int advance(int target) throws IOException {
                int advance = this.vectorValues.advance(target);
                if (advance >= this.docToCheck) {
                    this.checkAndThrow();
                    this.docToCheck = advance + 1000;
                }
                return advance;
            }

            @Override
            public int docID() {
                return this.vectorValues.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                int nextDoc = this.vectorValues.nextDoc();
                if (nextDoc >= this.docToCheck) {
                    this.checkAndThrow();
                    this.docToCheck = nextDoc + 1000;
                }
                return nextDoc;
            }

            @Override
            public int dimension() {
                return this.vectorValues.dimension();
            }

            @Override
            public float[] vectorValue() throws IOException {
                return this.vectorValues.vectorValue();
            }

            @Override
            public int size() {
                return this.vectorValues.size();
            }

            @Override
            public VectorScorer scorer(float[] target) throws IOException {
                return this.vectorValues.scorer(target);
            }

            private void checkAndThrow() {
                if (ExitableFilterAtomicReader.this.queryTimeout.shouldExit()) {
                    throw new ExitingReaderException("The request took too long to iterate over vector values. Timeout: " + ExitableFilterAtomicReader.this.queryTimeout.toString() + ", FloatVectorValues=" + ExitableFilterAtomicReader.this.in);
                }
                if (Thread.interrupted()) {
                    throw new ExitingReaderException("Interrupted while iterating over vector values. FloatVectorValues=" + ExitableFilterAtomicReader.this.in);
                }
            }
        }
    }

    public static class ExitableSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final QueryTimeout queryTimeout;

        public ExitableSubReaderWrapper(QueryTimeout queryTimeout) {
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
        }

        @Override
        public LeafReader wrap(LeafReader reader) {
            return new ExitableFilterAtomicReader(reader, this.queryTimeout);
        }
    }

    public static class ExitingReaderException
    extends RuntimeException {
        public ExitingReaderException(String msg) {
            super(msg);
        }
    }
}

