/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.hppc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.internal.hppc.AbstractIterator;
import org.apache.lucene.internal.hppc.BitMixer;
import org.apache.lucene.internal.hppc.BufferAllocationException;
import org.apache.lucene.internal.hppc.HashContainers;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.internal.hppc.ObjectCursor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class IntObjectHashMap<VType>
implements Iterable<IntObjectCursor<VType>>,
Accountable,
Cloneable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntObjectHashMap.class);
    public int[] keys;
    public Object[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public IntObjectHashMap() {
        this(4);
    }

    public IntObjectHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntObjectHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public IntObjectHashMap(IntObjectHashMap<VType> map) {
        this(map.size());
        this.putAll(map);
    }

    public VType put(int key2, VType value) {
        int existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key2 == 0) {
            Object previousValue = this.hasEmptyKey ? this.values[mask + 1] : null;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key2) {
                Object previousValue = this.values[slot];
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key2, value);
        } else {
            keys[slot] = key2;
            this.values[slot] = value;
        }
        ++this.assigned;
        return null;
    }

    public int putAll(Iterable<? extends IntObjectCursor<? extends VType>> iterable) {
        int count = this.size();
        for (IntObjectCursor<VType> intObjectCursor : iterable) {
            this.put(intObjectCursor.key, intObjectCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(int key2, VType value) {
        int keyIndex = this.indexOf(key2);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key2, value);
            return true;
        }
        return false;
    }

    public VType remove(int key2) {
        int existing;
        int mask = this.mask;
        if (key2 == 0) {
            if (!this.hasEmptyKey) {
                return null;
            }
            this.hasEmptyKey = false;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return (VType)previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key2) {
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public VType get(int key2) {
        int existing;
        if (key2 == 0) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key2) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public VType getOrDefault(int key2, VType defaultValue) {
        int existing;
        if (key2 == 0) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue);
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key2) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public boolean containsKey(int key2) {
        int existing;
        if (key2 == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key2) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public int indexOf(int key2) {
        int existing;
        int mask = this.mask;
        if (key2 == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key2) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public VType indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return (VType)this.values[index];
    }

    public VType indexReplace(int index, VType newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index];
        this.values[index] = newValue;
        return (VType)previousValue;
    }

    public void indexInsert(int index, int key2, VType value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key2 == 0) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key2, value);
            } else {
                this.keys[index] = key2;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    public VType indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index];
        if (index > this.mask) {
            assert (index == this.mask + 1);
            this.hasEmptyKey = false;
            this.values[index] = 0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return (VType)previousValue;
    }

    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (IntObjectCursor<VType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((IntObjectHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(IntObjectHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (IntObjectCursor<?> c : other) {
            int key2 = c.key;
            if (this.containsKey(key2) && Objects.equals(c.value, this.get(key2))) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<IntObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + this.sizeOfValues();
    }

    private long sizeOfValues() {
        long size = RamUsageEstimator.shallowSizeOf(this.values);
        for (ObjectCursor value : this.values()) {
            size += RamUsageEstimator.sizeOfObject(value);
        }
        return size;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    public ValuesContainer values() {
        return new ValuesContainer();
    }

    public IntObjectHashMap<VType> clone() {
        try {
            IntObjectHashMap cloned = (IntObjectHashMap)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <VType> IntObjectHashMap<VType> from(int[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntObjectHashMap<VType> map = new IntObjectHashMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(int key2) {
        assert (key2 != 0);
        return BitMixer.mixPhi(key2);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(int[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            int existing = fromKeys[from];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, int pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        int[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        int existing;
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values[gapSlot] = null;
        --this.assigned;
    }

    public static final class IntObjectCursor<VType> {
        public int index;
        public int key;
        public VType value;

        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.mask;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int mask = IntObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (IntObjectHashMap.this.keys[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = IntObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = IntObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    public final class ValuesContainer
    implements Iterable<ObjectCursor<VType>> {
        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        public int size() {
            return IntObjectHashMap.this.size();
        }

        public VType[] toArray() {
            Object[] array = new Object[this.size()];
            int i = 0;
            for (ObjectCursor cursor : this) {
                array[i++] = cursor.value;
            }
            return array;
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.mask;
        }

        @Override
        protected IntCursor fetch() {
            int mask = IntObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                int existing = IntObjectHashMap.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    public final class KeysContainer
    implements Iterable<IntCursor> {
        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        public int size() {
            return IntObjectHashMap.this.size();
        }

        public int[] toArray() {
            int[] array = new int[this.size()];
            int i = 0;
            for (IntCursor cursor : this) {
                array[i++] = cursor.value;
            }
            return array;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<IntObjectCursor<VType>> {
        private final IntObjectCursor<VType> cursor = new IntObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.mask;
        }

        @Override
        protected IntObjectCursor<VType> fetch() {
            int mask = IntObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                int existing = IntObjectHashMap.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = IntObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = 0;
                this.cursor.value = IntObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (IntObjectCursor)this.done();
        }
    }
}

