/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSetIterator;

public abstract class VectorFieldFunction
extends FunctionValues {
    protected final ValueSource valueSource;
    int lastDocID;

    protected VectorFieldFunction(ValueSource valueSource) {
        this.valueSource = valueSource;
    }

    protected abstract DocIdSetIterator getVectorIterator();

    @Override
    public String toString(int doc) throws IOException {
        return this.valueSource.description() + this.strVal(doc);
    }

    @Override
    public boolean exists(int doc) throws IOException {
        if (doc < this.lastDocID) {
            throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
        }
        this.lastDocID = doc;
        int curDocID = this.getVectorIterator().docID();
        if (doc > curDocID) {
            curDocID = this.getVectorIterator().advance(doc);
        }
        return doc == curDocID;
    }

    static void checkField(LeafReader in, String field2, VectorEncoding expectedEncoding) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field2);
        if (fi != null) {
            VectorEncoding actual;
            VectorEncoding vectorEncoding = actual = fi.hasVectorValues() ? fi.getVectorEncoding() : null;
            if (expectedEncoding != actual) {
                throw new IllegalStateException("Unexpected vector encoding (" + actual + ") for field " + field2 + "(expected=" + expectedEncoding + ")");
            }
        }
    }
}

