/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.ConjunctionMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatches;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalQuery;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.QueryVisitor;

abstract class ConjunctionIntervalsSource
extends IntervalsSource {
    protected final List<IntervalsSource> subSources;

    protected ConjunctionIntervalsSource(List<IntervalsSource> subSources) {
        assert (subSources.size() > 1);
        this.subSources = subSources;
    }

    @Override
    public void visit(String field2, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field2, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, parent);
        for (IntervalsSource source : this.subSources) {
            source.visit(field2, v);
        }
    }

    @Override
    public final IntervalIterator intervals(String field2, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIntervals = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalIterator it = source.intervals(field2, ctx);
            if (it == null) {
                return null;
            }
            subIntervals.add(it);
        }
        return this.combine(subIntervals);
    }

    protected abstract IntervalIterator combine(List<IntervalIterator> var1);

    protected IntervalMatchesIterator createMatchesIterator(IntervalIterator it, List<IntervalMatchesIterator> subs) {
        return new ConjunctionMatchesIterator(it, subs);
    }

    @Override
    public final IntervalMatchesIterator matches(String field2, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<IntervalMatchesIterator> subs = new ArrayList<IntervalMatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalMatchesIterator mi = source.matches(field2, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(mi);
        }
        IntervalIterator it = this.combine(subs.stream().map(m -> IntervalMatches.wrapMatches(m, doc)).collect(Collectors.toList()));
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return this.createMatchesIterator(it, subs);
    }
}

