/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.spans;

import org.apache.lucene.queries.spans.FilterSpans;
import org.apache.lucene.queries.spans.SpanPositionRangeQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.Spans;

public class SpanFirstQuery
extends SpanPositionRangeQuery {
    public SpanFirstQuery(SpanQuery match, int end) {
        super(match, 0, end);
    }

    @Override
    protected FilterSpans.AcceptStatus acceptPosition(Spans spans) {
        assert (spans.startPosition() != spans.endPosition()) : "start equals end: " + spans.startPosition();
        if (spans.startPosition() >= this.end) {
            return FilterSpans.AcceptStatus.NO_MORE_IN_CURRENT_DOC;
        }
        if (spans.endPosition() <= this.end) {
            return FilterSpans.AcceptStatus.YES;
        }
        return FilterSpans.AcceptStatus.NO;
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanFirst(");
        buffer.append(this.match.toString(field2));
        buffer.append(", ");
        buffer.append(this.end);
        buffer.append(")");
        return buffer.toString();
    }
}

