/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.spans;

import java.io.IOException;
import org.apache.lucene.queries.spans.FilterSpans;
import org.apache.lucene.queries.spans.SpanPositionCheckQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.Spans;

public class SpanPositionRangeQuery
extends SpanPositionCheckQuery {
    protected int start;
    protected int end;

    public SpanPositionRangeQuery(SpanQuery match, int start, int end) {
        super(match);
        this.start = start;
        this.end = end;
    }

    @Override
    protected FilterSpans.AcceptStatus acceptPosition(Spans spans) throws IOException {
        assert (spans.startPosition() != spans.endPosition());
        FilterSpans.AcceptStatus res = spans.startPosition() >= this.end ? FilterSpans.AcceptStatus.NO_MORE_IN_CURRENT_DOC : (spans.startPosition() >= this.start && spans.endPosition() <= this.end ? FilterSpans.AcceptStatus.YES : FilterSpans.AcceptStatus.NO);
        return res;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanPosRange(");
        buffer.append(this.match.toString(field2));
        buffer.append(", ").append(this.start).append(", ");
        buffer.append(this.end);
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanPositionRangeQuery other = (SpanPositionRangeQuery)o;
        return this.end == other.end && this.start == other.start;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode() ^ this.end;
        h = h * 127 ^ this.start;
        return h;
    }
}

